package com.aemformscs.documentservices;

import java.io.InputStream;
import java.io.InputStreamReader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;

public class GetServiceCredentials {
        private String IMS_ENDPOINT = null;
        private String CLIENT_ID = null;
        private String CLIENT_SECRET = null;
        private String METASCOPE_ID;
        private String TECH_ACCT = null;
        private String ORG_ID = null;
        private String PRIVATE_KEY = null;
        
        public GetServiceCredentials()
        {

                ClassLoader classLoader = getClass().getClassLoader();
                InputStream credentialsFiles = classLoader.getResourceAsStream("credentials/service_token.json");
                JsonReader jsonReader = new JsonReader(new InputStreamReader(credentialsFiles));

                JsonObject jsonObject = JsonParser.parseReader(jsonReader).getAsJsonObject();

                PRIVATE_KEY = jsonObject.get("integration").getAsJsonObject().get("privateKey").getAsString();

                CLIENT_ID = jsonObject.get("integration").getAsJsonObject().get("technicalAccount").getAsJsonObject().get("clientId").getAsString();

                METASCOPE_ID = jsonObject.get("integration").getAsJsonObject().get("metascopes").getAsString();

                TECH_ACCT = jsonObject.get("integration").getAsJsonObject().get("id").getAsString();

                ORG_ID = jsonObject.get("integration").getAsJsonObject().get("org").getAsString();
                CLIENT_SECRET = jsonObject.get("integration").getAsJsonObject().get("technicalAccount").getAsJsonObject().get("clientSecret").getAsString();
                IMS_ENDPOINT = jsonObject.get("integration").getAsJsonObject().get("imsEndpoint").getAsString();

        }

        public String getIMS_ENDPOINT() {
                System.out.println("The ims endpoint is " + IMS_ENDPOINT);
                return IMS_ENDPOINT;
        }

        public String getCLIENT_SECRET() {

                return CLIENT_SECRET;
        }

        public String getCLIENT_ID() {
                return CLIENT_ID;
        }

        public String getMETASCOPE_ID() {
                return METASCOPE_ID;
        }

        public String getTECH_ACCT() {
                return TECH_ACCT;
        }

        public String getORG_ID() {
                return ORG_ID;
        }

        public String getPRIVATE_KEY() {
                return PRIVATE_KEY;
        }

       
}