package com.aemformscs.documentservices;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;


public class CredentialUtilites {
public String getAccessToken() {
        
        String jwtToken = getJWTToken();
        GetServiceCredentials getCredentials = new GetServiceCredentials();
        System.out.println("Getting Access Token");

        try {
                HttpClient httpClient = HttpClientBuilder.create().build();
                HttpHost authServer = new HttpHost(getCredentials.getIMS_ENDPOINT(), 443, "https");
                HttpPost authPostRequest = new HttpPost("/ims/exchange/jwt");
                List < NameValuePair > nameValuePairs = new ArrayList < NameValuePair > ();
                nameValuePairs.add(new BasicNameValuePair("jwt_token", jwtToken));
                nameValuePairs.add(new BasicNameValuePair("client_id", getCredentials.getCLIENT_ID()));
                nameValuePairs.add(new BasicNameValuePair("client_secret", getCredentials.getCLIENT_SECRET()));
                authPostRequest.setEntity(new UrlEncodedFormEntity(nameValuePairs, Consts.UTF_8));
                HttpResponse response;
                response = httpClient.execute(authServer, authPostRequest);
                StatusLine statusLine = response.getStatusLine();
                System.out.println("The status code is " + statusLine.getStatusCode());
                HttpEntity result = response.getEntity();
                String jsonResponseStr = EntityUtils.toString(result);
                System.out.println(jsonResponseStr);
                JsonReader jsonReader = new JsonReader(new StringReader(jsonResponseStr));
                JsonObject jsonObject = JsonParser.parseReader(jsonReader).getAsJsonObject();
                
                System.out.println("Returning access_token " + jsonObject.get("access_token").getAsString());
                return jsonObject.get("access_token").getAsString();

        } catch (Exception e) {
                System.out.print("Error: " + e.getMessage());
        }
        return "null";

}
	public String getJWTToken()
	{
	        Security.addProvider(new BouncyCastleProvider());
	        RSAPrivateKey privateKey = null;
	        GetServiceCredentials getCredentials = new GetServiceCredentials();
	        try 
	        {

	            long now = System.currentTimeMillis();
	            Long expirationTime = now + TimeUnit.MINUTES.toMillis(5);
	            String privateKeyString = getCredentials.getPRIVATE_KEY();
	          //The JWT signature algorithm we will be using to sign the token
	            SignatureAlgorithm sa = SignatureAlgorithm.RS256;
	            
	            
	            Reader targetReader = new StringReader(privateKeyString);
	            // PEMParser removes the unnecessary headers and decodes the underlying Base64 PEM data into a binary format.
	            PEMParser pemParser = new PEMParser(targetReader);
	            // tores the result generated by the pEMParser
	            Object object = pemParser.readObject();
	            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
	            KeyPair kp = converter.getKeyPair((PEMKeyPair) object);
	            privateKey = (RSAPrivateKey) kp.getPrivate();
	            
	          //Let's set the JWT Claims

	            Map < String, Object > jwtClaims = new HashMap < String, Object > ();
	            jwtClaims.put("iss", getCredentials.getORG_ID());
	            jwtClaims.put("sub", getCredentials.getTECH_ACCT());
	            jwtClaims.put("exp", expirationTime);
	            jwtClaims.put("aud", "https://" + getCredentials.getIMS_ENDPOINT() + "/c/" + getCredentials.getCLIENT_ID());
	            String metascopes[] = new String[] { getCredentials.getMETASCOPE_ID() };
	                
	            for (String metascope: metascopes)
	            {
	                        jwtClaims.put("https://" + getCredentials.getIMS_ENDPOINT() + "/s/" + metascope, java.lang.Boolean.TRUE);
	            }

	            
	            // Create the final JWT token
	            String jwtToken = Jwts.builder().setClaims(jwtClaims).signWith(sa, privateKey).compact();
	                System.out.println("Got JWT Token " + jwtToken);
	                pemParser.close();
	            return jwtToken;

	        } catch (IOException e) {
	                // TODO Auto-generated catch block
	                System.out.println("The error is " + e.getMessage());
	        }
	        return null;

	}

}

