# Service Credentials Setup Guide

This guide walks you through setting up Service Credentials authentication for AEM asset uploads.

## Quick Setup (5 minutes)

### Step 1: Download Service Credentials

1. Go to [Adobe Cloud Manager](https://experience.adobe.com/#/@aem/cloud-manager)
2. Open your Program → Environment
3. Click "..." → **Developer Console**
4. Navigate to **Integrations** → **Technical Accounts**
5. Expand your Technical Account (or create a new one)
6. Expand the **Private Key** section
7. Click **"..." → View**
8. Click the **download button** and save as `service-credentials.json`

### Step 2: Place the File

Save the downloaded file in your project root directory:

```
aem-asset-upload-sample/
├── service-credentials.json    ← Place your file here
├── .env
├── package.json
└── ...
```

### Step 3: Update .env File

Add this line to your `.env` file:

```properties
AEM_SERVICE_CREDENTIALS_FILE=./service-credentials.json
```

**Complete .env example:**

```properties
# AEM Configuration
AEM_URL=https://author-p12345-e67890.adobeaemcloud.com
TARGET_FOLDER=/content/dam

# Authentication - Service Credentials (RECOMMENDED)
AEM_SERVICE_CREDENTIALS_FILE=./service-credentials.json

# Remote URLs for DirectBinaryUpload example
REMOTE_FILE_URL_1=https://placehold.co/600x400/red/white?text=AEM+Assets
```

### Step 4: Grant Permissions in AEM

Your technical account needs write permissions:

1. Log in to AEM Author as an administrator
2. Go to **Tools** → **Security** → **Users**
3. Search for your technical account (email from service credentials JSON)
4. Open **Properties** → **Groups** tab
5. Add to **DAM Users** group
6. Click **Save and Close**

### Step 5: Test the Connection

```bash
npm run verify
```

If successful, you're ready to upload!

```bash
npm start
```

## Security Notes

✅ **SAFE:**
- Service credentials file is automatically in `.gitignore`
- Private key is only used locally for JWT signing
- Access tokens are cached and auto-refreshed

❌ **NEVER:**
- Commit `service-credentials.json` to Git
- Share the JSON file in Slack/email
- Store credentials in application logs

## How It Works

```
┌─────────────────────────────────────────────────────────────┐
│ 1. Application reads service-credentials.json              │
│                                                             │
│ 2. Generates JWT using private key (@adobe/jwt-auth)       │
│                                                             │
│ 3. Exchanges JWT for access token from Adobe IMS           │
│                                                             │
│ 4. Uses access token as Bearer token in AEM API requests   │
│                                                             │
│ 5. Token cached for 24 hours, auto-refreshes when needed   │
└─────────────────────────────────────────────────────────────┘
```

## Troubleshooting

### "Service credentials file not found"
- Check the file path in `AEM_SERVICE_CREDENTIALS_FILE`
- Ensure the file exists in your project directory
- Try using an absolute path: `/Users/your-name/project/service-credentials.json`

### "Failed to generate access token"
- Check your internet connection (needs access to `ims-na1.adobelogin.com`)
- Verify service credentials haven't expired (valid for 365 days)
- Ensure the JSON file is complete and valid

### "403 Forbidden" when uploading
- The technical account needs proper AEM permissions
- Add user to **DAM Users** group in AEM (see Step 4 above)

## Additional Resources

- [Official Adobe Service Credentials Tutorial](https://experienceleague.adobe.com/en/docs/experience-manager-learn/getting-started-with-aem-headless/authentication/service-credentials)
- [AEM Developer Console Documentation](https://experienceleague.adobe.com/docs/experience-manager-cloud-service/content/implementing/developing/development-guidelines.html#accessing-developer-console)

---

**Questions?** Check the main [README.md](README.md) for complete documentation.

