/*
 * Decompiled with CFR 0.152.
 */
package com.variablelogger.core;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.VariableTemplate;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Log workflow process variables", "service.vendor=Adobe Systems", "process.label=Log workflow process variables"})
public class LogWorkflowVariables
implements WorkflowProcess {
    Logger log = LoggerFactory.getLogger(this.getClass());

    private void writeListOfString(String[] stringArray) {
        for (int i = 1; i <= stringArray.length; ++i) {
            this.log.debug("Got String " + stringArray[i]);
        }
    }

    private void writeListOfDocuments(Object[] documentsArray) {
        this.log.debug(" Got " + documentsArray.length + " files to write to file system");
        for (int i = 0; i < documentsArray.length; ++i) {
            Document attachment = (Document)documentsArray[i];
            try {
                String[] path = attachment.getAttribute("adobe.docmanager.attribute.filename").toString().split("/");
                this.log.debug("The attachment name is " + path[1]);
                attachment.copyToFile(new File(path[1]));
                attachment.close();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void writeDocument(Document documentToWrite, String key) {
        this.log.debug(" Writing Document  " + key);
        if (documentToWrite != null) {
            try {
                documentToWrite.copyToFile(new File(key + ".pdf"));
                documentToWrite.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        this.log.debug("Logging variable info for " + workItem.getWorkflow().getWorkflowModel().getTitle() + " workflow ");
        this.log.debug("Logging variable info for payload path " + workItem.getWorkflowData().getPayload().toString());
        MetaDataMap metaMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
        Map variableTemplateMap = workItem.getWorkflow().getWorkflowModel().getVariableTemplates();
        for (String key : variableTemplateMap.keySet()) {
            Document documentToWrite;
            VariableTemplate vt = (VariableTemplate)variableTemplateMap.get(key);
            this.log.debug("The variable  " + key + " is of type " + vt.getType() + " and its sub type is  " + vt.getSubType());
            if (vt.getType().equalsIgnoreCase("com.adobe.aemfd.docmanager.Document") && (documentToWrite = (Document)metaMap.get(key, Document.class)) != null) {
                this.writeDocument((Document)metaMap.get((Object)key), key);
            }
            if (vt.getType().equalsIgnoreCase("java.util.ArrayList")) {
                if (vt.getSubType().equalsIgnoreCase("com.adobe.aemfd.docmanager.Document")) {
                    this.log.debug("Got Array List " + key);
                    Object[] documentsArray = (Document[])metaMap.get(key, Document[].class);
                    if (documentsArray != null) {
                        this.writeListOfDocuments(documentsArray);
                    }
                }
                if (vt.getSubType().equalsIgnoreCase("java.lang.String")) {
                    this.log.debug("Got Array List of Strings " + key);
                    String[] stringArray = (String[])metaMap.get(key, String[].class);
                    if (stringArray != null) {
                        this.writeListOfString(stringArray);
                    }
                }
            }
            if (vt.getType().equalsIgnoreCase("java.util.Date")) {
                this.log.debug("Got Date  " + key);
                Date dateVariable = (Date)metaMap.get(key, Date.class);
                if (dateVariable != null) {
                    this.log.debug("The value of  " + key + " is  " + dateVariable.toString());
                }
            }
            if (vt.getType().equalsIgnoreCase("java.lang.Boolean")) {
                this.log.debug("Got Boolean " + key);
                Boolean booleanVariable = (Boolean)metaMap.get(key, Boolean.class);
                if (booleanVariable != null) {
                    this.log.debug("The value of " + key + " is  " + String.valueOf(booleanVariable));
                }
            }
            if (vt.getType().equalsIgnoreCase("org.w3c.dom.Document")) {
                this.log.debug("Got XML Document " + key);
                String xmlDocument = (String)metaMap.get(key, String.class);
                if (xmlDocument != null) {
                    this.log.debug("The value of xml Document is  " + xmlDocument);
                }
            }
            if (!vt.getType().equalsIgnoreCase("com.google.gson.JsonObject") && !vt.getType().equalsIgnoreCase("java.lang.String")) continue;
            this.log.debug("Got String/Json variable");
            if (metaMap.get((Object)key) == null) continue;
            this.log.debug("The value of  " + key + " is  " + metaMap.get((Object)key));
        }
        this.log.debug("Finished logging variable info for " + workItem.getWorkflow().getWorkflowModel().getTitle() + " workflow ");
        this.log.debug("Finished logging variable info for  payload path " + workItem.getWorkflowData().getPayload().toString());
    }
}

