/*
 * Decompiled with CFR 0.152.
 */
package com.saveAndResume.core.impl;

import com.adobe.aemfd.docmanager.Document;
import com.google.gson.JsonObject;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import com.saveAndResume.core.SaveAndFetchDataFromDB;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.sql.DataSource;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SaveAndFetchDataFromDB.class}, immediate=true)
public class SaveAndResume
implements SaveAndFetchDataFromDB {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(target="(&(objectclass=javax.sql.DataSource)(datasource.name=StoreAndRetrieveAfData))")
    private DataSource dataSource;
    @Reference
    GetResolver getResolver;

    @Override
    public String getData(String guid) {
        this.log.debug("### inside my getData of SaveAndResume");
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            String query = "SELECT afdata FROM aemformstutorial.formdatawithattachments where guid = '" + guid + "'";
            this.log.debug(" Got Result Set" + query);
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                return rs.getString("afdata");
            }
        }
        catch (SQLException e) {
            this.log.debug(e.getMessage());
        }
        return null;
    }

    public Connection getConnection() {
        this.log.debug("Getting Connection ");
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            this.log.debug("got connection");
            return con;
        }
        catch (Exception e) {
            this.log.debug("not able to get connection ");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonObject getAFFormDataWithAttachments(String guid) {
        this.log.debug("### inside my getData of AF with attachments info");
        JsonObject afDataObject = new JsonObject();
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            String query = "SELECT afdata,attachmentsInfo FROM aemformstutorial.formdatawithattachments where guid = '" + guid + "'";
            this.log.debug(" Got Result Set" + query);
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                afDataObject.addProperty("afData", rs.getString("afdata"));
                afDataObject.addProperty("afAttachments", rs.getString("attachmentsInfo"));
                JsonObject jsonObject = afDataObject;
                return jsonObject;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMobileNumber(String guid) {
        this.log.debug("### inside get Mobile Number with attachments info");
        JsonObject afDataObject = new JsonObject();
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            String query = "SELECT telephoneNumber FROM aemformstutorial.formdatawithattachments where guid = '" + guid + "'";
            this.log.debug(" Got Result Set" + query);
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                afDataObject.addProperty("mobileNumber", rs.getString("telephoneNumber"));
                String string = afDataObject.toString();
                return string;
            }
        }
        catch (SQLException e) {
            this.log.debug(e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                this.log.debug(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public String storeAFAttachments(JsonObject fileMap, SlingHttpServletRequest request) {
        JsonObject newFileMap = new JsonObject();
        try {
            Iterator keys = fileMap.keySet().iterator();
            this.log.debug("The file map is  " + fileMap.toString());
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.log.debug("#### The key is " + key);
                String attachmenPath = fileMap.get(key).getAsString();
                this.log.debug("The attachment path is " + attachmenPath);
                if (!attachmenPath.contains("/content/afattachments")) {
                    String fileName = attachmenPath.split("/")[1];
                    this.log.debug("#### The attachment name  is " + fileName);
                    InputStream is = request.getPart(attachmenPath).getInputStream();
                    Document aemFDDocument = new Document(is);
                    String crxPath = this.saveDocumentInCrx("/content/afattachments", fileName, aemFDDocument);
                    this.log.debug(" ##### written to crx repository  " + attachmenPath.split("/")[1]);
                    newFileMap.addProperty(key, crxPath);
                    continue;
                }
                this.log.debug("$$$$ The attachment was already added " + key);
                this.log.debug("$$$$ The attachment path is " + attachmenPath);
                int position = attachmenPath.indexOf("//");
                this.log.debug("$$$$ After substring " + attachmenPath.substring(position + 1));
                this.log.debug("$$$$ After splitting " + attachmenPath.split("/")[1]);
                newFileMap.addProperty(key, attachmenPath.substring(position + 1));
            }
        }
        catch (Exception ex) {
            this.log.debug(ex.getMessage());
        }
        this.log.debug("$$$$ The new file map is " + newFileMap.toString());
        return newFileMap.toString();
    }

    public String saveDocumentInCrx(String jcrPath, String fileName, Document documentToSave) {
        this.log.debug("Storing in crx" + jcrPath);
        this.log.debug("Storing in CRX  " + jcrPath);
        ResourceResolver serviceResolver = this.getResolver.getFormsServiceResolver();
        this.log.debug("Got Resolver");
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        try {
            Node afAttachmentsNode = (Node)serviceResolver.getResource(jcrPath).adaptTo(Node.class);
            Node newNode = afAttachmentsNode.addNode(uuidString, "nt:folder");
            this.log.debug("Got AF Attachments Node" + afAttachmentsNode.getPath());
            Node afAttachment = newNode.addNode(fileName, "nt:file");
            Node resNode = afAttachment.addNode("jcr:content", "nt:resource");
            this.log.debug("Got resNode " + resNode.getPath());
            Session session = (Session)serviceResolver.adaptTo(Session.class);
            ValueFactory valueFactory = session.getValueFactory();
            Binary contentValue = valueFactory.createBinary(documentToSave.getInputStream());
            resNode.setProperty("jcr:data", contentValue);
            serviceResolver.commit();
            this.log.debug("committed");
            return afAttachment.getPath();
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            this.log.debug("The ocrFiles node was created");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String storeFormData(String formData, String attachmentsInfo, String mobileNumber) {
        this.log.debug("******Inside my AEMFormsWith DB service*****");
        this.log.debug("### Inserting data ... " + formData + "and the telephone number to insert is  " + mobileNumber);
        String insertRowSQL = "INSERT INTO aemformstutorial.formdatawithattachments(guid,afdata,attachmentsInfo,telephoneNumber) VALUES(?,?,?,?)";
        UUID uuid = UUID.randomUUID();
        String randomUUIDString = uuid.toString();
        this.log.debug("The insert query is INSERT INTO aemformstutorial.formdatawithattachments(guid,afdata,attachmentsInfo,telephoneNumber) VALUES(?,?,?,?)");
        Connection c = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = null;
            pstmt = c.prepareStatement("INSERT INTO aemformstutorial.formdatawithattachments(guid,afdata,attachmentsInfo,telephoneNumber) VALUES(?,?,?,?)");
            pstmt.setString(1, randomUUIDString);
            pstmt.setString(2, formData);
            pstmt.setString(3, attachmentsInfo);
            pstmt.setString(4, mobileNumber);
            this.log.debug("Executing the insert statment  " + pstmt.executeUpdate());
            c.commit();
        }
        catch (SQLException e) {
            this.log.error("unable to insert data in the table", (Object)e.getMessage());
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e1) {
                    this.log.debug("error in closing prepared statement " + e1.getMessage());
                }
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e1) {
                    this.log.debug("error in closing connection " + e1.getMessage());
                }
            }
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e2) {
                    this.log.debug("error in closing prepared statement " + e2.getMessage());
                }
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e2) {
                    this.log.debug("error in closing connection " + e2.getMessage());
                }
            }
        }
        return randomUUIDString;
    }
}

