/*
 * Decompiled with CFR 0.152.
 */
package saveandresume.core.servlets;

import com.google.gson.JsonObject;
import com.saveAndResume.core.SaveAndFetchDataFromDB;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import saveandresume.core.servlets.SyntheticSlingHttpServletGetRequest;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/renderaf"})
public class RenderFormWithDataAndAttachments
extends SlingAllMethodsServlet {
    @Reference
    SaveAndFetchDataFromDB saveAndFetchFromDB;
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public Document w3cDocumentFromStrng(String xmlString) {
        try {
            this.log.debug("Inside w3cDocumentFromString");
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xmlString));
            return db.parse(is);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            return null;
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException {
        this.log.debug("In do POST ######");
        String applicationNo = "/afData/afUnboundData/data/ApplicationNumber";
        String submittedData = request.getParameter("jcr:data");
        Document submittedXml = this.w3cDocumentFromStrng(submittedData);
        XPath xPath = XPathFactory.newInstance().newXPath();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            this.log.debug("The param Name is " + paramName);
            String data = request.getParameter(paramName);
            this.log.debug("The data  is " + data);
        }
        SyntheticSlingHttpServletGetRequest syntheticRequest = new SyntheticSlingHttpServletGetRequest(request);
        try {
            Node applicationNode = (Node)xPath.compile(applicationNo).evaluate(submittedXml, XPathConstants.NODE);
            this.log.debug("The application number we got was " + applicationNode.getTextContent());
            JsonObject afDataObject = this.saveAndFetchFromDB.getAFFormDataWithAttachments(applicationNode.getTextContent());
            this.log.debug("$$$$ The data that is set in request object is " + afDataObject.get("afData").getAsString());
            request.setAttribute("data", (Object)afDataObject.get("afData").getAsString());
            JsonObject customMap = new JsonObject();
            customMap.addProperty("fileAttachmentMap", afDataObject.get("afAttachments").getAsString());
            request.setAttribute("customContextProperty", (Object)customMap.toString());
            request.getRequestDispatcher("/content/forms/af/storeafwithattachments.html").forward((ServletRequest)syntheticRequest, (ServletResponse)response);
        }
        catch (IOException | ServletException | XPathExpressionException exception) {
            exception.printStackTrace();
        }
    }
}

