/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.saveandfetchfromazure.impl;

import com.aemforms.saveandfetchfromazure.StoreAndFetchDataFromAzureStorage;
import com.azure.portal.configuration.service.AzurePortalConfigurationService;
import java.io.IOException;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={StoreAndFetchDataFromAzureStorage.class}, immediate=true)
public class SaveAndFetchFromAzure
implements StoreAndFetchDataFromAzureStorage {
    @Reference
    AzurePortalConfigurationService azurePortalConfigurationService;
    Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String saveFormDatainAzure(String formData) {
        this.log.debug("in SaveFormData!!!!!" + formData);
        String sasToken = this.azurePortalConfigurationService.getSASToken();
        String storageURI = this.azurePortalConfigurationService.getStorageURI();
        this.log.debug("The SAS Token is " + sasToken);
        this.log.debug("The Storage URL is " + storageURI);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        UUID uuid = UUID.randomUUID();
        String putRequestURL = storageURI + uuid.toString();
        putRequestURL = putRequestURL + sasToken;
        HttpPut httpPut = new HttpPut(putRequestURL);
        httpPut.addHeader("x-ms-blob-type", "BlockBlob");
        httpPut.addHeader("Content-Type", "text/plain");
        try {
            httpPut.setEntity((HttpEntity)new StringEntity(formData));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
            this.log.debug("Response code " + response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() == 201) {
                return uuid.toString();
            }
        }
        catch (IOException e) {
            this.log.debug("Error: " + e.getMessage());
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public String getBlobData(String blobID) {
        String sasToken = this.azurePortalConfigurationService.getSASToken();
        String storageURI = this.azurePortalConfigurationService.getStorageURI();
        this.log.debug("The SAS Token is " + sasToken);
        this.log.debug("The Storage URL is " + storageURI);
        String httpGetURL = storageURI + blobID;
        httpGetURL = httpGetURL + sasToken;
        HttpGet httpGet = new HttpGet(httpGetURL);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = httpResponse.getEntity();
            String blobData = EntityUtils.toString((HttpEntity)httpEntity);
            this.log.debug("The blob data I got was " + blobData);
            return blobData;
        }
        catch (ClientProtocolException e) {
            this.log.debug("Got Client Protocol Exception " + e.getMessage());
        }
        catch (IOException e) {
            this.log.debug("Got IOEXception " + e.getMessage());
        }
        return null;
    }
}

