/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.saveandcontinue.core.impl;

import com.aemforms.saveandcontinue.core.FetchStoredFormData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class FetchFormData
implements FetchStoredFormData {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(target="(&(objectclass=javax.sql.DataSource)(datasource.name=SaveAndContinue))")
    private DataSource dataSource;

    @Override
    public String getData(String guid) {
        this.log.debug("### inside my getData of AemformWithDB");
        Connection con = this.getConnection();
        try {
            Statement st = con.createStatement();
            String query = "SELECT afdata FROM aemformstutorial.formdata where guid = '" + guid + "'";
            this.log.debug(" Got Result Set" + query);
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                return rs.getString("afdata");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Connection getConnection() {
        this.log.debug("Getting Connection ");
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            this.log.debug("got connection");
            return con;
        }
        catch (Exception e) {
            this.log.debug("not able to get connection ");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String storeFormData(String formData) {
        this.log.debug("******Inside my AEMFormsWith DB service*****");
        this.log.debug("### Inserting data ... " + formData);
        String insertRowSQL = "INSERT INTO aemformstutorial.formdata(guid,afdata) VALUES(?,?)";
        UUID uuid = UUID.randomUUID();
        String randomUUIDString = uuid.toString();
        this.log.debug("The insert query is " + insertRowSQL);
        Connection c = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = null;
            pstmt = c.prepareStatement(insertRowSQL);
            pstmt.setString(1, randomUUIDString);
            pstmt.setString(2, formData);
            this.log.debug("Executing the insert statment  " + pstmt.executeUpdate());
            c.commit();
        }
        catch (SQLException e) {
            this.log.error("unable to insert data in the table", (Object)e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    this.log.debug("error in closing prepared statement " + e.getMessage());
                }
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    this.log.debug("error in closing connection " + e.getMessage());
                }
            }
        }
        return randomUUIDString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateData(String guid, String afData) {
        String updateTableSQL = "update aemformstutorial.formdata set afdata= ? where guid = ?";
        Connection c = this.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = null;
            pstmt = c.prepareStatement(updateTableSQL);
            pstmt.setString(1, afData);
            pstmt.setString(2, guid);
            this.log.debug("Executing the insert statment  " + pstmt.executeUpdate());
        }
        catch (SQLException e) {
            this.log.debug("Getting errors", (Object)e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return guid;
    }
}

