const https = require('https');
const fs = require('fs');

const hostname = '127.0.0.1';
const port = 3000;

const options = {
    key: fs.readFileSync('src/certs/server-key.pem'),
    cert: fs.readFileSync('src/certs/server-cert.pem')
};

const server = https.createServer(options, function (req, res) {
    res.statusCode = 200;

    res.setHeader('Content-Type', 'text/json');

    let today = new Date();
    let date = today.getFullYear() + '-' + (today.getMonth() + 1) + '-' + today.getDate();
    let time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();

    let now = {
        "date": date,
        "time": time
    }

    res.end(JSON.stringify(now));
});

server.listen(port, hostname, () => {
    console.log(`Server running at https://${hostname}:${port}/`);
}); 