/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.mobileforms.core.schedulers;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={Runnable.class})
public class SimpleScheduledTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String myParameter;

    @Override
    public void run() {
        this.logger.debug("SimpleScheduledTask is now running, myParameter='{}'", (Object)this.myParameter);
    }

    @Activate
    protected void activate(Config config) {
        this.myParameter = config.myParameter();
    }

    @ObjectClassDefinition(name="A scheduled task", description="Simple demo for cron-job like task with properties")
    public static @interface Config {
        @AttributeDefinition(name="Cron-job expression")
        public String scheduler_expression() default "*/30 * * * * ?";

        @AttributeDefinition(name="Concurrent task", description="Whether or not to schedule this task concurrently")
        public boolean scheduler_concurrent() default false;

        @AttributeDefinition(name="A parameter", description="Can be configured in /system/console/configMgr")
        public String myParameter() default "";
    }
}

