/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.mobileforms.core.servlets;

import com.aemforms.mobileforms.core.configuration.service.AemServerCredentialsConfigurationService;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/startworkflow"})
public class StartWorkflow
extends SlingAllMethodsServlet {
    private static Logger logger = LoggerFactory.getLogger(StartWorkflow.class);
    @Reference
    private GetResolver getResolver;
    @Reference
    private AemServerCredentialsConfigurationService aemServerCredentialsConfigurationService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String xmlData = null;
        logger.debug("in start workflow");
        response.setContentType("text/html;charset=UTF-8");
        if (request.getParameter("xmlData") != null) {
            logger.debug("The form was submitted from Acrobat/Reader");
            xmlData = request.getParameter("xmlData");
            System.out.println("in start workflow" + xmlData);
        }
        logger.debug("Trying to get resource  " + this.aemServerCredentialsConfigurationService.getFolderPath());
        Resource r = this.getResolver.getFormsServiceResolver().getResource(this.aemServerCredentialsConfigurationService.getFolderPath());
        String responseMessage = null;
        if (r != null) {
            Session session = (Session)r.getResourceResolver().adaptTo(Session.class);
            logger.debug("Got reosurce pdfsubmissions" + r.getPath());
            UUID uidName = UUID.randomUUID();
            Node xmlDataFilesNode = (Node)r.adaptTo(Node.class);
            ByteArrayInputStream is = new ByteArrayInputStream(xmlData.getBytes());
            try {
                Node xmlFileNode = xmlDataFilesNode.addNode(uidName.toString(), "nt:file");
                logger.debug("Added nt file node");
                Node jcrContent = xmlFileNode.addNode("jcr:content", "nt:resource");
                logger.debug("Added jcr content");
                Binary binary = session.getValueFactory().createBinary((InputStream)is);
                jcrContent.setProperty("jcr:data", binary);
                session.save();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            responseMessage = "Your form was successfully submitted";
        } else {
            logger.debug("The resource IS NULL");
            responseMessage = "Error is processing your submission!!!. Please contact the administrator";
        }
        try {
            response.setContentType("text/plain");
            response.getWriter().write(responseMessage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

