/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.mobileforms.core.servlets;

import com.aemforms.mobileforms.core.configuration.service.AemServerCredentialsConfigurationService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import javax.servlet.Servlet;
import javax.servlet.ServletInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/handleformsubmission"})
public class HandleFormSubmission
extends SlingAllMethodsServlet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    AemServerCredentialsConfigurationService aemServerCredentialsConfigurationService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        System.out.println("In do POST of bin/handleformsubmission");
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int length;
            ServletInputStream is = request.getInputStream();
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            this.logger.debug(result.toString(StandardCharsets.UTF_8.name()));
            System.out.println(result.toString(StandardCharsets.UTF_8.name()));
        }
        catch (IOException e1) {
            this.logger.error("An error occurred", (Throwable)e1);
        }
        String postURL = this.aemServerCredentialsConfigurationService.getWorkflowServer();
        this.logger.debug("The url to invoke workflow is  " + postURL);
        HttpPost postReq = new HttpPost(postURL);
        String userName = this.aemServerCredentialsConfigurationService.getUserName();
        String password = this.aemServerCredentialsConfigurationService.getPassword();
        String credential = userName + ":" + password;
        String encodedString = Base64.getEncoder().encodeToString(credential.getBytes());
        postReq.addHeader("Authorization", "Basic " + encodedString);
        System.out.println("The encoded string is Basic " + encodedString);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        this.logger.debug("added url parameters");
        try {
            urlParameters.add(new BasicNameValuePair("xmlData", result.toString(StandardCharsets.UTF_8.name())));
            postReq.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)postReq);
            this.logger.debug("Sent request to author instance");
            String startWorkflowResponse = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.write(startWorkflowResponse);
        }
        catch (IOException e) {
            this.logger.error("An error occurred", (Throwable)e);
        }
    }
}

