/*
 * Decompiled with CFR 0.152.
 */
package com.aemforms.createstringarray.core;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Session;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Create String Array", "service.vendor=Adobe Systems", "process.label=Replace comma seperated string with string array"})
public class CreateStringArray
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CreateStringArray.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap arg2) throws WorkflowException {
        log.debug("The string I got was ..." + ((String)arg2.get("PROCESS_ARGS", (Object)"string")).toString());
        String[] arguments = ((String)arg2.get("PROCESS_ARGS", (Object)"string")).toString().split(",");
        String objectName = arguments[0];
        String propertyName = arguments[1];
        String[] objects = objectName.split("\\.");
        log.debug("The params is " + propertyName);
        log.debug("The params string is " + objectName);
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        log.debug("The payload  in set Elmement Value in Json is  " + workItem.getWorkflowData().getPayload().toString());
        String dataFilePath = payloadPath + "/Data.xml/jcr:content";
        Session session = (Session)workflowSession.adaptTo(Session.class);
        Node submittedDataNode = null;
        try {
            String[] businessUnitsArray;
            String inputStr;
            submittedDataNode = session.getNode(dataFilePath);
            InputStream submittedDataStream = submittedDataNode.getProperty("jcr:data").getBinary().getStream();
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(submittedDataStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((inputStr = streamReader.readLine()) != null) {
                stringBuilder.append(inputStr);
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse(stringBuilder.toString()).getAsJsonObject();
            log.debug("The json object that I got was " + jsonObject);
            JsonObject targetObject = null;
            for (int i = 0; i < objects.length - 1; ++i) {
                log.debug("The object name is " + objects[i]);
                targetObject = i == 0 ? jsonObject.get(objects[i]).getAsJsonObject() : targetObject.get(objects[i]).getAsJsonObject();
            }
            log.debug("The final object is " + targetObject.toString());
            String businessUnits = targetObject.get(propertyName).getAsString();
            log.debug("The values of " + propertyName + " are " + businessUnits);
            JsonArray jsonArray = new JsonArray();
            for (String name : businessUnitsArray = businessUnits.split(",")) {
                jsonArray.add(name);
            }
            targetObject.add(propertyName, (JsonElement)jsonArray);
            log.debug(" After updating the property " + targetObject.toString());
            ByteArrayInputStream is = new ByteArrayInputStream(jsonObject.toString().getBytes());
            log.debug("The changed json data  is " + jsonObject.toString());
            Binary binary = session.getValueFactory().createBinary((InputStream)is);
            submittedDataNode.setProperty("jcr:data", binary);
            session.save();
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
    }
}

