/*
 * Decompiled with CFR 0.152.
 */
package com.acrobatsign.core.servlets;

import com.acrobatsign.core.PrintChannelDocumentHelperMethods;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/getwidgeturl"})
public class GetWidgetUrl
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(GetWidgetUrl.class);
    @Reference
    PrintChannelDocumentHelperMethods printChannelDocument;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        try {
            String jsonString = IOUtils.toString((InputStream)request.getInputStream(), (String)StandardCharsets.UTF_8.name());
            log.debug("####Form Data is  " + jsonString);
            JsonObject jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
            log.debug("The json object is " + jsonObject.toString());
            String icTemplate = jsonObject.get("icTemplate").getAsString();
            log.debug("The icTemplate is " + icTemplate);
            ByteArrayInputStream targetStream = new ByteArrayInputStream(jsonString.getBytes());
            String widgetURL = this.printChannelDocument.getPrintChannelDocument(icTemplate, targetStream);
            log.debug("The widget url is " + widgetURL);
            JsonObject jsonResponse = new JsonObject();
            jsonResponse.addProperty("widgetURL", widgetURL);
            PrintWriter out = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            out.println(jsonResponse.toString());
            out.flush();
        }
        catch (Exception e) {
            log.debug("The error is :" + e.getMessage());
        }
    }
}

