/*
 * Decompiled with CFR 0.152.
 */
package com.acrobatsign.core.impl;

import com.acrobatsign.core.AcrobatSignHelperMethods;
import com.acrobatsign.core.configuration.AcrobatSignConfigurationService;
import com.adobe.aemfd.docmanager.Document;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AcrobatSignHelperMethods.class}, immediate=true)
public class AcrobatSignHelperMethodsImpl
implements AcrobatSignHelperMethods {
    @Reference
    AcrobatSignConfigurationService acrobatSignConfig;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getTransientDocumentID(Document documentForSigning) throws IOException {
        String integrationKey = this.acrobatSignConfig.getIntegrationKey();
        String apiUser = this.acrobatSignConfig.getApiUserEmail();
        String url = "https://api.na1.adobesign.com/api/rest/v6/transientDocuments";
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("x-api-user", "email:" + apiUser);
        httpPost.addHeader("Authorization", "Bearer " + integrationKey);
        builder.addBinaryBody("File", documentForSigning.getInputStream(), ContentType.DEFAULT_BINARY, "NDA.PDF");
        builder.addTextBody("File-Name", "NDA.pdf");
        HttpEntity entity = builder.build();
        this.log.debug("Build the entity");
        httpPost.setEntity(entity);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        this.log.debug("Sent the request!!!!");
        this.log.debug("REsponse code " + response.getStatusLine().getStatusCode());
        HttpEntity httpEntity = response.getEntity();
        String transientDocumentId = JsonParser.parseString((String)EntityUtils.toString((HttpEntity)httpEntity)).getAsJsonObject().get("transientDocumentId").getAsString();
        this.log.debug("Transient ID  " + transientDocumentId);
        return transientDocumentId;
    }

    @Override
    public String getWidgetID(String transientDocumentID) {
        String integrationKey = this.acrobatSignConfig.getIntegrationKey();
        String apiUser = this.acrobatSignConfig.getApiUserEmail();
        String url = "https://api.na1.adobesign.com:443/api/rest/v6/widgets";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("x-api-user", "email:" + apiUser);
        httpPost.addHeader("Authorization", "Bearer " + integrationKey);
        String jsonREquest = "{\r\n  \"fileInfos\": [\r\n    {\r\n      \"transientDocumentId\": \"a\"\r\n    }\r\n  ],\r\n  \"name\": \"Release and Waiver Agreement\",\r\n  \"state\": \"ACTIVE\",\r\n  \"widgetParticipantSetInfo\": {\r\n    \"memberInfos\": [\r\n      {\r\n        \"email\": \"\"\r\n      }\r\n    ],\r\n    \"role\": \"SIGNER\"\r\n  }\r\n}";
        JsonObject jsonReq = JsonParser.parseString((String)jsonREquest).getAsJsonObject();
        jsonReq.getAsJsonArray("fileInfos").get(0).getAsJsonObject().addProperty("transientDocumentId", transientDocumentID);
        this.log.debug("The updated json object is " + jsonReq);
        try {
            StringEntity stringEntity = new StringEntity(jsonReq.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("Content-Type", "application/json");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            this.log.debug("The response is  " + response.getStatusLine().getStatusCode());
            String widgetID = JsonParser.parseString((String)EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject().get("id").getAsString();
            this.log.debug("The widget id is " + widgetID);
            return widgetID;
        }
        catch (Exception e) {
            this.log.debug("Error in getting Widget ID:" + e.getMessage());
            return null;
        }
    }

    @Override
    public String getWidgetURL(String widgetId) throws ClientProtocolException, IOException {
        this.log.debug("$$$$ in get Widget URL for " + widgetId + "widget id");
        String url = "https://api.na1.adobesign.com:443/api/rest/v6/widgets";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("x-api-user", "email:" + this.acrobatSignConfig.getApiUserEmail());
        httpGet.addHeader("Authorization", "Bearer " + this.acrobatSignConfig.getIntegrationKey());
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        JsonObject jsonResponse = JsonParser.parseString((String)EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
        this.log.debug("The json response from get widgets is " + jsonResponse.toString());
        JsonArray userWidgetList = jsonResponse.get("userWidgetList").getAsJsonArray();
        this.log.debug("The array size is " + userWidgetList.size());
        for (int i = 0; i < userWidgetList.size(); ++i) {
            this.log.debug("Getting widget object " + i);
            JsonObject temp = userWidgetList.get(i).getAsJsonObject();
            this.log.debug("The widget object " + i + "is " + temp.toString());
            if (!temp.get("id").getAsString().equalsIgnoreCase(widgetId)) continue;
            this.log.debug("Bingo found the matching widget id  " + i);
            String widgetURL = temp.get("url").getAsString();
            return widgetURL;
        }
        return null;
    }
}

