/*
 * Decompiled with CFR 0.152.
 */
package AEMFormsProcessStep.core;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Component(property={"service.description=Save submitted Payload as String", "service.vendor=Adobe Systems", "process.label=Save submitted Payload as String"})
public class SaveSubmittedDataInStringVariable
implements WorkflowProcess {
    private Logger log;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        String submittedDataFile = ((String)metaDataMap.get("PROCESS_ARGS", (Object)"string")).toString();
        String payloadPath = workItem.getWorkflowData().getPayload().toString();
        this.log = LoggerFactory.getLogger(SaveSubmittedDataInStringVariable.class);
        String dataFilePath = payloadPath + "/" + submittedDataFile + "/jcr:content";
        Session session = (Session)workflowSession.adaptTo(Session.class);
        javax.jcr.Node submittedDataNode = null;
        try {
            submittedDataNode = session.getNode(dataFilePath);
            if (submittedDataFile.endsWith("json")) {
                String inputStr;
                InputStream jsonDataStream = submittedDataNode.getProperty("jcr:data").getBinary().getStream();
                BufferedReader streamReader = new BufferedReader(new InputStreamReader(jsonDataStream, "UTF-8"));
                StringBuilder responseStrBuilder = new StringBuilder();
                while ((inputStr = streamReader.readLine()) != null) {
                    responseStrBuilder.append(inputStr);
                }
                JsonObject jsonObject = (JsonObject)new Gson().fromJson(responseStrBuilder.toString(), JsonObject.class);
                JsonObject boundData = jsonObject.getAsJsonObject("afData").getAsJsonObject("afBoundData").getAsJsonObject("data");
                System.out.println(jsonObject.getAsJsonObject("afData").getAsJsonObject("afBoundData").getAsJsonObject("data"));
                metaDataMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
                metaDataMap.put((Object)"submittedDataString", (Object)boundData.toString());
            }
            if (submittedDataFile.endsWith("xml")) {
                this.log.debug("Got xml file");
                DocumentBuilderFactory factory = null;
                DocumentBuilder builder = null;
                Document xmlDocument = null;
                InputStream xmlDataStream = submittedDataNode.getProperty("jcr:data").getBinary().getStream();
                System.out.println("Got xml file" + submittedDataNode);
                XPath xPath = XPathFactory.newInstance().newXPath();
                factory = DocumentBuilderFactory.newInstance();
                builder = factory.newDocumentBuilder();
                xmlDocument = builder.parse(xmlDataStream);
                Node node = (Node)xPath.compile("/afData/afBoundData").evaluate(xmlDocument, XPathConstants.NODE);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                StreamResult result = new StreamResult(new StringWriter());
                DOMSource source = new DOMSource(node);
                transformer.transform(source, result);
                String xmlString = result.getWriter().toString();
                this.log.debug("The xml string is " + xmlString);
                metaDataMap = workItem.getWorkflow().getWorkflowData().getMetaDataMap();
                metaDataMap.put((Object)"submittedDataString", (Object)xmlString);
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
        }
    }
}

