/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.servlets;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.output.api.OutputService;
import com.aemformssamples.documentservices.core.DocumentServices;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/mergetemplatewithdata"})
public class UseOutputService
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 5292878830719742545L;
    private static final Logger log = LoggerFactory.getLogger(UseOutputService.class);
    @Reference
    OutputService outputService;
    @Reference
    DocumentServices documentServices;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        boolean isMultipart;
        log.debug("In generate pdf batch");
        HashMap<String, Document> documentsMap = new HashMap<String, Document>();
        PrintWriter pw = null;
        String saveLocation = request.getParameter("saveLocation");
        File f = new File(saveLocation);
        if (!f.exists()) {
            f.mkdir();
        }
        if (isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            RequestParameterMap params = request.getRequestParameterMap();
            for (Map.Entry pairs : params.entrySet()) {
                String key = (String)pairs.getKey();
                RequestParameter[] pArr = (RequestParameter[])pairs.getValue();
                RequestParameter param = pArr[0];
                try {
                    if (param.isFormField()) continue;
                    if (param.getFileName().endsWith("xdp")) {
                        InputStream xdpStream = param.getInputStream();
                        Document xdpDocument = new Document(xdpStream);
                        xdpDocument.copyToFile(new File(saveLocation + File.separator + "fromui.xdp"));
                        documentsMap.put("xdpTemplate", xdpDocument);
                        log.debug("####  " + param.getFileName());
                    }
                    if (!param.getFileName().endsWith("xml")) continue;
                    InputStream xmlStream = param.getInputStream();
                    log.debug("####  " + param.getFileName());
                    Document xmlDocument = new Document(xmlStream);
                    xmlDocument.copyToFile(new File(saveLocation + File.separator + "fromui.xml"));
                    documentsMap.put("xmlData", xmlDocument);
                }
                catch (Exception e) {
                    log.debug(e.getMessage());
                }
            }
        }
        Document documentGenerated = this.documentServices.mergeDataWithXdpTemplate(documentsMap);
        log.debug("after calling the generate multiple PDF's");
        String path = this.documentServices.saveDocumentInCrx("/content/demofilesuploaded", ".pdf", documentGenerated);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("path", path);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "nocache");
        response.setCharacterEncoding("utf-8");
        System.out.println(jsonObject.toString());
        try {
            pw = response.getWriter();
            pw.println(jsonObject.toString());
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

