/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.servlets;

import com.adobe.pdfg.exception.ConversionException;
import com.adobe.pdfg.exception.FileFormatNotSupportedException;
import com.adobe.pdfg.exception.InvalidParameterException;
import com.aemformssamples.documentservices.core.DocumentServices;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=get", "sling.servlet.paths=/bin/ocr"})
public class OcrTiffImages
extends SlingSafeMethodsServlet {
    @Reference
    DocumentServices documentServices;
    @Reference
    GetResolver getResolver;
    private static final Logger log = LoggerFactory.getLogger(OcrTiffImages.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String fileName = request.getParameter("fileName");
        String tiffFile = request.getParameter("jcrPath");
        try {
            String savedOcrFile = this.documentServices.ocrDocument(tiffFile, fileName);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("path", savedOcrFile);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "nocache");
            response.setCharacterEncoding("utf-8");
            PrintWriter out = null;
            out = response.getWriter();
            out.println(jsonObject.toString());
        }
        catch (ConversionException | FileFormatNotSupportedException | InvalidParameterException | IOException | RepositoryException e) {
            e.printStackTrace();
        }
        catch (JsonIOException e) {
            e.printStackTrace();
        }
    }
}

