/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.servlets;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.ccm.multichannel.batch.api.builder.BatchConfigBuilder;
import com.adobe.fd.ccm.multichannel.batch.api.factory.BatchComponentBuilderFactory;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchConfig;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchInput;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchResult;
import com.adobe.fd.ccm.multichannel.batch.api.model.BatchType;
import com.adobe.fd.ccm.multichannel.batch.api.model.RecordResult;
import com.adobe.fd.ccm.multichannel.batch.api.model.RenditionResult;
import com.adobe.fd.ccm.multichannel.batch.api.service.BatchGeneratorService;
import com.aemformssamples.documentservices.core.DocumentServices;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=POST", "sling.servlet.paths=/bin/batchServlet"})
public class ICBatchServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -6368744586861589435L;
    private static final Logger log = LoggerFactory.getLogger(ICBatchServlet.class);
    @Reference
    private BatchGeneratorService batchGeneratorService;
    @Reference
    private BatchComponentBuilderFactory batchBuilderFactory;
    @Reference
    DocumentServices documentServices;

    public void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        System.out.println("In my post");
        try {
            this.executeBatch(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeBatch(SlingHttpServletRequest request, SlingHttpServletResponse response) throws Exception {
        FileOutputStream fos = new FileOutputStream("abc.zip");
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            RequestParameterMap params = request.getRequestParameterMap();
            for (Map.Entry pairs : params.entrySet()) {
                String key = (String)pairs.getKey();
                RequestParameter[] pArr = (RequestParameter[])pairs.getValue();
                RequestParameter param = pArr[0];
                JSONArray inputJSONArray = new JSONArray();
                try {
                    String str;
                    if (param.isFormField()) continue;
                    log.debug("In my post it is multipart" + param.getFileName());
                    if (!param.getFileName().endsWith("json")) continue;
                    log.debug("The file name ends with json " + param.getFileName());
                    InputStream jsonStream = param.getInputStream();
                    log.debug("####  " + param.getFileName());
                    InputStreamReader isReader = new InputStreamReader(jsonStream);
                    BufferedReader reader = new BufferedReader(isReader);
                    StringBuffer sb = new StringBuffer();
                    while ((str = reader.readLine()) != null) {
                        sb.append(str);
                    }
                    String data = sb.toString();
                    try {
                        JSONObject inputJSON = new JSONObject(data.trim());
                        log.debug("*****the inputJSON json******" + inputJSON.toString());
                        inputJSONArray.put((Object)inputJSON);
                    }
                    catch (Exception e) {
                        try {
                            JSONArray inputArray = new JSONArray(data);
                            for (int i = 0; i < inputArray.length(); ++i) {
                                inputJSONArray.put((Object)inputArray.getJSONObject(i));
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("Error !!!!!" + ex.getMessage());
                        }
                    }
                    BatchInput batchInput = this.batchBuilderFactory.getBatchInputBuilder().setData(inputJSONArray).setTemplatePath("/content/dam/formsanddocuments/beneficiariesconfirmation").build();
                    BatchConfigBuilder batchConfigBuilder = this.batchBuilderFactory.getBatchConfigBuilder();
                    batchConfigBuilder.setRecordPath("member_1563743787488.user.name");
                    BatchConfig batchConfig = batchConfigBuilder.setBatchType(BatchType.PRINT).build();
                    BatchResult batchResult = this.batchGeneratorService.generateBatch(batchInput, batchConfig);
                    List recordList = batchResult.getRecordResults();
                    String recordId = null;
                    for (RecordResult recordResult : recordList) {
                        recordId = recordResult.getRecordID();
                        log.debug("####The record id " + recordId);
                        for (RenditionResult renditionResult : recordResult.getRenditionResults()) {
                            if (!renditionResult.isRecordPassed()) continue;
                            InputStream output = renditionResult.getDocumentStream().getInputStream();
                            File fileToZip = new File(recordId + ".pdf");
                            this.createZipFile(output, fileToZip);
                            ICBatchServlet.writeToZipFile(recordId + ".pdf", zipOut);
                        }
                    }
                    zipOut.close();
                    fos.close();
                    Document zippedDocument = new Document(new File("abc.zip"));
                    String path = this.documentServices.saveDocumentInCrx("/content/demofilesuploaded", ".zip", zippedDocument);
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("path", path);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "nocache");
                    response.setCharacterEncoding("utf-8");
                    PrintWriter pw = null;
                    try {
                        pw = response.getWriter();
                        pw.println(jsonObject.toString());
                        pw.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.out.println("The error is" + e.getMessage());
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public static void writeToZipFile(String path, ZipOutputStream zipStream) throws FileNotFoundException, IOException {
        int length;
        System.out.println("Writing file : '" + path + "' to zip file");
        File aFile = new File(path);
        FileInputStream fis = new FileInputStream(aFile);
        ZipEntry zipEntry = new ZipEntry(path);
        zipStream.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipStream.write(bytes, 0, length);
        }
        zipStream.closeEntry();
        fis.close();
    }

    private void createZipFile(InputStream inputStream, File fileToZip) throws IOException, IOException {
        try (FileOutputStream outputStream = new FileOutputStream(fileToZip);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }
}

