/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.servlets;

import com.aemformssamples.documentservices.core.DocumentServices;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.w3c.dom.Document;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/generateinteractivepdf"})
public class GenerateInteractivePDF
extends SlingAllMethodsServlet {
    @Reference
    DocumentServices documentServices;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String dataXml = request.getParameter("formData");
        System.out.println("The request URL is " + request.getRequestURI());
        System.out.println("The data xml is " + dataXml);
        Document xmlDataDoc = this.documentServices.w3cDocumentFromStrng(dataXml);
        com.adobe.aemfd.docmanager.Document xmlDocument = this.documentServices.orgw3cDocumentToAEMFDDocument(xmlDataDoc);
        com.adobe.aemfd.docmanager.Document generatedPDF = this.documentServices.mobileFormToInteractivePdf(xmlDocument, request.getParameter("xdpPath"));
        try {
            int bytes;
            InputStream fileInputStream = generatedPDF.getInputStream();
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", "attachment; filename=AemFormsRocks.pdf");
            response.setContentLength(fileInputStream.available());
            ServletOutputStream responseOutputStream = response.getOutputStream();
            while ((bytes = fileInputStream.read()) != -1) {
                responseOutputStream.write(bytes);
            }
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

