/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.servlets;

import com.aemformssamples.documentservices.core.DocumentServices;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=get", "sling.servlet.paths=/bin/aemformsdocumentservices"})
public class DocumentServicesOperations
extends SlingAllMethodsServlet {
    @Reference
    DocumentServices documentServices;
    private static final Logger log = LoggerFactory.getLogger(DocumentServicesOperations.class);
    private static final long serialVersionUID = 1L;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        System.out.println("IS it multi part" + isMultipart);
        System.out.println("The operation is " + request.getParameter("operation"));
        int operation = Integer.parseInt(request.getParameter("operation"));
        JsonObject jsonObject = null;
        if (isMultipart) {
            RequestParameterMap params = request.getRequestParameterMap();
            switch (operation) {
                case 1: {
                    jsonObject = this.documentServices.exportDataFromPDF((Map<String, RequestParameter[]>)params);
                    break;
                }
                case 2: {
                    jsonObject = this.documentServices.importDataPDF((Map<String, RequestParameter[]>)params);
                    break;
                }
                case 3: {
                    jsonObject = this.documentServices.assembleDocumentsWithDDX((Map<String, RequestParameter[]>)params);
                    break;
                }
                case 4: {
                    jsonObject = this.documentServices.mergeDataUsingOutput((Map<String, RequestParameter[]>)params);
                    break;
                }
                case 5: {
                    jsonObject = this.documentServices.imageToPDF((Map<String, RequestParameter[]>)params);
                }
            }
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "nocache");
            response.setCharacterEncoding("utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            out.println(jsonObject.toString());
        }
    }
}

