/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.servlets;

import com.aemformssamples.documentservices.core.DocumentServices;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Component(service={Servlet.class}, property={"sling.servlet.methods=get", "sling.servlet.paths=/bin/certifypdf"})
public class CertifyDocument
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    DocumentServices documentServices;
    @Reference
    GetResolver getResolver;
    private static final Logger log = LoggerFactory.getLogger(CertifyDocument.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        String submittedData = request.getParameter("jcr:data");
        Document submittedXml = this.documentServices.w3cDocumentFromStrng(submittedData);
        String signatureFieldName = submittedXml.getElementsByTagName("signaturefield").getLength() == 0 ? null : submittedXml.getElementsByTagName("signaturefield").item(0).getTextContent();
        log.debug("The signature field name is " + signatureFieldName);
        RequestParameterMap requestParameterMap = request.getRequestParameterMap();
        for (Map.Entry pairs : requestParameterMap.entrySet()) {
            RequestParameter[] pArr = (RequestParameter[])pairs.getValue();
            RequestParameter param = pArr[0];
            if (param.isFormField()) continue;
            try {
                int bytes;
                log.debug("Got attachment!!!!" + param.getFileName());
                InputStream is = param.getInputStream();
                com.adobe.aemfd.docmanager.Document documentToCertify = new com.adobe.aemfd.docmanager.Document(is);
                InputStream fileInputStream = this.documentServices.certifyDocument(documentToCertify, "ares", signatureFieldName);
                documentToCertify.close();
                response.setContentType("application/pdf");
                response.addHeader("Content-Disposition", "attachment; filename=AemFormsRocks.pdf");
                response.setContentLength(fileInputStream.available());
                ServletOutputStream responseOutputStream = response.getOutputStream();
                while ((bytes = fileInputStream.read()) != -1) {
                    responseOutputStream.write(bytes);
                }
                responseOutputStream.flush();
                responseOutputStream.close();
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
        }
    }
}

