/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.servlets;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.assembler.service.AssemblerService;
import com.aemformssamples.documentservices.core.DocumentServices;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Component(service={Servlet.class}, property={"sling.servlet.methods=post", "sling.servlet.paths=/bin/assemblefiles"})
public class AssembleUploadedFiles
extends SlingAllMethodsServlet {
    @Reference
    AssemblerService assemblerService;
    @Reference
    GetResolver getResolver;
    @Reference
    DocumentServices documentServices;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AssembleUploadedFiles.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        System.out.println("In Assemble Uploaded Files");
        HashMap<String, Object> mapOfDocuments = new HashMap<String, Object>();
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        org.w3c.dom.Document ddx = docBuilder.newDocument();
        Element rootElement = ddx.createElementNS("http://ns.adobe.com/DDX/1.0/", "DDX");
        ddx.appendChild(rootElement);
        Element pdfResult = ddx.createElement("PDF");
        pdfResult.setAttribute("result", "GeneratedDocument.pdf");
        rootElement.appendChild(pdfResult);
        if (isMultipart) {
            RequestParameterMap params = request.getRequestParameterMap();
            for (Map.Entry pairs : params.entrySet()) {
                RequestParameter[] pArr = (RequestParameter[])pairs.getValue();
                RequestParameter param = pArr[0];
                try {
                    if (!param.isFormField()) {
                        InputStream stream = param.getInputStream();
                        log.debug("the file name is " + param.getFileName());
                        log.debug("Got input Stream inside my servlet####" + stream.available());
                        Document document = new Document(stream);
                        mapOfDocuments.put(param.getFileName(), document);
                        Element pdfSourceElement = ddx.createElement("PDF");
                        Element noForms = ddx.createElement("NoForms");
                        pdfSourceElement.setAttribute("source", param.getFileName());
                        pdfSourceElement.setAttribute("bookmarkTitle", param.getFileName());
                        pdfSourceElement.appendChild(noForms);
                        pdfResult.appendChild(pdfSourceElement);
                        log.debug("The map size is " + mapOfDocuments.size());
                        continue;
                    }
                    log.debug("The form field is" + param.getString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Document ddxDocument = this.documentServices.orgw3cDocumentToAEMFDDocument(ddx);
        Document assembledDocument = this.documentServices.assembleDocuments(mapOfDocuments, ddxDocument);
        String path = this.documentServices.saveDocumentInCrx("/content/demofilesuploaded", ".pdf", assembledDocument);
        JsonObject jsonObject = new JsonObject();
        try {
            jsonObject.addProperty("path", path);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "nocache");
            response.setCharacterEncoding("utf-8");
            PrintWriter out = null;
            out = response.getWriter();
            out.println(jsonObject.toString());
        }
        catch (JsonIOException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

