/*
 * Decompiled with CFR 0.152.
 */
package com.aemformssamples.documentservices.core.impl;

import com.adobe.aemds.guide.addon.dor.DoRGenerationException;
import com.adobe.aemds.guide.addon.dor.DoROptions;
import com.adobe.aemds.guide.addon.dor.DoRResult;
import com.adobe.aemds.guide.addon.dor.DoRService;
import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.assembler.client.AssemblerOptionSpec;
import com.adobe.fd.assembler.client.AssemblerResult;
import com.adobe.fd.assembler.client.ConversionException;
import com.adobe.fd.assembler.client.OperationException;
import com.adobe.fd.assembler.client.PDFAConversionOptionSpec;
import com.adobe.fd.assembler.service.AssemblerService;
import com.adobe.fd.bcf.api.BarcodedFormsService;
import com.adobe.fd.bcf.api.CharSet;
import com.adobe.fd.bcf.api.Delimiter;
import com.adobe.fd.bcf.api.XMLFormat;
import com.adobe.fd.docassurance.client.api.DocAssuranceService;
import com.adobe.fd.docassurance.client.api.DocAssuranceServiceOperationTypes;
import com.adobe.fd.docassurance.client.api.ReaderExtensionOptions;
import com.adobe.fd.docassurance.client.api.SignatureOptions;
import com.adobe.fd.forms.api.AcrobatVersion;
import com.adobe.fd.forms.api.DataFormat;
import com.adobe.fd.forms.api.FormsService;
import com.adobe.fd.forms.api.FormsServiceException;
import com.adobe.fd.forms.api.PDFFormRenderOptions;
import com.adobe.fd.forms.api.RenderAtClient;
import com.adobe.fd.output.api.BatchOptions;
import com.adobe.fd.output.api.BatchResult;
import com.adobe.fd.output.api.OutputService;
import com.adobe.fd.output.api.OutputServiceException;
import com.adobe.fd.output.api.PDFOutputOptions;
import com.adobe.fd.readerextensions.client.ReaderExtensionsOptionSpec;
import com.adobe.fd.readerextensions.client.UsageRights;
import com.adobe.fd.signatures.client.types.MDPPermissions;
import com.adobe.fd.signatures.pdf.inputs.CredentialContext;
import com.adobe.fd.signatures.pdf.inputs.DSSPreferences;
import com.adobe.fd.signatures.pdf.inputs.DSSPreferencesImpl;
import com.adobe.fd.signatures.pdf.inputs.PDFSignatureAppearenceOptions;
import com.adobe.fd.signatures.pdf.inputs.UnlockOptions;
import com.adobe.fd.signatures.pki.client.types.common.HashAlgorithm;
import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import com.adobe.fd.signatures.pki.client.types.prefs.CRLPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.CRLPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.GeneralPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PathValidationPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.PathValidationPreferencesImpl;
import com.adobe.pdfg.exception.FileFormatNotSupportedException;
import com.adobe.pdfg.exception.InvalidParameterException;
import com.adobe.pdfg.result.CreatePDFResult;
import com.adobe.pdfg.result.HtmlToPdfResult;
import com.adobe.pdfg.service.api.GeneratePDFService;
import com.aemformssamples.configuration.DocSvcConfiguration;
import com.aemformssamples.documentservices.core.DocumentServices;
import com.google.gson.JsonObject;
import com.mergeandfuse.getserviceuserresolver.GetResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component(service={DocumentServices.class})
@Designate(ocd=DocSvcConfiguration.class)
public class DocumentServicesImpl
implements DocumentServices {
    @Reference
    FormsService formsService;
    @Reference
    OutputService outputService;
    @Reference
    GeneratePDFService generatePDFService;
    @Reference
    BarcodedFormsService barcodeService;
    @Reference
    DocAssuranceService docAssuranceService;
    @Reference
    AssemblerService assemblerService;
    @Reference
    private SlingRepository slingRepository;
    @Reference
    private GetResolver getResolver;
    @Reference
    GeneratePDFService generatePdfService;
    private static final Logger log = LoggerFactory.getLogger(DocumentServicesImpl.class);
    private DocSvcConfiguration docConfig;
    @Reference
    private ResourceResolverFactory jcrResourceResolverFactory;
    @Reference
    private DoRService dorService;
    String credentialAlias;
    String fieldName;

    @Activate
    public void activate(DocSvcConfiguration config) {
        this.docConfig = config;
    }

    @Override
    public Document GenerateDor(String afPath, String dataXml) {
        Resource afResource = this.getResolver.getFormsServiceResolver().getResource(afPath);
        DoROptions dorOptions = new DoROptions();
        dorOptions.setData(dataXml);
        dorOptions.setFormResource(afResource);
        Locale locale = new Locale("en");
        dorOptions.setLocale(locale);
        DoRResult dorResult = null;
        try {
            dorResult = this.dorService.render(dorOptions);
        }
        catch (DoRGenerationException e) {
            e.printStackTrace();
        }
        byte[] fileBytes = dorResult.getContent();
        Document dorDocument = new Document(fileBytes);
        return dorDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream certifyDocument(Document documentToCertify, String credentialAlias, String fieldName) {
        this.credentialAlias = credentialAlias;
        this.fieldName = fieldName;
        ResourceResolver resourceResolver = null;
        Document certifiedDocument = null;
        try {
            try {
                resourceResolver = this.getResolver.getFormsServiceResolver();
                certifiedDocument = this.docAssuranceService.secureDocument(documentToCertify, null, this.getCertificationOptions(resourceResolver), null, null);
                log.info("Certified the document");
                System.out.println("Certified document");
                certifiedDocument.copyToFile(new File("c:\\scrap\\abc.pdf"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                return certifiedDocument.getInputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private SignatureOptions getCertificationOptions(ResourceResolver rr) {
        log.info("Creating Signature Options");
        SignatureOptions signatureOptions = SignatureOptions.getInstance();
        signatureOptions.setOperationType(DocAssuranceServiceOperationTypes.CERTIFY);
        String fieldName = this.fieldName;
        String alias = this.credentialAlias;
        HashAlgorithm algo = HashAlgorithm.SHA256;
        String reason = "Reason";
        String location = "Location";
        String contactInfo = "Contact Info";
        MDPPermissions mdpPermissions = MDPPermissions.valueOf((String)"FormChanges");
        PDFSignatureAppearenceOptions appOptions = new PDFSignatureAppearenceOptions(PDFSignatureAppearenceOptions.PDFSignatureAppearanceType.NAME, null, 1.0, null, true, true, true, true, false, true, true, PDFSignatureAppearenceOptions.TextDirection.AUTO);
        signatureOptions.setLockCertifyingField(true);
        signatureOptions.setSignatureFieldName(fieldName);
        signatureOptions.setAlgo(algo);
        signatureOptions.setContactInfo(contactInfo);
        signatureOptions.setLocation(location);
        signatureOptions.setSigAppearence(appOptions);
        signatureOptions.setReason(reason);
        signatureOptions.setDssPref(this.getDSSPreferences(rr));
        signatureOptions.setCredential(new CredentialContext(alias, rr));
        signatureOptions.setMdpPermissions(mdpPermissions);
        log.info("Returing Signature Options");
        return signatureOptions;
    }

    private DSSPreferences getDSSPreferences(ResourceResolver rr) {
        log.info("Returing DSSS Options");
        DSSPreferencesImpl prefs = DSSPreferencesImpl.getInstance();
        prefs.setPKIPreferences(this.getPKIPreferences());
        GeneralPreferencesImpl gp = (GeneralPreferencesImpl)prefs.getPKIPreferences().getGeneralPreferences();
        gp.setDisableCache(true);
        return prefs;
    }

    private PKIPreferences getPKIPreferences() {
        PKIPreferencesImpl pkiPref = new PKIPreferencesImpl();
        pkiPref.setCRLPreferences(this.getCRLPreferences());
        pkiPref.setPathPreferences(this.getPathValidationPreferences());
        log.info("Returing PKI Options");
        return pkiPref;
    }

    private CRLPreferences getCRLPreferences() {
        CRLPreferencesImpl crlPrefs = new CRLPreferencesImpl();
        crlPrefs.setRevocationCheck(RevocationCheckStyle.CheckIfAvailable);
        crlPrefs.setGoOnline(true);
        log.info("Returing CRL Options");
        return crlPrefs;
    }

    private PathValidationPreferences getPathValidationPreferences() {
        PathValidationPreferencesImpl pathPref = new PathValidationPreferencesImpl();
        pathPref.setDoValidation(false);
        return pathPref;
    }

    @Override
    public Document assembleDocuments(Map<String, Object> mapOfDocuments, Document ddxDocument) {
        AssemblerOptionSpec aoSpec = new AssemblerOptionSpec();
        aoSpec.setFailOnError(true);
        AssemblerResult ar = null;
        try {
            ar = this.assemblerService.invoke(ddxDocument, mapOfDocuments, aoSpec);
        }
        catch (OperationException e) {
            e.printStackTrace();
        }
        return (Document)ar.getDocuments().get("GeneratedDocument.pdf");
    }

    @Override
    public Document orgw3cDocumentToAEMFDDocument(org.w3c.dom.Document xmlDocument) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(xmlDocument);
        log.debug("$$$$In orgW3CDocumentToAEMFDDocument method");
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, outputTarget);
            ByteArrayInputStream is1 = new ByteArrayInputStream(outputStream.toByteArray());
            Document xmlAEMFDDocument = new Document((InputStream)is1);
            if (log.isDebugEnabled()) {
                xmlAEMFDDocument.copyToFile(new File("dataxmldocument.xml"));
            }
            return xmlAEMFDDocument;
        }
        catch (Exception e) {
            log.debug("Error in generating ddx " + e.getMessage());
            return null;
        }
    }

    @Override
    public org.w3c.dom.Document w3cDocumentFromStrng(String xmlString) {
        try {
            log.debug("Inside w3cDocumentFromString");
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xmlString));
            return db.parse(is);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Document createSimpleDDX(Map<String, Object> mapOfDocuments) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        org.w3c.dom.Document ddx = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ddx = docBuilder.newDocument();
            Element rootElement = ddx.createElementNS("http://ns.adobe.com/DDX/1.0/", "DDX");
            ddx.appendChild(rootElement);
            Element pdfResult = ddx.createElement("PDF");
            pdfResult.setAttribute("result", "GeneratedDocument.pdf");
            rootElement.appendChild(pdfResult);
            for (String key : mapOfDocuments.keySet()) {
                log.debug(key + " " + mapOfDocuments.get(key));
                Element pdfSourceElement = ddx.createElement("PDF");
                pdfSourceElement.setAttribute("source", key);
                pdfResult.appendChild(pdfSourceElement);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return this.orgw3cDocumentToAEMFDDocument(ddx);
    }

    @Override
    public Document createDDXFromMapOfDocuments(Map<String, Document> mapOfDocuments) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        org.w3c.dom.Document ddx = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ddx = docBuilder.newDocument();
            Element rootElement = ddx.createElementNS("http://ns.adobe.com/DDX/1.0/", "DDX");
            ddx.appendChild(rootElement);
            Element pdfResult = ddx.createElement("PDF");
            pdfResult.setAttribute("result", "GeneratedDocument.pdf");
            rootElement.appendChild(pdfResult);
            for (String key : mapOfDocuments.keySet()) {
                log.debug(key + " " + mapOfDocuments.get(key));
                Element pdfSourceElement = ddx.createElement("PDF");
                pdfSourceElement.setAttribute("source", key);
                pdfResult.appendChild(pdfSourceElement);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return this.orgw3cDocumentToAEMFDDocument(ddx);
    }

    @Override
    public Document renderAndExtendXdp(String xdpPath) {
        log.debug("In renderAndExtend xdp the alias is " + this.docConfig.ReaderExtensionAlias());
        PDFFormRenderOptions renderOptions = new PDFFormRenderOptions();
        renderOptions.setAcrobatVersion(AcrobatVersion.Acrobat_11);
        try {
            Document xdpRenderedAsPDF = this.formsService.renderPDFForm("crx://" + xdpPath, null, renderOptions);
            UsageRights usageRights = new UsageRights();
            usageRights.setEnabledBarcodeDecoding(this.docConfig.BarcodeDecoding());
            usageRights.setEnabledFormFillIn(this.docConfig.FormFill());
            usageRights.setEnabledComments(this.docConfig.Commenting());
            usageRights.setEnabledEmbeddedFiles(this.docConfig.EmbeddingFiles());
            usageRights.setEnabledDigitalSignatures(this.docConfig.DigitialSignatures());
            usageRights.setEnabledFormDataImportExport(this.docConfig.FormDataExportImport());
            ReaderExtensionsOptionSpec reOptionsSpec = new ReaderExtensionsOptionSpec(usageRights, "Sample ARES");
            UnlockOptions unlockOptions = null;
            ReaderExtensionOptions reOptions = ReaderExtensionOptions.getInstance();
            reOptions.setCredentialAlias(this.docConfig.ReaderExtensionAlias());
            log.debug("set the credential");
            reOptions.setResourceResolver(this.getResolver.getFormsServiceResolver());
            reOptions.setReOptions(reOptionsSpec);
            log.debug("set the resourceResolver and re spec");
            return this.docAssuranceService.secureDocument(xdpRenderedAsPDF, null, null, reOptions, unlockOptions);
        }
        catch (FormsServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    String convertToString(org.w3c.dom.Document inputDoc) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer tr = tf.newTransformer();
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        tr.transform(new DOMSource(inputDoc), sr);
        return sw.toString();
    }

    @Override
    public JsonObject extractBarCode(Document pdfDocument) {
        try {
            org.w3c.dom.Document result = this.barcodeService.decode(pdfDocument, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), CharSet.UTF_8);
            List listResult = this.barcodeService.extractToXML(result, Delimiter.Carriage_Return, Delimiter.Tab, XMLFormat.XDP);
            log.debug("the form1 lenght is " + ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("form1").getLength());
            JsonObject decodedData = new JsonObject();
            decodedData.addProperty("name", ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("Name").item(0).getTextContent());
            decodedData.addProperty("address", ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("Address").item(0).getTextContent());
            decodedData.addProperty("city", ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("City").item(0).getTextContent());
            decodedData.addProperty("state", ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("State").item(0).getTextContent());
            decodedData.addProperty("zipCode", ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("ZipCode").item(0).getTextContent());
            decodedData.addProperty("country", ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("Country").item(0).getTextContent());
            log.debug("The JSON Object is " + decodedData.toString());
            return decodedData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String ocrDocument(String jcrPath, String fileName) throws com.adobe.pdfg.exception.ConversionException, InvalidParameterException, FileFormatNotSupportedException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException, IOException {
        ResourceResolver serviceResolver = this.getResolver.getFormsServiceResolver();
        System.out.println("the jcr path i got was" + jcrPath);
        Node pdfDoc = (Node)serviceResolver.getResource(jcrPath).adaptTo(Node.class);
        System.out.println("Got tiffFile Node" + pdfDoc.getPath());
        Document tiffDocument = null;
        Node jcrContent = pdfDoc.getNode("jcr:content");
        System.out.println("The jcr content node path is " + jcrContent.getPath());
        InputStream is = jcrContent.getProperty("jcr:data").getBinary().getStream();
        System.out.println("The is size is " + is.available());
        try {
            tiffDocument = new Document(is);
            System.out.println("Got tiff Document " + tiffDocument.getContentType());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CreatePDFResult createPdfResult = this.generatePdfService.createPDF2(tiffDocument, fileName, "Standard OCR", "Standard", "No Security", null, null);
        Document ocrDocument = createPdfResult.getCreatedDocument();
        Node ocrFiles = (Node)serviceResolver.getResource("/content/ocrfiles").adaptTo(Node.class);
        System.out.println("The jcrNode name is " + ocrFiles.getName());
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        Node ocrFile = ocrFiles.addNode(uuidString + ".pdf", "nt:file");
        System.out.println("The ocrFiles node was created");
        Node resNode = ocrFile.addNode("jcr:content", "nt:resource");
        Session session = (Session)serviceResolver.adaptTo(Session.class);
        ValueFactory valueFactory = session.getValueFactory();
        Binary contentValue = valueFactory.createBinary(ocrDocument.getInputStream());
        resNode.setProperty("jcr:data", contentValue);
        serviceResolver.commit();
        return ocrFile.getPath();
    }

    @Override
    public JsonObject ocrScannedImage(Document scannedImage, String fileName) throws PersistenceException, com.adobe.pdfg.exception.ConversionException, InvalidParameterException, FileFormatNotSupportedException, ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        ResourceResolver serviceResolver = this.getResolver.getFormsServiceResolver();
        CreatePDFResult createPdfResult = this.generatePdfService.createPDF2(scannedImage, fileName, "Standard OCR", "Standard", "No Security", null, null);
        Document ocrDocument = createPdfResult.getCreatedDocument();
        Node ocrFiles = (Node)serviceResolver.getResource("/content/ocrfiles").adaptTo(Node.class);
        System.out.println("The jcrNode name is " + ocrFiles.getName());
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        Node ocrFile = ocrFiles.addNode(uuidString + ".pdf", "nt:file");
        System.out.println("The ocrFiles node was created");
        Node resNode = ocrFile.addNode("jcr:content", "nt:resource");
        Session session = (Session)serviceResolver.adaptTo(Session.class);
        ValueFactory valueFactory = session.getValueFactory();
        try {
            Binary contentValue = valueFactory.createBinary(ocrDocument.getInputStream());
            resNode.setProperty("jcr:data", contentValue);
            serviceResolver.commit();
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("path", ocrFile.getPath());
            return jsonobject;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String saveDocumentInCrx(String jcrPath, String fileExtension, Document documentToSave) {
        System.out.println("Storing in crx");
        log.debug("Storing in CRX  " + jcrPath);
        ResourceResolver serviceResolver = this.getResolver.getFormsServiceResolver();
        Node ocrFiles = (Node)serviceResolver.getResource(jcrPath).adaptTo(Node.class);
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        try {
            Node assembledPDF = ocrFiles.addNode(uuidString + fileExtension, "nt:file");
            Node resNode = assembledPDF.addNode("jcr:content", "nt:resource");
            Session session = (Session)serviceResolver.adaptTo(Session.class);
            ValueFactory valueFactory = session.getValueFactory();
            Binary contentValue = valueFactory.createBinary(documentToSave.getInputStream());
            resNode.setProperty("jcr:data", contentValue);
            serviceResolver.commit();
            return assembledPDF.getPath();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("The ocrFiles node was created");
        return null;
    }

    @Override
    public Document mobileFormToInteractivePdf(Document xmlData, String path) {
        System.out.println("####In mobile form to interactive pdf####");
        String uri = "crx:///content/dam/formsanddocuments";
        String xdpName = path.substring(31, path.lastIndexOf("/jcr:content"));
        System.out.println("####In mobile form to interactive pdf####   " + xdpName);
        PDFFormRenderOptions renderOptions = new PDFFormRenderOptions();
        renderOptions.setAcrobatVersion(AcrobatVersion.Acrobat_11);
        renderOptions.setContentRoot(uri);
        Document interactivePDF = null;
        try {
            interactivePDF = this.formsService.renderPDFForm(xdpName, xmlData, renderOptions);
        }
        catch (FormsServiceException e) {
            e.printStackTrace();
        }
        return interactivePDF;
    }

    @Override
    public Document mobileFormToPDF(String xmlData) {
        org.w3c.dom.Document xmlDataDoc = this.w3cDocumentFromStrng(xmlData);
        org.w3c.dom.Node base64Image = xmlDataDoc.getElementsByTagName("base64image").item(0);
        if (base64Image != null && base64Image.getTextContent() != "") {
            int startingPosition = base64Image.getTextContent().indexOf(",");
            org.w3c.dom.Node imageNode = xmlDataDoc.getElementsByTagName("img").item(0);
            log.debug("The massaged string is " + base64Image.getTextContent().substring(23));
            imageNode.setTextContent(base64Image.getTextContent().substring(startingPosition + 1));
        }
        Document xmlDataDocument = this.orgw3cDocumentToAEMFDDocument(xmlDataDoc);
        ResourceResolver serviceResolver = this.getResolver.getFormsServiceResolver();
        Node xdpTemplateNode = (Node)serviceResolver.getResource("/content/dam/formsanddocuments/schengen.xdp/jcr:content/renditions/original/jcr:content").adaptTo(Node.class);
        log.debug("Got the xdp node ");
        PDFOutputOptions pdfOptions = new PDFOutputOptions();
        pdfOptions.setAcrobatVersion(com.adobe.fd.output.api.AcrobatVersion.Acrobat_11);
        Document xdpTemplate = null;
        try {
            InputStream is = xdpTemplateNode.getProperty("jcr:data").getBinary().getStream();
            log.debug("The size of Input Stream is " + is.available());
            xdpTemplate = new Document(is);
            log.debug("Created XDP Template");
            Document generatedPDF = this.outputService.generatePDFOutput(xdpTemplate, xmlDataDocument, pdfOptions);
            return generatedPDF;
        }
        catch (OutputServiceException | IOException | RepositoryException e) {
            log.debug("The error message is " + e.getMessage());
            return null;
        }
    }

    @Override
    public Document createDDXForFragments(String masterTemplate, Map<Integer, Map> fragmentsToAssemble) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        org.w3c.dom.Document ddx = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            ddx = docBuilder.newDocument();
            Element rootElement = ddx.createElementNS("http://ns.adobe.com/DDX/1.0/", "DDX");
            ddx.appendChild(rootElement);
            Element pdf = ddx.createElement("PDF");
            pdf.setAttribute("result", "rendered.pdf");
            rootElement.appendChild(pdf);
            Element xdpResult = ddx.createElement("XDP");
            pdf.appendChild(xdpResult);
            Element xdpSource = ddx.createElement("XDP");
            xdpSource.setAttribute("source", masterTemplate);
            xdpResult.appendChild(xdpSource);
            for (Map.Entry<Integer, Map> map : fragmentsToAssemble.entrySet()) {
                System.out.println(map.getKey() + " = " + map.getValue().get("source"));
                Element xdpContent = ddx.createElement("XDPContent");
                xdpContent.setAttribute("insertionPoint", (String)map.getValue().get("insertionPoint"));
                xdpContent.setAttribute("source", (String)map.getValue().get("source"));
                xdpContent.setAttribute("fragment", (String)map.getValue().get("fragment"));
                xdpSource.appendChild(xdpContent);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        DOMSource source = new DOMSource(ddx);
        try {
            FileWriter writer = new FileWriter(new File("c:\\scrap\\assemblefragments.xml"));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return this.orgw3cDocumentToAEMFDDocument(ddx);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String insertFragments(String masterTemplate, Map<Integer, Map> fragmentsToAssemble, Document ddx) {
        System.out.println("The master template is " + masterTemplate);
        ResourceResolver serviceResolver = this.getResolver.getFormsServiceResolver();
        Node masterXdp = (Node)this.getResolver.getFormsServiceResolver().getResource("/content/dam/fidelitydemo/templates/" + masterTemplate + "/jcr:content/renditions/original/jcr:content").adaptTo(Node.class);
        HashMap<String, Document> mapOfDocuments = new HashMap<String, Document>();
        try {
            InputStream masterXdpIS = masterXdp.getProperty("jcr:data").getBinary().getStream();
            Document masterXdpTemplate = new Document(masterXdpIS);
            mapOfDocuments.put(masterTemplate, masterXdpTemplate);
            for (Map.Entry<Integer, Map> entry : fragmentsToAssemble.entrySet()) {
                String fragmentName = (String)entry.getValue().get("source");
                System.out.println("The fragment name is " + fragmentName);
                String fragmentPath = "/content/dam/fidelitydemo/fragments/" + fragmentName + "/jcr:content/renditions/original/jcr:content";
                System.out.println(entry.getKey() + " = " + entry.getValue().get("source"));
                Node fragment = (Node)this.getResolver.getFormsServiceResolver().getResource(fragmentPath).adaptTo(Node.class);
                InputStream fragmentis = fragment.getProperty("jcr:data").getBinary().getStream();
                Document fragmentToInclude = new Document(fragmentis);
                System.out.println("$$$$ Added document " + fragmentName + " to the map");
                mapOfDocuments.put(fragmentName, fragmentToInclude);
                fragmentName = null;
            }
            for (Map.Entry entry : mapOfDocuments.entrySet()) {
                System.out.println("The keys in the custom map are " + (String)((Object)entry.getKey()));
            }
            AssemblerOptionSpec aoSpec = new AssemblerOptionSpec();
            aoSpec.setFailOnError(true);
            Object var10_18 = null;
            AssemblerResult assemblerResult = this.assemblerService.invoke(ddx, mapOfDocuments, aoSpec);
            Document pdfRendered = (Document)assemblerResult.getDocuments().get("rendered.pdf");
            Node ocrFiles = (Node)serviceResolver.getResource("/content/ocrfiles").adaptTo(Node.class);
            System.out.println("The jcrNode name is " + ocrFiles.getName());
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            Node ocrFile = ocrFiles.addNode(uuidString + ".pdf", "nt:file");
            System.out.println("The ocrFiles node was created");
            Node resNode = ocrFile.addNode("jcr:content", "nt:resource");
            Session session = (Session)serviceResolver.adaptTo(Session.class);
            ValueFactory valueFactory = session.getValueFactory();
            Binary contentValue = valueFactory.createBinary(pdfRendered.getInputStream());
            resNode.setProperty("jcr:data", contentValue);
            serviceResolver.commit();
            File f1 = new File("c:\\scrapp\\pdfRendered.pdf");
            pdfRendered.copyToFile(f1);
            System.out.println("Assembled fragments succesfully");
            return ocrFile.getPath();
        }
        catch (ValueFormatException e) {
            e.printStackTrace();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (OperationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Document mergeDataWithXdpTemplate(HashMap<String, Document> templateAndDataFile) {
        Document xdpTemplate = templateAndDataFile.get("xdpTemplate");
        Document xmlData = templateAndDataFile.get("xmlData");
        PDFOutputOptions pdfOptions = new PDFOutputOptions();
        pdfOptions.setAcrobatVersion(com.adobe.fd.output.api.AcrobatVersion.Acrobat_11);
        try {
            Document generatedDocument = this.outputService.generatePDFOutput(xdpTemplate, xmlData, pdfOptions);
            return generatedDocument;
        }
        catch (OutputServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document generateMultiplePdfs(HashMap<String, String> templateMap, HashMap<String, Document> dataFileMap, String saveLocation) {
        log.debug("will save generated documents to " + saveLocation);
        PDFOutputOptions pdfOptions = new PDFOutputOptions();
        pdfOptions.setAcrobatVersion(com.adobe.fd.output.api.AcrobatVersion.Acrobat_11);
        BatchOptions batchOptions = new BatchOptions();
        batchOptions.setGenerateManyFiles(true);
        BatchResult batchResult = null;
        try {
            batchResult = this.outputService.generatePDFOutputBatch(templateMap, dataFileMap, pdfOptions, batchOptions);
            FileOutputStream fos = new FileOutputStream(saveLocation + File.separator + "zippedfile.zip");
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            FileInputStream fis = null;
            for (int i = 0; i < batchResult.getGeneratedDocs().size(); ++i) {
                int length;
                log.debug("inside the loop");
                Document dataMergedDoc = (Document)batchResult.getGeneratedDocs().get(i);
                log.debug("Got document " + i);
                dataMergedDoc.copyToFile(new File(saveLocation + File.separator + i + ".pdf"));
                log.debug("saved file " + i);
                File fileToZip = new File(saveLocation + File.separator + i + ".pdf");
                fis = new FileInputStream(fileToZip);
                ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zipOut.write(bytes, 0, length);
                }
                fis.close();
            }
            zipOut.close();
            fos.close();
            Document zippedDocument = new Document(new File(saveLocation + File.separator + "zippedfile.zip"));
            log.debug("Got zipped file from file system");
            return zippedDocument;
        }
        catch (OutputServiceException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonObject extractDataFromBarCode(Document paramDocument) {
        try {
            org.w3c.dom.Document result = this.barcodeService.decode(paramDocument, Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), CharSet.UTF_8);
            List listResult = this.barcodeService.extractToXML(result, Delimiter.Carriage_Return, Delimiter.Tab, XMLFormat.XDP);
            NodeList childNodes = ((org.w3c.dom.Document)listResult.get(0)).getElementsByTagName("form1").item(0).getChildNodes();
            System.out.println("the form1 lenght is " + childNodes.getLength());
            org.w3c.dom.Document xmlData = (org.w3c.dom.Document)listResult.get(0);
            JsonObject decodedData = new JsonObject();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String elementName = childNodes.item(i).getNodeName();
                System.out.println("The element name is " + elementName);
                String elementValue = childNodes.item(i).getTextContent();
                decodedData.addProperty(elementName, elementValue);
            }
            System.out.println("The JSON Object is " + decodedData.toString());
            return decodedData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonObject assembleDocumentsWithDDX(Map<String, RequestParameter[]> params) {
        Document ddxDocument = null;
        Document pdfDocument = null;
        HashMap<String, Object> mapOfDocuments = new HashMap<String, Object>();
        for (Map.Entry<String, RequestParameter[]> pairs : params.entrySet()) {
            RequestParameter[] pArr = pairs.getValue();
            RequestParameter param = pArr[0];
            try {
                if (param.isFormField()) continue;
                if (param.getFileName().endsWith("ddx")) {
                    ddxDocument = new Document(param.getInputStream());
                    System.out.println("The file name is " + param.getFileName());
                    continue;
                }
                pdfDocument = new Document(param.getInputStream());
                System.out.println("The file name is " + param.getFileName());
                mapOfDocuments.put(param.getFileName(), pdfDocument);
            }
            catch (Exception e) {
                log.debug("Error in merging data with pdf document" + e.getMessage());
            }
        }
        System.out.println("Ready to assemble files");
        Document assembledDocument = this.assembleDocuments(mapOfDocuments, ddxDocument);
        String docPath = this.saveDocumentInCrx("/content/demofilesuploaded", ".pdf", assembledDocument);
        JsonObject json = new JsonObject();
        json.addProperty("path", docPath);
        return json;
    }

    @Override
    public JsonObject mergeDataUsingOutput(Map<String, RequestParameter[]> params) {
        Document xmlDocument = null;
        Document pdfDocument = null;
        HashMap mapOfDocuments = new HashMap();
        for (Map.Entry<String, RequestParameter[]> pairs : params.entrySet()) {
            RequestParameter[] pArr = pairs.getValue();
            RequestParameter param = pArr[0];
            try {
                if (param.isFormField()) continue;
                if (param.getFileName().endsWith("xml")) {
                    xmlDocument = new Document(param.getInputStream());
                    System.out.println("The file name is " + param.getFileName());
                    continue;
                }
                pdfDocument = new Document(param.getInputStream());
                System.out.println("The file name is " + param.getFileName());
            }
            catch (Exception e) {
                log.debug("Error in merging data with pdf document" + e.getMessage());
            }
        }
        System.out.println("Ready to assemble files");
        PDFOutputOptions pdfOptions = new PDFOutputOptions();
        pdfOptions.setAcrobatVersion(com.adobe.fd.output.api.AcrobatVersion.Acrobat_11);
        try {
            Document flattenedPDF = this.outputService.generatePDFOutput(pdfDocument, xmlDocument, pdfOptions);
            String docPath = this.saveDocumentInCrx("/content/demofilesuploaded", ".pdf", flattenedPDF);
            JsonObject json = new JsonObject();
            json.addProperty("path", docPath);
            return json;
        }
        catch (OutputServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonObject importDataPDF(Map<String, RequestParameter[]> params) {
        Document xmlDocument = null;
        Document pdfDocument = null;
        for (Map.Entry<String, RequestParameter[]> pairs : params.entrySet()) {
            RequestParameter[] pArr = pairs.getValue();
            RequestParameter param = pArr[0];
            try {
                if (!param.isFormField()) {
                    if (param.getFileName().endsWith("xml")) {
                        xmlDocument = new Document(param.getInputStream());
                    } else {
                        pdfDocument = new Document(param.getInputStream());
                    }
                }
                String docPath = this.saveDocumentInCrx("/content/ocrfiles", ".pdf", this.formsService.importData(pdfDocument, xmlDocument));
                JsonObject json = new JsonObject();
                json.addProperty("path", docPath);
                return json;
            }
            catch (Exception e) {
                log.debug("Error in merging data with pdf document" + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public JsonObject exportDataFromPDF(Map<String, RequestParameter[]> params) {
        for (Map.Entry<String, RequestParameter[]> pairs : params.entrySet()) {
            RequestParameter[] pArr = pairs.getValue();
            RequestParameter param = pArr[0];
            try {
                if (param.isFormField()) continue;
                Document pdfDocument = new Document(param.getInputStream());
                String docPath = this.saveDocumentInCrx("/content/ocrfiles", ".xml", this.formsService.exportData(pdfDocument, DataFormat.Auto));
                JsonObject json = new JsonObject();
                json.addProperty("path", docPath);
                return json;
            }
            catch (Exception e) {
                log.debug("the error is " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public JsonObject imageToPDF(Map<String, RequestParameter[]> params) {
        CreatePDFResult pdfResult = null;
        System.out.println("In imageToPDF");
        for (Map.Entry<String, RequestParameter[]> pairs : params.entrySet()) {
            RequestParameter[] pArr = pairs.getValue();
            RequestParameter param = pArr[0];
            try {
                if (param.isFormField()) continue;
                System.out.println("The part name " + param.getFileName());
                Document imageDocument = new Document(param.getInputStream());
                pdfResult = this.generatePdfService.createPDF2(imageDocument, ".jpg", "Standard", "Smallest File Size", "No Security", null, null);
                String docPath = this.saveDocumentInCrx("/content/ocrfiles", ".pdf", pdfResult.getCreatedDocument());
                JsonObject json = new JsonObject();
                json.addProperty("path", docPath);
                return json;
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Document htmlFileToPDF(Document zippedFile) {
        HtmlToPdfResult htmpToPDFResult = null;
        try {
            htmpToPDFResult = this.generatePdfService.htmlFileToPdf(zippedFile, "Standard", "No Security", null, null);
        }
        catch (com.adobe.pdfg.exception.ConversionException e) {
            e.printStackTrace();
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
        }
        catch (FileFormatNotSupportedException e) {
            e.printStackTrace();
        }
        return htmpToPDFResult.getCreatedDocument();
    }

    @Override
    public Document renderXDPUsingFormsService(String xdpName, Document xmlData) {
        System.out.println("In render xdp using forms service");
        String xdpTemplatePath = "crx:///content/dam/formsanddocuments";
        PDFFormRenderOptions renderOptions = new PDFFormRenderOptions();
        renderOptions.setAcrobatVersion(AcrobatVersion.Acrobat_11);
        renderOptions.setContentRoot(xdpTemplatePath);
        renderOptions.setRenderAtClient(RenderAtClient.NO);
        try {
            return this.formsService.renderPDFForm(xdpName, xmlData, renderOptions);
        }
        catch (FormsServiceException e) {
            System.out.println("Error rendering xdp as PDF" + e.getMessage());
            return null;
        }
    }

    @Override
    public Document convertToPDFA(Document pdfDocument) {
        System.out.println("In converting to PDFA");
        PDFAConversionOptionSpec pdfaConversion = new PDFAConversionOptionSpec();
        pdfaConversion.setCompliance(PDFAConversionOptionSpec.Compliance.PDFA_2B);
        pdfaConversion.setColorSpace(PDFAConversionOptionSpec.ColorSpace.S_RGB);
        try {
            return this.assemblerService.toPDFA(pdfDocument, pdfaConversion).getPDFADocument();
        }
        catch (ConversionException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}

