(function ($, $document) {
   "use strict";

    /*global mxml */
     $(window).on("load", function() {
    
        var dialog = new Coral.Dialog().set({
            id: 'insertJIRARef',
            header: {
                innerHTML: 'Insert JIRA Reference'
            },
            content: {
                innerHTML: '<div class="container"><p>Add JIRA Reference</p><div class="form-group"><label for="src">Select or enter ID?</label><select style="width: 12rem; margin-top: 5px; display: block;" class="coral3-Select-button coral3-Select" id="jira-id"><option selected>JIRA-124</option><option>JIRA-981</option></select></div></div>'
            },
            footer: {
                innerHTML: '<button id="cancelButton" is="coral-button" variant="default" coral-close>Cancel</button><button id="submitButton" is="coral-button" variant="primary">Add to XML</button>'
            }
        });

        document.body.appendChild(dialog);
        fmxml.commandHandler.subscribe({
            key: 'insertJIRARef',
            next: function() {
				if(tcx.curEditor.editor.canInsertXmlElement('change-request-id')) {
					document.querySelector('#insertJIRARef').show();
					var currentPath = $(location).attr("href"),

					dialog = document.querySelector('#insertJIRARef');
					dialog.on('coral-overlay:close', function(event) {});

					dialog.on('click', '#submitButton', function(e) {
						e.preventDefault();
						//console.log("Updated change-request-id in editor XML")

						var jiraId = $('#jira-id').val();
						var xmlString = '<change-request-id>'+jiraId+'</change-request-id>';
						tcx.eventHandler.next(tcx.eventHandler.KEYS.AUTHOR_INSERT_XML, {args: xmlString})
						document.querySelector('#insertJIRARef').hide();
						dialog.hide();
		
					});
				} else {
					const opts = {
					  title: 'Warning',
					  message: '"change-request-id" not allowed here',
					  variant: 'warning'
					}
					tcx.eventHandler.next(tcx.eventHandler.KEYS.APP_MESSAGE_BOX_SHOW, opts)
				}
            }
    
        });

    });

})($, $(document));
