<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="#all"
	version="2.0">
	
	<xsl:import href="plugin:org.dita.html5:xsl/dita2html5.xsl"/>
	<xsl:param name="metadata.url"/>
		
	<!-- copyright template is empty by default, we are using it to create meta elements after the default meta elements but before link and title elements -->
	<!-- alternatively, <xsl:template name="/|node()|@*" mode="gen-user-head"> could be used but it generates meta elements at the end of head element -->
	<xsl:template name="copyright">
		<xsl:if test="doc-available( $metadata.url )">
			<xsl:variable name="docName" select="tokenize( base-uri(), '/' )[ last() ]"/>
			<xsl:variable name="doc" select="doc( $metadata.url )"/>
			<xsl:for-each select="$doc//Path[ ends-with( @id, concat( '\', $docName ) ) ]/metadata/meta">
				<meta name="{ @key }" content="{ . }"/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>