/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2013 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/



(function(_, $, xfalib){
    xfalib.view.util.CustomErrorManager = {

        options: {
            warningMessageVisible:false,
            errorMessageVisible: false
        },
		
		onFieldEnter: function () {
        },

        onFieldExit: function () {
        },
		
        markError: function (jqWidget, msg, type) {
            var element = jqWidget.element,		//Gives the div containing widget
                pos = $(element).offset(),	 	//Calculates the position of the div in the view port
				msgHeight = xfalib.view.util.TextMetrics.measureExtent(msg).height + 5;  //Calculating the height of the Error Message
                styles = {};
                styles.left = pos.left + "px";	 // Assign the desired left position using pos.left. Here it is calculated for exact left of the field 
                styles.top = pos.top - msgHeight + "px";  // Assign the desired top position using pos.top. Here it is calculated for top of the field 
            if (type != "warning") {
                if(!jqWidget.errorDiv){
					//Adding the warning div if it is not present already
                    jqWidget.errorDiv=$("<div id='customError'></div>").appendTo('body');
                }
                jqWidget.$css(jqWidget.errorDiv.get(0), styles); // Applying the styles to the warning div
                jqWidget.errorDiv.text(msg).show();		//Showing the warning message
            } else {
                if(!jqWidget.errorDiv){
					//Adding the error div if it is not present already
                    jqWidget.errorDiv=$("<div id='customWarning'></div>").appendTo('body');
                }
                jqWidget.$css(jqWidget.errorDiv.get(0), styles); // Applying the styles to the error div
                jqWidget.errorDiv.text(msg).show();		//Showing the warning message
            }

        },

        clearError: function (jqWidget) {
            this.onFieldExit();
            if(jqWidget.errorDiv) {
                jqWidget.errorDiv.hide(); // Once the error is fixed then hiding the warning div
            }
            $("#warning-msg").hide();	//	Once the warning is fixed then hiding the warning div
        }

     }
    })(_, jQuery, xfalib);
