/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2014 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.adobe.fd.fp.config;

import java.util.Dictionary;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

@Component(metatype = true, label = "Forms Portal Draft and Submission Configuration", description = "Forms Portal Draft and Submission Configuration")
@Service(value = FormsPortalDraftsandSubmissionConfigService.class)

public class FormsPortalDraftsandSubmissionConfigService {
    
    private static final String DEFAULT_DRAFT_DATA_SERVICE = "com.adobe.fd.fp.service.impl.DraftDataServiceImpl";
    private static final String DEFAULT_SUBMIT_DATA_SERVICE = "com.adobe.fd.fp.service.impl.SubmitDataServiceImpl";
    private static final String DEFAULT_PENDING_SIGN_DATA_SERVICE = "com.adobe.fd.fpaddon.service.impl.PendingSignDataServiceImpl";
    private static final String DEFAULT_DRAFT_METADATA_SERVICE = "com.adobe.fd.fp.service.impl.DraftMetadataServiceImpl";
    private static final String DEFAULT_SUBMIT_METADATA_SERVICE = "com.adobe.fd.fp.service.impl.SubmitMetadataServiceImpl";
    private static final String DEFAULT_PENDING_SIGN_METADATA_SERVICE = "com.adobe.fd.fpaddon.service.impl.PendingSignMetadataServiceImpl";
    private static final String[] DEFAULT_FP_OUTBOXES = {"outbox"};
    private static final String DEFAULT_FP_ROOT = "/content/forms/fp";    

    @Property(cardinality = 2000, value = {"outbox"}, label = "Outboxes to be used for Reverse Replication in Forms Portal", description = "To configure outboxes for Forms Portal Draft Save and Submit Options")
    private static final String FP_OUTBOXES = "portal.outboxes";   
    private String[] fpOutboxes = DEFAULT_FP_OUTBOXES;
    
    @Property(value = DEFAULT_DRAFT_DATA_SERVICE, label = "Forms Portal Draft Data Service", description = "Identifier for draft data service")
    private static final String FP_DRAFT_DATA_SERVICE = "draft.data.service";    
    private String draftDataService = DEFAULT_DRAFT_DATA_SERVICE;

    @Property(value = DEFAULT_DRAFT_METADATA_SERVICE, label = "Forms Portal Draft Metadata Service", description = "Identifier for draft metadata service")
    private static final String FP_DRAFT_METADATA_SERVICE = "draft.metadata.service";    
    private String draftMetadataService = FP_DRAFT_METADATA_SERVICE;
    
    @Property(value = DEFAULT_SUBMIT_DATA_SERVICE, label = "Forms Portal Submit Data Service", description = "Identifier for submit data service")
    private static final String FP_SUBMIT_DATA_SERVICE = "submit.data.service";    
    private String submitDataService = DEFAULT_SUBMIT_DATA_SERVICE;
    
    @Property(value = DEFAULT_SUBMIT_METADATA_SERVICE, label = "Forms Portal Submit Metadata Service", description = "Identifier for submit metadata service")
    private static final String FP_SUBMIT_METADATA_SERVICE = "submit.metadata.service";    
    private String submitMetadataService = FP_DRAFT_METADATA_SERVICE;
    
    @Property(value = DEFAULT_PENDING_SIGN_DATA_SERVICE, label = "Forms Portal Pending Sign Data Service", description = "Identifier for pending sign data service")
    private static final String FP_PENDING_SIGN_DATA_SERVICE = "pendingSign.data.service";    
    private String pendingSignDataService = DEFAULT_PENDING_SIGN_DATA_SERVICE;
    
    @Property(value = DEFAULT_PENDING_SIGN_METADATA_SERVICE, label = "Forms Portal Pending Sign Metadata Service", description = "Identifier for pending sign metadata service")
    private static final String FP_PENDING_SIGN_METADATA_SERVICE = "pendingSign.metadata.service";    
    private String pendingSignMetadataService = DEFAULT_PENDING_SIGN_METADATA_SERVICE;

    @SuppressWarnings("deprecation")
	protected void activate(ComponentContext context){
		@SuppressWarnings("unchecked")
		Dictionary<String, Object> props = context.getProperties();
		fpOutboxes                       				= OsgiUtil.toStringArray(props.get(FP_OUTBOXES), DEFAULT_FP_OUTBOXES);
		draftDataService                 			= OsgiUtil.toString(props.get(FP_DRAFT_DATA_SERVICE), DEFAULT_DRAFT_DATA_SERVICE);
		draftMetadataService            	 		= OsgiUtil.toString(props.get(FP_DRAFT_METADATA_SERVICE), DEFAULT_DRAFT_METADATA_SERVICE);
		submitDataService                			= OsgiUtil.toString(props.get(FP_SUBMIT_DATA_SERVICE), DEFAULT_SUBMIT_DATA_SERVICE);
		submitMetadataService            		= OsgiUtil.toString(props.get(FP_SUBMIT_METADATA_SERVICE), DEFAULT_SUBMIT_METADATA_SERVICE);
		pendingSignDataService 			 	= OsgiUtil.toString(props.get(FP_PENDING_SIGN_DATA_SERVICE), DEFAULT_PENDING_SIGN_DATA_SERVICE);
		pendingSignMetadataService		 	= OsgiUtil.toString(props.get(FP_PENDING_SIGN_METADATA_SERVICE), DEFAULT_PENDING_SIGN_METADATA_SERVICE);
	}

	public String getDraftDataService() {
		return draftDataService;
	}
	
	public String getSubmitDataService() {
		return submitDataService;
	}
	
	public String getDraftMetadataService() {
		return draftMetadataService;
	}
	
	public String getSubmitMetadataService(){
		return submitMetadataService;
	}
	
	public String getFormsPortalRoot() {
        return DEFAULT_FP_ROOT;
	}
	
	public String[] getFormsPortalOutboxes(){
		return fpOutboxes;
	}

	/**
	 * @return the pendingSignDataService
	 */
	public String getPendingSignDataService() {
		return pendingSignDataService;
	}

	/**
	 * @return the pendingSignMetadataService
	 */
	public String getPendingSignMetadataService() {
		return pendingSignMetadataService;
	}

}
