/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.w3c.dom.Document;

public class GuideModelUtils {
    public static String getDataForDORMerge(Document dataDocument, JSONObject guideContainerJson) throws JSONException {
        String xdpRef = guideContainerJson.has("xdpRef") ? guideContainerJson.getString("xdpRef") : null;
        String xsdRef = guideContainerJson.has("xsdRef") ? guideContainerJson.getString("xsdRef") : null;
        return GuideModelUtils.getDataForDORMerge(dataDocument, xdpRef, xsdRef);
    }

    public static String getDataForDORMerge(Document dataDocument, Resource guideContainerResource) {
        ValueMap guideContainerProps = guideContainerResource.getValueMap();
        String xdpRef = (String)guideContainerProps.get("xdpRef", String.class);
        String xsdRef = (String)guideContainerProps.get("xsdRef", String.class);
        return GuideModelUtils.getDataForDORMerge(dataDocument, xdpRef, xsdRef);
    }

    private static String getDataForDORMerge(Document dataDocument, String xdpRef, String xsdRef) {
        if (StringUtils.isNotEmpty((String)xdpRef) || StringUtils.isNotEmpty((String)xsdRef)) {
            return XMLUtils.getBoundDataXmlPart(dataDocument);
        }
        return XMLUtils.getUnboundDataXmlPart(dataDocument);
    }
}

