/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.docassurance.client.api;

import com.adobe.aemfd.docmanager.Document;
import com.adobe.fd.docassurance.client.api.DocAssuranceException;
import com.adobe.fd.docassurance.client.api.EncryptionOptions;
import com.adobe.fd.docassurance.client.api.ReaderExtensionOptions;
import com.adobe.fd.docassurance.client.api.SignatureOptions;
import com.adobe.fd.encryption.client.EncryptionTypeResult;
import com.adobe.fd.readerextensions.client.GetUsageRightsResult;
import com.adobe.fd.readerextensions.client.ReaderExtensionsException;
import com.adobe.fd.signatures.client.types.FieldMDPOptionSpec;
import com.adobe.fd.signatures.client.types.PDFDocumentVerificationInfo;
import com.adobe.fd.signatures.client.types.PDFSeedValueOptionSpec;
import com.adobe.fd.signatures.client.types.PDFSignature;
import com.adobe.fd.signatures.client.types.PDFSignatureField;
import com.adobe.fd.signatures.client.types.PDFSignatureFieldProperties;
import com.adobe.fd.signatures.client.types.PDFSignatureVerificationInfo;
import com.adobe.fd.signatures.client.types.PositionRectangle;
import com.adobe.fd.signatures.client.types.VerificationTime;
import com.adobe.fd.signatures.pdf.inputs.UnlockOptions;
import com.adobe.fd.signatures.pdf.inputs.ValidationPreferences;
import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import java.util.List;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DocAssuranceService {
    public Document secureDocument(Document var1, EncryptionOptions var2, SignatureOptions var3, ReaderExtensionOptions var4, UnlockOptions var5) throws Exception;

    public Document addSignatureField(Document var1, String var2, Integer var3, PositionRectangle var4, FieldMDPOptionSpec var5, PDFSeedValueOptionSpec var6, UnlockOptions var7) throws Exception;

    public Document addInvisibleSignatureField(Document var1, String var2, FieldMDPOptionSpec var3, PDFSeedValueOptionSpec var4, UnlockOptions var5) throws Exception;

    public Document clearSignatureField(Document var1, String var2, UnlockOptions var3) throws Exception;

    public PDFSignatureField getCertifyingSignatureField(Document var1, UnlockOptions var2) throws Exception;

    public PDFSignature getSignature(Document var1, String var2, UnlockOptions var3) throws Exception;

    public Document removeSignatureField(Document var1, String var2, UnlockOptions var3) throws Exception;

    public List<PDFSignatureField> getSignatureFieldList(Document var1, UnlockOptions var2) throws Exception;

    public Document modifySignatureField(Document var1, String var2, PDFSignatureFieldProperties var3, UnlockOptions var4) throws Exception;

    public PDFSignatureVerificationInfo verify(Document var1, String var2, RevocationCheckStyle var3, VerificationTime var4, ValidationPreferences var5, ResourceResolver var6) throws Exception;

    public Document removePDFPasswordSecurity(Document var1, String var2) throws Exception;

    public EncryptionTypeResult getPDFEncryption(Document var1) throws Exception;

    public Document removePDFCertificateSecurity(Document var1, String var2, ResourceResolver var3) throws Exception;

    public PDFDocumentVerificationInfo verifyDocument(Document var1, RevocationCheckStyle var2, VerificationTime var3, ValidationPreferences var4, ResourceResolver var5) throws DocAssuranceException, Exception;

    public Document removeUsageRights(Document var1, UnlockOptions var2) throws DocAssuranceException, Exception;

    public GetUsageRightsResult getDocumentUsageRights(Document var1, UnlockOptions var2) throws DocAssuranceException, Exception;

    public GetUsageRightsResult getCredentialUsageRights(String var1, ResourceResolver var2) throws ReaderExtensionsException;
}

