/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.docmanager;

import com.adobe.aemfd.docmanager.internal.passivation.ByteArrayPassivationHandler;
import com.adobe.aemfd.docmanager.internal.passivation.FilePassivationHandler;
import com.adobe.aemfd.docmanager.internal.passivation.InputStreamPassivationHandler;
import com.adobe.aemfd.docmanager.internal.passivation.jcr.JcrURLPassivationHandler;
import com.adobe.aemfd.docmanager.internal.passivation.jcr.ProvidedJcrURLPassivationHandler;
import com.adobe.aemfd.docmanager.internal.passivation.url.URLPassivationHandler;
import com.adobe.aemfd.docmanager.internal.source.ByteArraySourceHandler;
import com.adobe.aemfd.docmanager.io.IOUtils;
import com.adobe.aemfd.docmanager.passivation.DocumentPassivationHandler;
import com.adobe.aemfd.docmanager.passivation.PassivationConnection;
import com.adobe.aemfd.docmanager.passivation.PassivationType;
import com.adobe.aemfd.docmanager.source.DocumentSourceHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends SlingAdaptable
implements Closeable,
Adaptable {
    private static final Logger logger = LoggerFactory.getLogger(Document.class);
    private int maxInlineSize = 65536;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private String contentType = null;
    private DocumentPassivationHandler passivationHandler;
    private boolean passivated = false;
    private DocumentSourceHandler sourceHandler;
    private boolean disposed = false;
    private byte[] inlineData = null;
    public static final String SOURCE_URL_ATTRIBUTE = "adobe.docmanager.source.url";
    public static final String SOURCE_FILE_ATTRIBUTE = "adobe.docmanager.source.file";
    public static final String SOURCE_JCR_PATH_ATTRIBUTE = "adobe.docmanager.source.jcr.path";

    public Document(byte[] data) {
        this.passivationHandler = new ByteArrayPassivationHandler(data);
    }

    public Document(URL url) {
        this.passivationHandler = new URLPassivationHandler(url);
        this.setAttribute(SOURCE_URL_ATTRIBUTE, url.toExternalForm());
    }

    public Document(File file) {
        this(file, false);
    }

    public Document(File file, boolean ownFile) {
        this.passivationHandler = new FilePassivationHandler(file, ownFile);
        this.setAttribute(SOURCE_FILE_ATTRIBUTE, file.getPath());
    }

    public Document(InputStream is) {
        this.passivationHandler = new InputStreamPassivationHandler(is);
    }

    public Document(String jcrPath) {
        this.passivationHandler = new JcrURLPassivationHandler(jcrPath);
        this.setAttribute(SOURCE_JCR_PATH_ATTRIBUTE, jcrPath);
    }

    public Document(String jcrPath, ResourceResolver resolver) {
        this(jcrPath, resolver, false);
    }

    public Document(String jcrPath, ResourceResolver resolver, boolean manageResolver) {
        this.passivationHandler = new ProvidedJcrURLPassivationHandler(jcrPath, resolver, manageResolver);
        this.setAttribute(SOURCE_JCR_PATH_ATTRIBUTE, jcrPath);
    }

    public Document(DocumentPassivationHandler passivationHandler) {
        this.passivationHandler = passivationHandler;
    }

    protected void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Document is in a disposed state!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentSourceHandler doPassivate(Document d, DocumentPassivationHandler ph) throws IOException {
        PassivationConnection pc = ph.openConnectionForPassivation();
        PassivationType pType = null;
        try {
            DocumentSourceHandler result;
            long l = pc.getLength();
            String ct = pc.getContentType();
            int mil = d.getMaxInlineSize();
            if (l != -1L) {
                if (l > (long)mil) {
                    result = ph.handlePassivation(null, pc);
                    pType = PassivationType.EXTERNALIZED;
                } else {
                    byte[] data = IOUtils.getBytes((InputStream)pc.getContentStream(), (Integer)((int)l));
                    d.inlineData = data;
                    ph.inlined();
                    result = new ByteArraySourceHandler(data, ct);
                    pType = PassivationType.INLINED;
                }
            } else {
                int maxToRead = mil + 1;
                byte[] preBuf = IOUtils.getBytes((InputStream)pc.getContentStream(), (Integer)maxToRead);
                if (preBuf.length == maxToRead) {
                    result = ph.handlePassivation(preBuf, pc);
                    pType = PassivationType.EXTERNALIZED;
                } else {
                    d.inlineData = preBuf;
                    ph.inlined();
                    result = new ByteArraySourceHandler(preBuf, ct);
                    pType = PassivationType.INLINED;
                }
            }
            DocumentSourceHandler documentSourceHandler = result;
            ph.dispose(pc, pType != null, pType);
            return documentSourceHandler;
        }
        catch (Throwable throwable) {
            ph.dispose(pc, pType != null, pType);
            throw throwable;
        }
    }

    protected void prePassivate() throws IOException {
    }

    protected void postPassivate() throws IOException {
    }

    public void passivate() throws IOException {
        this.checkDisposed();
        if (!this.passivated) {
            this.prePassivate();
            this.sourceHandler = Document.doPassivate(this, this.passivationHandler);
            this.passivationHandler.release(true, this.inlineData == null ? PassivationType.EXTERNALIZED : PassivationType.INLINED);
            this.passivationHandler = null;
            this.passivated = true;
            this.postPassivate();
        }
    }

    public DocumentSourceHandler getSourceHandler() {
        this.checkDisposed();
        return this.sourceHandler;
    }

    public byte[] getInlineData() throws IOException {
        this.passivate();
        return this.inlineData;
    }

    public InputStream getInputStream() throws IOException {
        this.passivate();
        return this.sourceHandler.getInputStream();
    }

    public long length() throws IOException {
        this.passivate();
        return this.sourceHandler.length();
    }

    public String getContentType() throws IOException {
        this.checkDisposed();
        if (this.contentType != null) {
            return this.contentType;
        }
        this.passivate();
        return this.sourceHandler.getContentType();
    }

    public void dispose() {
        if (this.disposed) {
            logger.warn("dispose() called on already disposed document, ignoring...");
            return;
        }
        if (!this.passivated) {
            this.passivationHandler.release(false, null);
            this.passivationHandler = null;
        } else {
            this.sourceHandler.dispose();
            this.sourceHandler = null;
            this.inlineData = null;
        }
        this.attributes.clear();
        this.contentType = null;
        this.disposed = true;
    }

    public int getMaxInlineSize() {
        this.checkDisposed();
        return this.maxInlineSize;
    }

    public void setMaxInlineSize(int maxInlineSize) {
        this.checkDisposed();
        if (this.passivated) {
            throw new IllegalStateException("Document has already been passivated!");
        }
        this.maxInlineSize = maxInlineSize;
    }

    public Object getAttribute(String name) {
        this.checkDisposed();
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object val) {
        this.checkDisposed();
        this.attributes.put(name, val);
    }

    public void removeAttribute(String name) {
        this.checkDisposed();
        this.attributes.remove(name);
    }

    public void setContentType(String contentType) {
        this.checkDisposed();
        this.contentType = contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToFile(File file) throws IOException {
        InputStream is = this.getInputStream();
        try {
            IOUtils.copyToFile((InputStream)is, (File)file);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close input-stream of type " + is.getClass().getName() + " while cleaning up in copyToFile()", (Throwable)e);
            }
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        this.checkDisposed();
        if (type == InputStream.class) {
            try {
                return (AdapterType)this.getInputStream();
            }
            catch (IOException e) {
                throw new SlingIOException(e);
            }
        }
        if (type == Map.class) {
            return (AdapterType)Collections.unmodifiableMap(this.attributes);
        }
        if (type == ValueMap.class) {
            return (AdapterType)((Object)new ValueMapDecoratorExt(Collections.unmodifiableMap(this.attributes)));
        }
        return (AdapterType)super.adaptTo(type);
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            this.dispose();
        }
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        this.dispose();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new UnsupportedOperationException("Serialization unsupported!");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Serialization unsupported!");
    }

    private static class ValueMapDecoratorExt
    extends ValueMapDecorator {
        private ValueMapDecoratorExt(Map base) {
            super(base);
        }
    }
}

