/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.felix.scrplugin.annotations.ClassAnnotation;
import org.apache.felix.scrplugin.annotations.FieldAnnotation;
import org.apache.felix.scrplugin.annotations.MethodAnnotation;
import org.apache.felix.scrplugin.annotations.ScannedAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScannedClass {
    private final List<ScannedAnnotation> descriptions = new ArrayList<ScannedAnnotation>();
    private final Class<?> scannedClass;

    public ScannedClass(List<ScannedAnnotation> desc, Class<?> scannedClass) {
        this.descriptions.addAll(desc);
        this.scannedClass = scannedClass;
    }

    public Class<?> getScannedClass() {
        return this.scannedClass;
    }

    public void processed(ScannedAnnotation desc) {
        this.descriptions.remove(desc);
    }

    public void processed(Collection<? extends ScannedAnnotation> desc) {
        this.descriptions.removeAll(desc);
    }

    public List<ClassAnnotation> getClassAnnotations(String name) {
        ArrayList<ClassAnnotation> list = new ArrayList<ClassAnnotation>();
        for (ScannedAnnotation desc : this.descriptions) {
            if (!(desc instanceof ClassAnnotation) || name != null && !desc.getName().equals(name)) continue;
            list.add((ClassAnnotation)desc);
        }
        return list;
    }

    public List<FieldAnnotation> getFieldAnnotations(String name) {
        ArrayList<FieldAnnotation> list = new ArrayList<FieldAnnotation>();
        for (ScannedAnnotation desc : this.descriptions) {
            if (!(desc instanceof FieldAnnotation) || name != null && !desc.getName().equals(name)) continue;
            list.add((FieldAnnotation)desc);
        }
        return list;
    }

    public List<MethodAnnotation> getMethodAnnotations(String name) {
        ArrayList<MethodAnnotation> list = new ArrayList<MethodAnnotation>();
        for (ScannedAnnotation desc : this.descriptions) {
            if (!(desc instanceof MethodAnnotation) || name != null && !desc.getName().equals(name)) continue;
            list.add((MethodAnnotation)desc);
        }
        return list;
    }
}

