/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.common.GuideNode;
import com.adobe.aemds.guide.common.GuidePanel;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideIntegrationService;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.day.cq.i18n.I18n;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuideContainer
extends GuideNode {
    private GuideModelTransformer guideModelTransformer = null;
    private String defaultDataXml = null;

    public GuideContainer() {
    }

    public GuideContainer(SlingHttpServletRequest request, Resource resource) {
        this.setResource(resource);
        this.setSlingRequest(request);
    }

    public GuideContainer(Resource resource) {
        this.setResource(resource);
    }

    public String getRedirect() {
        String redirect = (String)this.resourceProps.get("redirect", (Object)"");
        if (redirect.length() > 0) {
            int lastSlash = redirect.lastIndexOf(47);
            if (redirect.indexOf(46, lastSlash) == -1) {
                redirect = redirect + ".html";
            }
        } else {
            redirect = this.getPath() + "." + "guideThankYouPage.html";
        }
        return redirect;
    }

    public String getXdpRef() {
        return (String)this.resourceProps.get("xdpRef", (Object)"");
    }

    public String getLetterRef() {
        return (String)this.resourceProps.get("letterRef", (Object)"");
    }

    public String getAutoSaveStrategyFilePath() {
        String autoSaveStrategyType = (String)this.resourceProps.get("autoSaveStrategyType", (Object)"");
        if (autoSaveStrategyType != null && !autoSaveStrategyType.isEmpty()) {
            return autoSaveStrategyType + "/" + "init.jsp";
        }
        return null;
    }

    public String getDorTemplateRef() {
        return (String)this.resourceProps.get("dorTemplateRef", (Object)"");
    }

    public Calendar getLastModifiedTime() throws RepositoryException {
        ValueMap properties = (ValueMap)this.resource.getParent().adaptTo(ValueMap.class);
        return (Calendar)properties.get("cq:lastModified", Calendar.class);
    }

    public String getXsdRef() {
        return (String)this.resourceProps.get("xsdRef", (Object)"");
    }

    public String getCssFileRef() {
        return (String)this.resourceProps.get("cssFileRef", null);
    }

    @Override
    public String getClientLibRef() {
        return (String)this.resourceProps.get("clientLibRef", null);
    }

    public boolean isHasToolbar() {
        return this.resource.getChild("toolbar") != null;
    }

    public String getAfPath() {
        return (String)this.resourceProps.get("afPath", null);
    }

    public GuideItemsContainer getToolbar() {
        Resource toolbarResource = this.resource.getChild("toolbar");
        if (toolbarResource != null) {
            GuideItemsContainer guideItemsContainer = new GuideItemsContainer();
            guideItemsContainer.setResource(toolbarResource);
            guideItemsContainer.setSlingRequest(this.slingRequest);
            return guideItemsContainer;
        }
        return null;
    }

    public GuidePanel getRootPanel() {
        return GuideUtils.getRootPanel(this.resource, this.slingRequest);
    }

    public boolean isGuideSyncRequired() {
        boolean hasXDP = !"".equals(this.getXdpRef());
        return hasXDP && this.resourceProps.containsKey((Object)"formModelChanged");
    }

    public boolean isShowAuthoringWarnings() {
        String resourceType = GuideUtils.getNormalizedNodeType(this.getResourceType(), this.getResourceSuperType());
        boolean showWarnings = true;
        if ("fd/adaddon/components/guideDocumentContainer".equals(resourceType)) {
            showWarnings = false;
        }
        return showWarnings;
    }

    public String getStatusBarTitle() {
        I18n i18n = new I18n(this.slingRequest.getResourceBundle(this.slingRequest.getLocale()));
        return i18n.get("Adaptive Form Warnings");
    }

    public String getMobileLayout() {
        String returnLayout = "fd/af/layouts/mobile/simple";
        String mobileLayout = null;
        try {
            mobileLayout = (String)this.getLayoutProperty("mobileLayout");
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving mobile layout. " + e.getMessage(), (Throwable)e);
        }
        if (mobileLayout != null && !mobileLayout.isEmpty()) {
            returnLayout = mobileLayout;
        }
        return returnLayout;
    }

    public Boolean getParseGridLayoutForMenu() {
        Boolean parseGridLayoutForMenu = null;
        try {
            parseGridLayoutForMenu = Boolean.valueOf(String.valueOf(this.getLayoutProperty("parseGridLayoutForMenu")));
        }
        catch (PersistenceException e) {
            this.logger.error("Exception while retrieving parseGridLayoutForMenu check. " + e.getMessage(), (Throwable)e);
        }
        if (parseGridLayoutForMenu == null) {
            parseGridLayoutForMenu = Boolean.FALSE;
        }
        return parseGridLayoutForMenu;
    }

    public String getXDPName() {
        String xdpRef = this.getXdpRef();
        if (xdpRef != null && xdpRef.length() > 0) {
            return StringUtils.substring((String)xdpRef, (int)(StringUtils.lastIndexOf((CharSequence)xdpRef, (CharSequence)"/") + 1));
        }
        return null;
    }

    public boolean isXDPValid() {
        return GuideUtils.isXDPValid(this.resource);
    }

    public void setGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    private GuideModelTransformer getGuideModelTransformer() {
        SlingBindings bindings = null;
        if (this.slingRequest != null) {
            bindings = (SlingBindings)this.slingRequest.getAttribute(SlingBindings.class.getName());
        }
        if (bindings == null) {
            return this.guideModelTransformer;
        }
        return (GuideModelTransformer)bindings.getSling().getService(GuideModelTransformer.class);
    }

    private Map<String, String> getXfaJsonMap() throws GuideException {
        String xdpRef = this.getXdpRef();
        Map<String, String> xfaJsonMap = null;
        Boolean isValidXdp = xdpRef != null && xdpRef.length() > 0 && this.isXDPValid();
        if (isValidXdp.booleanValue()) {
            GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
            xfaJsonMap = guideModelTransformer.exportXfaJson(this.resource);
        }
        return xfaJsonMap;
    }

    public String getXfaRenderContext() throws GuideException {
        Map<String, String> xfaJsonMap;
        String xdpRef = this.getXdpRef();
        String renderContext = "";
        if (xdpRef != null && xdpRef.length() > 0 && (xfaJsonMap = this.getXfaJsonMap()) != null && xfaJsonMap.containsKey("xfaRenderContext")) {
            renderContext = xfaJsonMap.get("xfaRenderContext");
        }
        return renderContext;
    }

    public String getXfaJson() throws GuideException {
        Map<String, String> xfaJsonMap;
        String xdpRef = this.getXdpRef();
        String xfaJson = "";
        if (xdpRef != null && xdpRef.length() > 0 && (xfaJsonMap = this.getXfaJsonMap()) != null && xfaJsonMap.containsKey("formdom")) {
            xfaJson = xfaJsonMap.get("formdom");
        }
        return xfaJson;
    }

    public String getGuideCurrentStateJson() {
        String guideStatePathRef;
        String guideCurrentStateJson = "";
        GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
        String guideStatePath = (String)this.slingRequest.getAttribute("guideStatePath");
        if (guideStatePath == null || guideStatePath.isEmpty()) {
            guideStatePath = this.slingRequest.getParameter("guideStatePath");
        }
        if ((guideStatePathRef = (String)this.slingRequest.getAttribute("guideStatePathRef")) == null || guideStatePathRef.isEmpty()) {
            guideStatePathRef = this.slingRequest.getParameter("guideStatePathRef");
        }
        if (guideStatePath != null && !guideStatePath.isEmpty()) {
            guideCurrentStateJson = guideModelTransformer.exportGuideState(guideStatePath);
        } else if (guideStatePathRef != null && !guideStatePathRef.isEmpty()) {
            guideCurrentStateJson = guideModelTransformer.exportGuideStateFromStore(guideStatePathRef);
        }
        if (guideCurrentStateJson.length() == 0) {
            String data;
            String dataRef = (String)this.slingRequest.getAttribute("dataRef");
            if (dataRef == null || dataRef.isEmpty()) {
                dataRef = this.slingRequest.getParameter("dataRef");
            }
            if ((data = (String)this.slingRequest.getAttribute("data")) == null || data.isEmpty()) {
                data = this.slingRequest.getParameter("data");
            }
            if (data != null && !data.isEmpty()) {
                guideCurrentStateJson = guideModelTransformer.exportGuideDataJson(this.resource, data, this.i18n);
            } else if (dataRef != null && !dataRef.isEmpty()) {
                guideCurrentStateJson = guideModelTransformer.exportGuideDataJsonFromDataRef(this.resource, dataRef, this.i18n);
            }
        }
        return guideCurrentStateJson;
    }

    public String getGuideCurrentStateJson(String dataXml) {
        return this.guideModelTransformer.exportGuideDataJson(this.resource, dataXml, this.i18n);
    }

    public String getGuideContext() {
        GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
        return guideModelTransformer.exportInitialGuideContext(this.resource);
    }

    public String getGuideJson() {
        I18n i18ntemp = this.i18n;
        if (this.slingRequest != null && this.getIsEditMode().booleanValue()) {
            i18ntemp = null;
        }
        GuideModelTransformer guideModelTransformer = this.getGuideModelTransformer();
        return guideModelTransformer.exportGuideJson(this.resource, i18ntemp);
    }

    public String getLayout() {
        String layoutpath = "";
        String jspname = "";
        try {
            Map<String, Object> layoutproperties = null;
            String containerName = GuideContainerThreadLocal.getGuideContainerName();
            layoutproperties = containerName != null ? NodeStructureUtils.getLayoutProperties(this.slingRequest, this.resource, containerName) : (GuideUtils.isGuideContainerResource(this.resource) ? NodeStructureUtils.getLayoutProperties(this.slingRequest, this.resource, this.resource.getName()) : NodeStructureUtils.getLayoutProperties(this.slingRequest, this.resource, "guideContainer"));
            layoutpath = (String)layoutproperties.get("sling:resourceType");
            jspname = layoutpath.substring(layoutpath.lastIndexOf("/") + 1) + ".jsp";
        }
        catch (Exception ex) {
            this.logger.error("Unable to get layout of guide container" + ex.getMessage());
            throw new GuideException(ex.getMessage(), ex);
        }
        return layoutpath + "/" + jspname;
    }

    public List<String> getGuideIntegrationServiceScriptPaths() {
        SlingBindings bindings = (SlingBindings)this.slingRequest.getAttribute(SlingBindings.class.getName());
        GuideIntegrationService guideIntegrationService = (GuideIntegrationService)bindings.getSling().getService(GuideIntegrationService.class);
        return guideIntegrationService.getScriptPaths();
    }

    private String createGuideInitializationState(String dataXml, String locale) {
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)jsonStringWriter);
        GuideModelTransformer guideTransformer = this.getGuideModelTransformer();
        Map<String, Object> jsonMap = guideTransformer.syncXfaProps(this, locale);
        try {
            jsonWriter.object();
            jsonWriter.key("guidejson").value((Object)((String)jsonMap.get("guidejson")));
            jsonWriter.key("guidecontext").value((Object)this.getGuideContext());
            if (dataXml != null) {
                jsonWriter.key("guidemergedjson").value((Object)this.getGuideCurrentStateJson(dataXml));
            } else {
                jsonWriter.key("guidemergedjson").value((Object)this.getGuideCurrentStateJson());
            }
            jsonWriter.key("xfajson").value((Object)((String)jsonMap.get("xfajson")));
            jsonWriter.key("xfarendercontext").value((Object)this.getXfaRenderContext());
            jsonWriter.endObject();
        }
        catch (JSONException ex) {
            this.logger.error("Error in getting guide initialization state" + ex.getMessage());
            throw new GuideException(ex.getMessage(), (Exception)((Object)ex));
        }
        return jsonStringWriter.toString();
    }

    public String getGuideInitializationState() {
        String locale = GuideUtils.getGuideRuntimeLocale(this.slingRequest, this.resource);
        return this.createGuideInitializationState(null, locale);
    }

    public String getGuideInitializationState(String dataXml, String locale) {
        return this.createGuideInitializationState(dataXml, locale);
    }
}

