/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.description;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scrplugin.description.AbstractDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescription {
    final List<AbstractDescription> descriptions = new ArrayList<AbstractDescription>();
    private final Class<?> describedClass;
    private final String source;

    public ClassDescription(Class<?> describedClass, String source) {
        this.describedClass = describedClass;
        this.source = source;
    }

    public Class<?> getDescribedClass() {
        return this.describedClass;
    }

    public String getSource() {
        return this.source;
    }

    public void add(AbstractDescription desc) {
        this.descriptions.add(desc);
        desc.setSource(this.source);
    }

    public <T extends AbstractDescription> List<T> getDescriptions(Class<T> descType) {
        ArrayList<AbstractDescription> result = new ArrayList<AbstractDescription>();
        for (AbstractDescription desc : this.descriptions) {
            if (!descType.isAssignableFrom(desc.getClass())) continue;
            result.add(desc);
        }
        return result;
    }

    public <T extends AbstractDescription> T getDescription(Class<T> descType) {
        List<T> result = this.getDescriptions(descType);
        if (result.size() > 0) {
            return (T)((AbstractDescription)result.get(0));
        }
        return null;
    }

    public String toString() {
        return "ClassDescription [descriptions=" + this.descriptions + ", describedClass=" + this.describedClass + ", source=" + this.source + "]";
    }

    public ClassDescription clone() {
        ClassDescription cd = new ClassDescription(this.describedClass, this.source);
        for (AbstractDescription ad : this.descriptions) {
            cd.add(ad.clone());
        }
        return cd;
    }
}

