/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.services.api.ACMConfigurationService;
import com.adobe.livecycle.content.repository.FileService;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="lc.icc.dbservices.TempFileManager")
@Service(value={Runnable.class})
@Properties(value={@Property(name="scheduler.concurrent", boolValue={false}), @Property(name="scheduler.period", longValue={3600L})})
public class TempFileManager
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TempFileManager.class);
    public static final String TEMP_FILE_PREFIX = "cmtemp_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private String tmpfolder = "C:\\temp";
    @Reference
    private FileService fileService;
    @Reference
    private ACMConfigurationService acmConfigurationService;

    protected void activate(ComponentContext context) {
        this.tmpfolder = this.acmConfigurationService.getTmpFolder();
    }

    public String createTempFileInRepository(InputStream inputStream, String mimeType) throws ICCException {
        try {
            com.adobe.livecycle.content.File file = this.fileService.createFile(inputStream, mimeType, null, null);
            ResourceResolver resourceResolver = ResourceResolverHolder.getResourceResolver();
            Session currentSession = (Session)resourceResolver.adaptTo(Session.class);
            currentSession.save();
            return file.getTempPath();
        }
        catch (Exception e) {
            logger.error("Error while creating temp file in repository. Cause: " + e.getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }

    public void cleanTemp() {
        try {
            logger.debug("CM: Cleaning temp...");
            File tempFolder = new File(this.tmpfolder);
            if (tempFolder.exists() && tempFolder.isDirectory()) {
                File[] files = tempFolder.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    long liveTime;
                    File f = files[i];
                    if (!f.getName().startsWith(TEMP_FILE_PREFIX) || (liveTime = System.currentTimeMillis() - f.lastModified()) <= 600000L) continue;
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error deleting temp files : " + e.getCause().getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
    }

    public File writeTempFile(String name) throws ICCException {
        return this.writeTempFile(name, TEMP_FILE_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeToTempFile(String name, byte[] fileContent) throws FileNotFoundException, IOException {
        File uploadedFile = this.writeTempFile(name);
        FileOutputStream fos = new FileOutputStream(uploadedFile);
        try {
            fos.write(fileContent);
        }
        finally {
            fos.close();
        }
        return uploadedFile;
    }

    public File writeTempFile(String name, String suffix) throws ICCException {
        File tempFile;
        File tmp = new File(this.tmpfolder);
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        try {
            tempFile = File.createTempFile(TEMP_FILE_PREFIX + name, suffix, tmp);
        }
        catch (Exception e) {
            logger.error("Error creating temp file under : " + this.tmpfolder + " : " + e.getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
        return tempFile;
    }

    public byte[] readFile(String fileName) throws ICCException, IOException {
        byte[] result;
        if (fileName == null || "".equals(fileName)) {
            throw new IOException("Please provide a valid filePath: null is not valid...");
        }
        File f = new File(this.tmpfolder, new File(fileName).getName());
        String tempFilePath = f.getAbsolutePath();
        logger.debug("Uploaded file: " + tempFilePath);
        if (!f.exists() || !f.canRead()) {
            String errMsg = "The uploaded file '" + tempFilePath + "' either does not exist or cannot be read...";
            throw new IOException(errMsg);
        }
        try {
            FileInputStream in = new FileInputStream(f);
            BufferedInputStream bin = new BufferedInputStream(in);
            result = IOUtils.toByteArray((InputStream)bin);
            bin.close();
            in.close();
            if (result.length == 0) {
                throw new IOException("The uploaded file '" + tempFilePath + "' was empty...");
            }
        }
        catch (Exception e) {
            throw new ICCException("ALC-ACM-002-013", 1, e);
        }
        return result;
    }

    public String getTmpfolder() {
        return this.tmpfolder;
    }

    public void setTmpfolder(String folder) {
        this.tmpfolder = folder;
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath) throws ICCException, IOException {
        return TempFileManager.retrieveContentFromJCRRepository(absPath, false);
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath, boolean deleteFile) throws ICCException, IOException {
        return TempFileManager.retrieveContentFromJCRRepository(absPath, deleteFile, null);
    }

    public static byte[] retrieveContentFromJCRRepository(String absPath, boolean deleteFile, Session session) throws ICCException, IOException {
        if (absPath == null || absPath.trim().equals("")) {
            return null;
        }
        if (!TempFileManager.nodeExists(absPath)) {
            return null;
        }
        if (TempFileManager.isFolder(absPath)) {
            return null;
        }
        byte[] result = null;
        try {
            if (session == null) {
                session = TempFileManager.getSession();
            }
            Node ntFileNode = session.getNode(absPath);
            Node ntResourceNode = ntFileNode.getNode("jcr:content");
            InputStream is = ntResourceNode.getProperty("jcr:data").getBinary().getStream();
            BufferedInputStream bin = new BufferedInputStream(is);
            result = IOUtils.toByteArray((InputStream)bin);
            bin.close();
            is.close();
            if (deleteFile) {
                session.removeItem(absPath);
            }
        }
        catch (Exception ex) {
            logger.error("Error reading file from JCR Repository : " + ex.getCause().getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, ex);
        }
        return result;
    }

    private static Session getSession() throws RepositoryException {
        ResourceResolver resolver = ResourceResolverHolder.getResourceResolver();
        return (Session)resolver.adaptTo(Session.class);
    }

    public static boolean nodeExists(String absPath) {
        try {
            return TempFileManager.getSession().nodeExists(absPath);
        }
        catch (RepositoryException ex) {
            logger.error("Error reading file from JCR Repository : " + ex.getCause().getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, ex);
        }
    }

    public static String getResolvedResourcePath(ResourceResolver resourceResolver, String relativePath) {
        Resource resource;
        if (resourceResolver == null) {
            resourceResolver = ResourceResolverHolder.getResourceResolver();
        }
        if ((resource = resourceResolver.getResource(relativePath)) != null) {
            return resource.getPath();
        }
        return null;
    }

    private static boolean isFolder(String absPath) {
        try {
            Node node = TempFileManager.getSession().getNode(absPath);
            String defaultPrimaryTypeName = node.getPrimaryNodeType().getName();
            return "nt:folder".equals(defaultPrimaryTypeName);
        }
        catch (RepositoryException ex) {
            logger.error("Error reading file from JCR Repository :" + ex.getCause().getMessage());
            throw new ICCException("ALC-ACM-002-013", 1, ex);
        }
    }

    public void run() {
        this.cleanTemp();
    }

    protected void bindFileService(FileService fileService) {
        this.fileService = fileService;
    }

    protected void unbindFileService(FileService fileService) {
        if (this.fileService == fileService) {
            this.fileService = null;
        }
    }

    protected void bindAcmConfigurationService(ACMConfigurationService aCMConfigurationService) {
        this.acmConfigurationService = aCMConfigurationService;
    }

    protected void unbindAcmConfigurationService(ACMConfigurationService aCMConfigurationService) {
        if (this.acmConfigurationService == aCMConfigurationService) {
            this.acmConfigurationService = null;
        }
    }
}

