/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.obj;

import com.adobe.icc.dbforms.exceptions.ICCException;
import com.adobe.icc.dbforms.obj.SortField;
import com.adobe.icc.dbforms.obj.Statement;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
implements Serializable {
    private static final long serialVersionUID = 3645992304769598197L;
    private String objectType;
    private String queryString;
    private Map<String, Object> paramsMap;
    private SortField[] sortFields;
    private List<Statement> statements;

    public String getQueryString() throws ICCException {
        if (this.queryString != null && !this.queryString.trim().equals("")) {
            return this.queryString;
        }
        StringBuffer queryBuffer = new StringBuffer();
        StringBuffer joinQueryBuffer = new StringBuffer();
        boolean isFirstStatement = false;
        if (this.statements != null) {
            for (Statement stmt : this.statements) {
                if (stmt == null) continue;
                String query = this.constructQuery(stmt);
                if (query != null && !query.trim().equals("")) {
                    if (!isFirstStatement) {
                        isFirstStatement = true;
                    } else {
                        queryBuffer.append(" AND ");
                    }
                    queryBuffer.append("(").append(query).append(")");
                }
                String joinQuery = this.constructJoinQuery(stmt);
                joinQueryBuffer.append(joinQuery);
            }
        }
        this.queryString = "SELECT x FROM " + this.objectType + " x";
        if (joinQueryBuffer.length() > 0) {
            this.queryString = this.queryString + joinQueryBuffer.toString();
        }
        if (queryBuffer.length() > 0) {
            this.queryString = this.queryString + " WHERE " + queryBuffer.toString();
        }
        return this.queryString;
    }

    private String constructJoinQuery(Statement stmt) {
        String innerStmtJoinQuery;
        String joinQuery = "";
        String attributeName = stmt.getAttributeName();
        String[] attrNames = attributeName.split("\\.");
        int len = attrNames.length;
        if (len > 1) {
            joinQuery = " LEFT JOIN x." + attrNames[0] + " " + attrNames[0];
        }
        if (stmt.getInnerStatement() != null && !joinQuery.equals(innerStmtJoinQuery = this.constructJoinQuery(stmt.getInnerStatement()))) {
            joinQuery = joinQuery + innerStmtJoinQuery;
        }
        return joinQuery;
    }

    private String constructQuery(Statement stmt) throws ICCException {
        String stmtQuery = this.constructQuery(stmt.getAttributeName(), stmt.getOperator());
        Statement innerStmt = stmt.getInnerStatement();
        if (stmt.getInnerStatement() == null) {
            return stmtQuery;
        }
        String innerStmtQuery = this.constructQuery(innerStmt.getAttributeName(), innerStmt.getOperator());
        String joinOp = "";
        switch (stmt.getJoinOperator()) {
            case AND: {
                joinOp = "AND";
                break;
            }
            case OR: {
                joinOp = "OR";
                break;
            }
            case AND_NOT: {
                joinOp = "AND NOT";
                break;
            }
            case OR_NOT: {
                joinOp = "OR NOT";
                break;
            }
            default: {
                joinOp = "AND";
            }
        }
        return "( " + stmtQuery + " ) " + joinOp + " ( " + innerStmtQuery + " )";
    }

    private String constructQuery(String attributeName, Statement.Operator operator) throws ICCException {
        String query = null;
        if (attributeName == null || attributeName.length() <= 0) {
            throw new ICCException("Invalid attribute name : " + attributeName);
        }
        query = attributeName + " ";
        String op = null;
        switch (operator) {
            case EQUALS: {
                op = "=";
                break;
            }
            case LESS_THAN: {
                op = "<";
                break;
            }
            case LESS_THAN_EQUALS: {
                op = "<=";
                break;
            }
            case GREATER_THAN: {
                op = ">";
                break;
            }
            case GREATER_THAN_EQUALS: {
                op = ">=";
                break;
            }
            case NOT_EQUALS: {
                op = "!=";
                break;
            }
            case CONTAINS: 
            case STARTS_WITH: 
            case ENDS_WITH: {
                op = "LIKE";
                break;
            }
            default: {
                op = "=";
            }
        }
        query = Statement.Operator.IS_NULL.equals((Object)operator) ? query + "IS NULL" : query + op + " :" + attributeName.replaceAll("\\.", "_");
        return query;
    }

    public Map<String, Object> getQueryParams() {
        if (this.paramsMap == null || this.paramsMap.isEmpty()) {
            this.paramsMap = new HashMap<String, Object>();
            if (this.statements != null) {
                for (Statement stmt : this.statements) {
                    if (stmt == null) continue;
                    this.setParamForStatement(stmt);
                    if (stmt.getInnerStatement() == null) continue;
                    this.setParamForStatement(stmt.getInnerStatement());
                }
            }
        }
        return this.paramsMap;
    }

    private void setParamForStatement(Statement stmt) {
        Object attrValue = stmt.getAttributeValue();
        if (attrValue != null) {
            switch (stmt.getOperator()) {
                case CONTAINS: {
                    attrValue = "%" + attrValue + "%";
                    break;
                }
                case STARTS_WITH: {
                    attrValue = attrValue + "%";
                    break;
                }
                case ENDS_WITH: {
                    attrValue = "%" + attrValue;
                }
            }
            this.paramsMap.put(stmt.getAttributeName().replaceAll("\\.", "_"), attrValue);
        }
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void addStatement(Statement statement) {
        if (this.statements == null) {
            this.statements = new LinkedList<Statement>();
        }
        this.statements.add(statement);
    }

    public SortField[] getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(SortField[] sortFields) {
        this.sortFields = sortFields;
    }
}

