/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import com.adobe.fd.signatures.pki.client.types.common.HashAlgorithm;
import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import com.adobe.fd.signatures.pki.client.types.prefs.CommonPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;
import com.adobe.fd.signatures.pki.client.types.prefs.TSPPreferences;

public class TSPPreferencesImpl
extends CommonPreferencesImpl
implements TSPPreferences {
    private static final long serialVersionUID = -1825117560859208430L;
    private static final String tspServerURLStr = "tspServerURL";
    private static final String sendNonceStr = "sendNonce";
    private static final Boolean sendNonce_Default = new Boolean(true);
    private static final String tspHashAlgo = "hashAlgo";
    private static final HashAlgorithm tspHashAlgo_Default = HashAlgorithm.SHA1;
    private static final String tspSize = "size";
    public static final Integer MIN_TSP_SIZE = new Integer(64);
    public static final Integer MAX_TSP_SIZE = new Integer(10240);
    public static final Integer DEFAULT_TSP_SIZE = new Integer(4096);
    private static final String tspServerUsername = "serverUsername";
    private static final String tspServerPassword = "serverPassword";
    private static final String useExpriedTimestampsStr = "useExpiredTimestamps";
    private static final Boolean useExpriedTimestamps_Default = new Boolean(true);

    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(tspServerURLStr)) {
            return value.trim().length() != 0 ? value : null;
        }
        if (prefName.equalsIgnoreCase(sendNonceStr) || prefName.equalsIgnoreCase(useExpriedTimestampsStr)) {
            return Boolean.valueOf(value);
        }
        if (prefName.equalsIgnoreCase(tspServerUsername) || prefName.equalsIgnoreCase(tspServerPassword)) {
            return value.trim().length() != 0 ? value : null;
        }
        if (prefName.equalsIgnoreCase(tspHashAlgo)) {
            return HashAlgorithm.getValueFromString(value.trim());
        }
        if (prefName.equalsIgnoreCase(tspSize)) {
            return this.checkTSPSize(new Integer(value));
        }
        return super.getPrefValueFromString(prefName, value);
    }

    private Integer checkTSPSize(Integer size) {
        if (size.compareTo(MIN_TSP_SIZE) < 0 || size.compareTo(MAX_TSP_SIZE) > 0) {
            size = DEFAULT_TSP_SIZE;
        }
        return size;
    }

    public TSPPreferencesImpl() {
        super(RevocationCheckStyle.BestEffort);
        this.put(sendNonceStr, (Object)sendNonce_Default);
        this.put(tspHashAlgo, (Object)tspHashAlgo_Default);
        this.put(tspSize, (Object)DEFAULT_TSP_SIZE);
        this.put(useExpriedTimestampsStr, (Object)useExpriedTimestamps_Default);
    }

    public TSPPreferencesImpl(TSPPreferences tspPrefs) {
        this();
        this.put(sendNonceStr, (Object)tspPrefs.getSendNonce());
        this.put(tspHashAlgo, (Object)tspPrefs.getTSPHashAlgorithm());
        this.put(tspSize, (Object)tspPrefs.getSize());
        this.put(useExpriedTimestampsStr, (Object)tspPrefs.isUseExpiredTimestamps());
    }

    public String getTspServerURL() {
        return (String)this.get(tspServerURLStr);
    }

    public void setTspServerURL(String tspServerURL) {
        this.put(tspServerURLStr, (Object)tspServerURL);
    }

    public boolean getSendNonce() {
        return (Boolean)this.get(sendNonceStr);
    }

    public void setSendNonce(boolean sendNonce) {
        this.put(sendNonceStr, (Object)sendNonce);
    }

    public HashAlgorithm getTSPHashAlgorithm() {
        return (HashAlgorithm)((Object)this.get(tspHashAlgo));
    }

    public void setTSPHashAlgorithm(HashAlgorithm hashAlgo) {
        this.put(tspHashAlgo, (Object)hashAlgo);
    }

    public String getUsername() {
        return (String)this.get(tspServerUsername);
    }

    public char[] getPassword() {
        return (char[])this.get(tspServerPassword);
    }

    public void setUsername(String userName) {
        this.put(tspServerUsername, (Object)userName);
    }

    public void setPassword(char[] password) {
        this.put(tspServerPassword, (Object)password);
    }

    public Integer getSize() {
        return (Integer)this.get(tspSize);
    }

    public void setSize(int size) {
        this.put(tspSize, (Object)this.checkTSPSize(size));
    }

    public boolean isUseExpiredTimestamps() {
        return (Boolean)this.get(useExpriedTimestampsStr);
    }

    public void setUseExpiredTimestamps(boolean useExpiredTimestamps) {
        this.put(useExpriedTimestampsStr, (Object)useExpiredTimestamps);
    }

    public PreferencesMap newInstance() {
        return new TSPPreferencesImpl();
    }

    protected PreferencesMap createChild(String myKey) {
        return null;
    }
}

