/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pdf.inputs;

import com.adobe.fd.signatures.pdf.inputs.DSSPreferences;
import com.adobe.fd.signatures.pdf.inputs.JavascriptPreferences;
import com.adobe.fd.signatures.pdf.inputs.UnlockOptions;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.PKIPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;
import com.adobe.internal.pdftoolkit.services.javascript.JSExecuteOptions;

public class DSSPreferencesImpl
extends PreferencesMap
implements DSSPreferences {
    private static final long serialVersionUID = -8550268318654946935L;
    private static final String pkiStr = "pki";
    private static final String javascriptStr = "javascript";
    private static final String verifyClockSkewStr = "maxClockSkew";
    private static final long verifyClockSkew_Default = 3900L;
    private static final String maxRevInfoArchiveSizeStr = "maxRevInfoArchiveSize";
    private static final int maxRevInfoArchiveSize_Default = 10240;
    private static final String useArchivedRevocationInfoStr = "useArchivedRevocationInfo";
    private static final boolean useArchivedRevocationInfo_Default = true;
    private static final String enableDocumentJavascriptsStr = "enableDocumentJavascripts";
    private static final boolean enableDocumentJavascripts_Default = true;
    private static final String enforceRevocationEmbeddingStr = "enforceRevocationEmbedding";
    private static final boolean enforceRevocationEmbedding_Default = false;
    private static final String useVRIStr = "useVRI";
    private static final boolean useVRI_Default = true;
    private static final String supportPreReleaseSignaturesStr = "supportPreReleaseSignatures";
    private static final boolean supportPreReleaseSignatures_Default = false;
    private static final String createFormDOMStr = "createFormDOM";
    private static final boolean createFormDom_Default = true;
    private static final String unlockOptions = "unlockOptions";

    public DSSPreferencesImpl() {
        this.setPKIPreferences(new PKIPreferencesImpl());
        this.setJSPreferences(new JavascriptPreferences());
        this.setVerificationTimeClockSkew(3900L);
        this.setMaxRevInfoArchiveSize(10240);
        this.setUseArchivedRevocationInfo(true);
        this.setEnableDocumentJavascripts(true);
        this.setEnforceRevocationEmbedding(false);
        this.setUseVRI(true);
        this.setSupportPreReleaseSignatures(false);
        this.setCreateFormDOM(true);
    }

    public DSSPreferencesImpl(DSSPreferences prefs) {
    }

    public static DSSPreferencesImpl getInstance() {
        return new DSSPreferencesImpl();
    }

    public DSSPreferencesImpl getInstance(DSSPreferences dssPrefs) {
        if (dssPrefs == null) {
            return DSSPreferencesImpl.getInstance();
        }
        if (dssPrefs instanceof DSSPreferencesImpl) {
            return (DSSPreferencesImpl)dssPrefs;
        }
        return new DSSPreferencesImpl(dssPrefs);
    }

    protected Object getPrefValueFromString(String prefName, String value) {
        if (verifyClockSkewStr.equalsIgnoreCase(prefName)) {
            return new Long(value);
        }
        if (maxRevInfoArchiveSizeStr.equalsIgnoreCase(prefName)) {
            return new Integer(value);
        }
        if (useArchivedRevocationInfoStr.equalsIgnoreCase(prefName) || enableDocumentJavascriptsStr.equalsIgnoreCase(prefName) || enforceRevocationEmbeddingStr.equalsIgnoreCase(prefName) || useVRIStr.equalsIgnoreCase(prefName) || supportPreReleaseSignaturesStr.equalsIgnoreCase(prefName) || createFormDOMStr.equalsIgnoreCase(prefName)) {
            return new Boolean(value);
        }
        return null;
    }

    public PreferencesMap newInstance() {
        return new DSSPreferencesImpl();
    }

    protected PreferencesMap createChild(String myKey) {
        if (myKey.equalsIgnoreCase(pkiStr)) {
            return new PKIPreferencesImpl();
        }
        if (myKey.equalsIgnoreCase(javascriptStr)) {
            return new JavascriptPreferences();
        }
        return null;
    }

    public PKIPreferencesImpl getPKIPreferences() {
        return (PKIPreferencesImpl)this.get(pkiStr);
    }

    public void setPKIPreferences(PKIPreferences prefs) {
        this.put(pkiStr, (Object)prefs);
    }

    public JSExecuteOptions getJSPreferences() {
        JavascriptPreferences jsPrefs = (JavascriptPreferences)this.get(javascriptStr);
        if (jsPrefs == null) {
            return null;
        }
        JSExecuteOptions jsOpts = JSExecuteOptions.newInstance();
        jsOpts.setMemoryThreshhold(jsPrefs.getMemoryThreshhold());
        jsOpts.setScriptTimeOutInterval(jsPrefs.getScriptTimeOutInterval());
        return jsOpts;
    }

    public void setJSPreferences(JavascriptPreferences prefs) {
        this.put(javascriptStr, (Object)prefs);
    }

    public long getVerificationTimeClockSkew() {
        return (Long)this.get(verifyClockSkewStr);
    }

    public void setVerificationTimeClockSkew(long skew) {
        this.put(verifyClockSkewStr, (Object)skew);
    }

    public int getMaxRevInfoArchiveSize() {
        return (Integer)this.get(maxRevInfoArchiveSizeStr);
    }

    public void setMaxRevInfoArchiveSize(int maxRevInfoArchiveSize) {
        this.put(maxRevInfoArchiveSizeStr, (Object)maxRevInfoArchiveSize);
    }

    public boolean getUseArchivedRevocationInfo() {
        return (Boolean)this.get(useArchivedRevocationInfoStr);
    }

    public void setUseArchivedRevocationInfo(boolean useArchivedRevocationInfo) {
        this.put(useArchivedRevocationInfoStr, (Object)useArchivedRevocationInfo);
    }

    public boolean getEnableDocumentJavascripts() {
        return (Boolean)this.get(enableDocumentJavascriptsStr);
    }

    public void setEnableDocumentJavascripts(boolean enableDocumentJavascripts) {
        this.put(enableDocumentJavascriptsStr, (Object)enableDocumentJavascripts);
    }

    public boolean getEnforceRevocationEmbedding() {
        return (Boolean)this.get(enforceRevocationEmbeddingStr);
    }

    public void setEnforceRevocationEmbedding(boolean enforceRevocationEmbedding) {
        this.put(enforceRevocationEmbeddingStr, (Object)enforceRevocationEmbedding);
    }

    public boolean getUseVRI() {
        return (Boolean)this.get(useVRIStr);
    }

    public void setUseVRI(boolean useVRI) {
        this.put(useVRIStr, (Object)useVRI);
    }

    public boolean getSupportPreReleaseSignatures() {
        return (Boolean)this.get(supportPreReleaseSignaturesStr);
    }

    public void setSupportPreReleaseSignatures(boolean supportPreReleaseSignatures) {
        this.put(supportPreReleaseSignaturesStr, (Object)supportPreReleaseSignatures);
    }

    public void setCreateFormDOM(boolean createFormDOM) {
        this.put(createFormDOMStr, (Object)createFormDOM);
    }

    public boolean getCreateFormDom() {
        return (Boolean)this.get(createFormDOMStr);
    }

    public UnlockOptions getUnlockOptions() {
        return (UnlockOptions)this.get(unlockOptions);
    }

    public void setUnlockOptions(UnlockOptions unlockOption) {
        this.put(unlockOptions, (Object)unlockOption);
    }

    public Object getProperty(String key) {
        return this.get(key);
    }

    public void setProperty(String key, Object value) {
        this.put(key, value);
    }
}

