/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.encryption.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Properties;
import org.slf4j.Logger;

public abstract class CommonBaseException
extends Exception {
    private static final long serialVersionUID = -963229471334033806L;
    protected static Logger logger;
    protected String errMsg = "";
    protected StringBuffer stackTrace = new StringBuffer("");

    protected abstract Properties getProps();

    protected abstract String getDefaultErrMsg();

    public CommonBaseException() {
        super("");
        this.setErrMsg("", null);
        this.fillStackTrace(this);
        this.logException();
    }

    public CommonBaseException(String errorMsg) {
        super("");
        this.fillStackTrace(this);
        this.setErrMsg(errorMsg, null);
        this.logException();
    }

    public CommonBaseException(Throwable chainedException) {
        super("", null);
        this.fillStackTrace(this);
        this.fillStackTrace(chainedException);
        this.setErrMsg("", null);
        this.appendErrMsg(chainedException);
        this.logException();
    }

    public CommonBaseException(String errorMsg, Throwable chainedException) {
        super("", null);
        this.setErrMsg(errorMsg, null);
        this.fillStackTrace(this);
        this.fillStackTrace(chainedException);
        this.appendErrMsg(chainedException);
        this.logException();
    }

    public CommonBaseException(String errorMsg, Object[] params) {
        super("");
        this.fillStackTrace(this);
        this.setErrMsg(errorMsg, params);
        this.logException();
    }

    public CommonBaseException(String errorMsg, Object[] params, Throwable chainedException) {
        super("", null);
        this.setErrMsg(errorMsg, params);
        this.fillStackTrace(this);
        this.fillStackTrace(chainedException);
        this.appendErrMsg(chainedException);
        this.logException();
    }

    public String getMessage() {
        return this.errMsg;
    }

    public void printStackTrace() {
        System.err.print(this.getMessage() + "\n");
        System.err.print(this.stackTrace);
    }

    public void printStackTrace(PrintStream s) {
        s.print(this.getMessage() + "\n");
        s.print(this.stackTrace);
    }

    public void printStackTrace(PrintWriter w) {
        w.print(this.getMessage() + "\n");
        w.print(this.stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initProps(String fileName, Properties properties, Class currentClass) {
        InputStream is = currentClass.getResourceAsStream(fileName);
        try {
            if (is != null) {
                properties.load(is);
            } else {
                logger.warn("File containing Message Strings not initialised.");
            }
        }
        catch (IOException e) {
            logger.warn("File containing Message Strings not initialised.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("File containing Message Strings not initialised.", (Throwable)e);
            }
        }
    }

    private void fillStackTrace(Throwable e) {
        block5: {
            StackTraceElement[] st;
            block3: {
                StackTraceElement[] st2;
                block4: {
                    if ("".equals(this.stackTrace.toString())) break block3;
                    if (!(e instanceof CommonBaseException)) break block4;
                    String msg = ((CommonBaseException)e).getStringStackTrace();
                    if ((msg = msg.replaceAll("\\n", "\\\n ")) == null || "".equals(msg)) break block5;
                    this.stackTrace.append(" Caused By: " + e.getClass().getName() + " \n");
                    this.stackTrace.append(msg);
                    break block5;
                }
                if (e == null || (st2 = e.getStackTrace()) == null) break block5;
                this.stackTrace.append(" Caused By: " + e.getClass().getName() + " \n");
                for (int i = 0; i < st2.length; ++i) {
                    this.stackTrace.append(" " + st2[i].toString() + "\n");
                }
                break block5;
            }
            if (e != null && (st = e.getStackTrace()) != null) {
                for (int i = 0; i < st.length; ++i) {
                    this.stackTrace.append(" " + st[i].toString() + "\n");
                }
            }
        }
    }

    private void setErrMsg(String errorMsgId, Object[] params) {
        Properties currentProps = this.getProps();
        if (currentProps == null) {
            this.errMsg = this.getDefaultErrMsg() + " ";
            this.errMsg = this.errMsg + errorMsgId;
        } else {
            String rawMsg = currentProps.getProperty(errorMsgId);
            String formatedMsg = "";
            if (rawMsg != null) {
                formatedMsg = MessageFormat.format(rawMsg, params);
                this.errMsg = errorMsgId + " " + formatedMsg;
            } else {
                this.errMsg = this.getDefaultErrMsg() + " ";
                this.errMsg = this.errMsg + errorMsgId;
            }
        }
        this.errMsg = this.errMsg + this.getCallerInformation();
    }

    private void appendErrMsg(Throwable e) {
        if (e != null) {
            if (e instanceof CommonBaseException) {
                String em = e.getMessage();
                if (em != null && !"".equals(em)) {
                    em = em.replaceAll("\\n", "\\\n ");
                    this.errMsg = this.errMsg + "\n Caused By: " + em;
                }
            } else {
                Throwable c = e;
                do {
                    String em;
                    if ((em = c.getMessage()) != null && !"".equals(em)) {
                        em = em.replaceAll("\\n", "\\\n ");
                    }
                    this.errMsg = this.errMsg + "\n Caused By: " + em;
                    if (null == c.getStackTrace()[0]) continue;
                    this.errMsg = this.errMsg + "(" + c.getStackTrace()[0].getFileName() + c.getStackTrace()[0].getLineNumber() + ")";
                } while ((c = c.getCause()) != null);
            }
        }
    }

    private String getCallerInformation() {
        StringBuffer buffer = new StringBuffer("");
        StackTraceElement[] stack = this.getStackTrace();
        if (stack.length > 0) {
            buffer.append(" (in the operation : ").append(stack[0].getMethodName()).append(")");
        }
        return buffer.toString();
    }

    private String getStringStackTrace() {
        return this.stackTrace.toString();
    }

    private void logException() {
        if (logger.isWarnEnabled()) {
            logger.warn(this.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n" + this.getStringStackTrace());
        }
    }
}

