/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.SubmitDataCollector;
import com.adobe.aemds.guide.utils.XMLUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XsdSubmitDataCollector
extends SubmitDataCollector {
    public XsdSubmitDataCollector(String mergeJsonString, JSONObject templateJson, String guidePrefillXml) {
        super(mergeJsonString, templateJson, guidePrefillXml, null);
    }

    protected Node getInitialRepeatNode() throws Exception {
        if (this.startsWithAfData) {
            return (Node)this.xPath.evaluate("afBoundData/data", this.dataDoc.getDocumentElement(), XPathConstants.NODE);
        }
        return this.dataDoc.getDocumentElement();
    }

    protected void updatePrefillXML() throws Exception {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        Element afBoundData = null;
        if (this.startsWithAfData) {
            afBoundData = this.createBoundTag(this.dataDoc.getDocumentElement());
            this.dataDoc.getDocumentElement().appendChild(afBoundData);
        } else {
            this.generateFullXml(db);
        }
    }

    protected void addBoundPartToDataXml() {
        try {
            Node afBoundData = (Node)this.xPath.evaluate("afBoundData/data", this.dataDoc.getDocumentElement(), XPathConstants.NODE);
            Node dataInsideAfBounddata = (Node)this.xPath.evaluate("*", afBoundData, XPathConstants.NODE);
            if (dataInsideAfBounddata != null) {
                afBoundData.removeChild(dataInsideAfBounddata);
            }
        }
        catch (Exception e) {
            this.logger.error("Error in adding bound part to xml" + e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    protected Node getInitialRepeatUnboundNode() throws Exception {
        if (this.startsWithAfData) {
            return (Node)this.xPath.evaluate("afUnboundData/data", this.dataDoc.getDocumentElement(), XPathConstants.NODE);
        }
        return null;
    }

    protected String getRelativeRepeatPath(JSONObject templateJsonObject) throws JSONException {
        String bindRef = "";
        if (templateJsonObject.has("bindRef")) {
            bindRef = XMLUtils.getXSDRootBindRef(templateJsonObject);
            if (this.currentRepeatFullPath.length() > 0 && bindRef.startsWith(this.currentRepeatFullPath)) {
                bindRef = StringUtils.substringAfter((String)bindRef, (String)this.currentRepeatFullPath);
            }
            bindRef = GuideUtils.removePrefix(bindRef, "/");
        }
        return bindRef;
    }

    protected String getFullRepeatPath(JSONObject templateJson) throws JSONException {
        return XMLUtils.getXSDRootBindRef(templateJson);
    }

    protected void updateBoundField(JSONObject jsonObject, JSONObject templateJsonObject) throws JSONException, Exception {
        if (jsonObject.has("_value")) {
            String bindRef = XMLUtils.getXSDRootBindRef(templateJsonObject);
            String relativeBindRef = this.getRelativeRepeatPath(templateJsonObject);
            Node bindNode = null;
            bindNode = StringUtils.equals((String)bindRef, (String)relativeBindRef) ? this.getInitialRepeatNode() : this.currentRepeatNode;
            boolean setDataGroup = false;
            String dataNodePath = "";
            String attributePathPrefix = "";
            if (relativeBindRef.contains("/@")) {
                attributePathPrefix = "/@";
                dataNodePath = relativeBindRef.split(attributePathPrefix)[0];
                setDataGroup = (Node)this.xPath.evaluate(dataNodePath, bindNode, XPathConstants.NODE) == null;
            } else if (relativeBindRef.startsWith("@")) {
                attributePathPrefix = "@";
                setDataGroup = true;
            }
            if (setDataGroup) {
                XMLUtils.addToDocument(this.dataDoc, this.xPath, bindNode, dataNodePath + attributePathPrefix + "xfa:dataNode", "dataGroup");
            }
            XMLUtils.addToDocument(this.dataDoc, this.xPath, bindNode, relativeBindRef, jsonObject.getString("_value"));
        }
    }

    protected boolean needRepeatHandling(JSONObject jsonObject) {
        return true;
    }

    protected void updateCurrentRepeatUnboundNode() {
    }
}

