/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.forms.common.service.FormDataXMLProviderRegistry;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.xml.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtils {
    private static Logger logger = LoggerFactory.getLogger(XMLUtils.class);

    public static String getXSDRootBindRef(JSONObject jsonObject) throws JSONException {
        String bindProp = "";
        if (jsonObject.has("bindRef")) {
            bindProp = jsonObject.getString("bindRef");
            bindProp = GuideUtils.removePrefix(bindProp, "/");
        }
        if (bindProp.indexOf("/") != -1) {
            String rest;
            bindProp = rest = StringUtils.substringAfter((String)bindProp, (String)"/");
        }
        return bindProp;
    }

    public static String getXMLfromXsdDom(Element doc) {
        return XMLUtils.getXMLfromXsdDom(doc, false);
    }

    public static String getXMLfromXsdDom(Element doc, Boolean omitXmlDeclaration) {
        String xsdValue = "";
        try {
            if (doc != null) {
                TransformerFactory transfac = TransformerFactory.newInstance();
                Transformer trans = transfac.newTransformer();
                trans.setOutputProperty("omit-xml-declaration", omitXmlDeclaration != false ? "yes" : "no");
                trans.setOutputProperty("method", "xml");
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                DOMSource source = new DOMSource(doc);
                trans.transform(source, result);
                xsdValue = sw.toString();
            }
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
        return xsdValue;
    }

    public static String getBoundDataXmlPart(Document doc) {
        try {
            if (doc.getDocumentElement().getTagName().equals("afData")) {
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node afBoundData = (Node)xPath.evaluate("afBoundData/*", doc.getDocumentElement(), XPathConstants.NODE);
                return XMLUtils.getXMLfromXsdDom((Element)afBoundData);
            }
            return XMLUtils.getXMLfromXsdDom(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new GuideException("Error in getting bound xml part" + e.getMessage(), e);
        }
    }

    public static String getUnboundDataXmlPart(Document doc) {
        try {
            if (doc.getDocumentElement().getTagName().equals("afData")) {
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node afUnboundData = (Node)xPath.evaluate("afUnboundData/*", doc.getDocumentElement(), XPathConstants.NODE);
                return XMLUtils.getXMLfromXsdDom((Element)afUnboundData);
            }
            return XMLUtils.getXMLfromXsdDom(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new GuideException("Error in getting unbound xml part" + e.getMessage(), e);
        }
    }

    public static JSONObject getMapOfUnboundData(Document doc) {
        JSONObject xmlJSONObj = null;
        try {
            xmlJSONObj = XML.toJSONObject((String)XMLUtils.getUnboundDataXmlPart(doc).trim());
        }
        catch (Exception e) {
            throw new GuideException("Error in getting map of unbound data" + e.getMessage(), e);
        }
        return xmlJSONObj;
    }

    public static String getPrefillXmlWithoutBoundPart(Document doc) {
        try {
            if (doc.getDocumentElement().getTagName().equals("afData")) {
                XPath xPath = XPathFactory.newInstance().newXPath();
                Node afBoundData = (Node)xPath.evaluate("afBoundData", doc.getDocumentElement(), XPathConstants.NODE);
                if (afBoundData != null) {
                    doc.getDocumentElement().removeChild(afBoundData);
                }
                return XMLUtils.getXMLfromXsdDom(doc.getDocumentElement());
            }
            return XMLUtils.getXMLfromXsdDom(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new GuideException("Error in getting bound xml part" + e.getMessage(), e);
        }
    }

    public static String getXMLFromDom(Document doc, String tagName) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node xmlNode = (Node)xPath.evaluate(tagName + "/*", doc.getDocumentElement(), XPathConstants.NODE);
            return XMLUtils.getXMLfromXsdDom((Element)xmlNode);
        }
        catch (Exception e) {
            throw new GuideException("Error in Getting XML of the element <" + tagName + "> From DOM", e);
        }
    }

    public static InputStream getDataRefInputStream(String dataRef, FormDataXMLProviderRegistry formDataXMLProviderRegistry, ResourceResolverHelper resourceResolverHelper) {
        String xml = null;
        try {
            if (dataRef.startsWith("crx://")) {
                Resource fileResource = resourceResolverHelper.getResourceResolver().resolve(dataRef.substring(6));
                javax.jcr.Node jcrNode = (javax.jcr.Node)fileResource.adaptTo(javax.jcr.Node.class);
                javax.jcr.Node jcrContent = jcrNode.getNode("jcr:content");
                InputStream is = jcrContent.getProperty("jcr:data").getBinary().getStream();
                return is;
            }
            if (!(dataRef.startsWith("https://") || dataRef.startsWith("http://") || dataRef.startsWith("file://"))) {
                xml = formDataXMLProviderRegistry.getDataXMLFromService(dataRef);
                logger.info("[AEMForm] XML Recieved from Prefill Service = " + xml);
                if (xml != null && xml.length() > 0) {
                    return new ByteArrayInputStream(xml.getBytes("UTF-8"));
                }
                return null;
            }
            URL url = new URL(dataRef);
            InputStream in = url.openStream();
            return in;
        }
        catch (PathNotFoundException e) {
            logger.error("[AEMForm] unable to locate Data XML in the repository " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("[AEMForm] Exception while reading Data XML in the repository " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("[AEMForm] Unable to read xml using UTF-8 encoding for the " + dataRef + "," + xml + ": " + e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error("[AEMForm] Malformed URL passed for getting the xml " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("[AEMForm] Unable to read from the dataRef URL " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Document exportDocumentFromDataRef(String dataRef, DocumentBuilder builder, FormDataXMLProviderRegistry formDataXMLProviderRegistry, ResourceResolverHelper resourceResolverHelper) throws Exception {
        Document doc = null;
        if (dataRef.startsWith("crx://")) {
            Resource fileResource = resourceResolverHelper.getResourceResolver().resolve(dataRef.substring(6));
            javax.jcr.Node jcrNode = (javax.jcr.Node)fileResource.adaptTo(javax.jcr.Node.class);
            javax.jcr.Node jcrContent = jcrNode.getNode("jcr:content");
            InputStream is = jcrContent.getProperty("jcr:data").getBinary().getStream();
            byte[] fileBytes = IOUtils.toByteArray((InputStream)is);
            is.close();
            doc = builder.parse(new ByteArrayInputStream(fileBytes));
        } else if (!(dataRef.startsWith("https://") || dataRef.startsWith("http://") || dataRef.startsWith("file://"))) {
            InputSource inputSource = new InputSource(new StringReader(formDataXMLProviderRegistry.getDataXMLFromService(dataRef)));
            doc = builder.parse(inputSource);
        }
        if (doc == null) {
            URL url = new URL(dataRef);
            InputStream in = url.openStream();
            doc = builder.parse(in);
            in.close();
        }
        return doc;
    }

    public static Node createNode(Document dataDoc, XPath xPath, Node node, String path) throws XPathExpressionException {
        Document document = dataDoc;
        String[] pathTokens = path.split("/");
        Node currentNode = node;
        int pathTokensSize = pathTokens.length;
        for (int i = 0; i < pathTokensSize; ++i) {
            Element elNode;
            String pathToken = pathTokens[i];
            boolean isLastToken = i == pathTokensSize - 1;
            Node newNode = (Node)xPath.evaluate(pathToken, currentNode, XPathConstants.NODE);
            if (newNode == null) {
                if (pathToken.charAt(0) == '@') {
                    Attr newAttribute = document.createAttribute(pathToken.substring(1));
                    ((Element)currentNode).setAttributeNode(newAttribute);
                    newNode = newAttribute;
                } else if ("text()".equals(pathToken)) {
                    Text textNode = document.createTextNode(null);
                    currentNode.appendChild(textNode);
                    newNode = textNode;
                } else {
                    elNode = document.createElement(pathToken);
                    currentNode.appendChild(elNode);
                    newNode = elNode;
                }
            } else if (isLastToken && pathToken.charAt(0) != '@' && !"text()".equals(pathToken)) {
                elNode = document.createElement(pathToken);
                currentNode.appendChild(elNode);
                newNode = elNode;
            }
            currentNode = newNode;
        }
        return currentNode;
    }

    public static void addToDocument(Document dataDoc, XPath xPath, Node currentNode, String path, String value) {
        try {
            Node toUpdate = (Node)xPath.evaluate(path, currentNode, XPathConstants.NODE);
            if (toUpdate == null) {
                toUpdate = XMLUtils.createNode(dataDoc, xPath, currentNode, path);
            }
            switch (toUpdate.getNodeType()) {
                case 2: {
                    ((Attr)toUpdate).setValue(value);
                    break;
                }
                case 1: {
                    toUpdate.setTextContent(value);
                    break;
                }
                case 3: {
                    toUpdate.setNodeValue(value);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }
}

