/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLCServiceConnector;
import com.adobe.aemds.guide.service.GuideProgressiveStrategyManager;
import com.adobe.aemds.guide.taglibs.GuideELUtils;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/infoprovider"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Adaptive Form Component Info Provider"})})
public class GuidePropertyProvider
extends SlingAllMethodsServlet {
    private static Logger logger = LoggerFactory.getLogger(GuidePropertyProvider.class);
    private static String LAYOUT = "layout";
    private static String ACTIONS = "action";
    private static String FORMATTERS = "formatters";
    private static String SUBMITACTION = "submitAction";
    private static String AUTOSAVEACTION = "autoSaveAction";
    private static String LCPROCESS = "lcProcess";
    private static String MOBILELAYOUT = "mobileLayout";
    private static String PROGRESSIVE_STRATEGIES = "progressiveStrategies";
    private static String PROGRESSIVE_LAYOUT = "progressiveLayout";
    private static String FRAG_FINDER = "fragfinder";
    private static String DOCUMENT_FRAGMENT_LAYOUT = "documentFragmentLayout";
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private GuideLCServiceConnector guideLCServiceConnector;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private GuideProgressiveStrategyManager guideProgressiveStrategyManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        String type = request.getParameter("type");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        ResourceResolver resolver = request.getResourceResolver();
        String[] searchPaths = resolver.getSearchPath();
        String[] searchPathsForFragments = new String[]{"/content/dam/formsanddocuments"};
        String QUERY = "query";
        String START = "start";
        String LIMIT = "limit";
        if (type.equals(FRAG_FINDER)) {
            try {
                writer.object();
                writer.key("fragRefs");
                writer.array();
                String assetType = request.getParameter("assetType");
                String queryForType = "";
                if (assetType == null || assetType.equals("") || "all".equals(assetType)) {
                    queryForType = "";
                } else if ("none".equals(assetType)) {
                    queryForType = "and jcr:content/metadata/@formmodel = 'none'";
                } else if ("xfa".equals(assetType)) {
                    queryForType = "and jcr:content/metadata/@formmodel = 'formtemplates'";
                } else if ("xsd".equals(assetType)) {
                    queryForType = "and jcr:content/metadata/@formmodel = 'xmlschema'";
                }
                for (int i = 0; i < searchPathsForFragments.length; ++i) {
                    String query = "/jcr:root" + searchPathsForFragments[i] + "//element(*, dam:Asset) \n" + "[\n" + "jcr:content/@affragment = '1' \n" + queryForType + "\n" + "]";
                    Iterator fragmentNodes = resolver.findResources(query, "xpath");
                    int alreadySentNodes = -1;
                    int maxLimitToSend = -1;
                    int nodesLeft = -1;
                    String nameOrTitle = request.getParameter("query");
                    String alreadySentNodesString = request.getParameter("start");
                    String maxLimitToSendString = request.getParameter("limit");
                    if (maxLimitToSendString != null && maxLimitToSendString.length() > 0) {
                        maxLimitToSend = Integer.parseInt(maxLimitToSendString);
                    }
                    if (alreadySentNodesString != null && alreadySentNodesString.length() > 0) {
                        alreadySentNodes = Integer.parseInt(alreadySentNodesString);
                        nodesLeft = maxLimitToSend - alreadySentNodes;
                    }
                    if (fragmentNodes == null) continue;
                    if (alreadySentNodes != -1) {
                        for (int node = 0; node < alreadySentNodes; ++node) {
                            if (!fragmentNodes.hasNext()) continue;
                            fragmentNodes.next();
                        }
                    }
                    while (fragmentNodes.hasNext() && (nodesLeft == -1 || nodesLeft-- != 0)) {
                        Resource r = (Resource)fragmentNodes.next();
                        ValueMap properties = ResourceUtil.getValueMap((Resource)r.getChild("jcr:content").getChild("metadata"));
                        boolean titleOrNameMatches = false;
                        if (nameOrTitle != null && nameOrTitle.length() > 0) {
                            boolean bl = titleOrNameMatches = nameOrTitle.equals((String)properties.get((Object)"name")) || nameOrTitle.equals(properties.get((Object)"title"));
                        }
                        if (nameOrTitle != null && !nameOrTitle.equals("") && !titleOrNameMatches) continue;
                        writer.object();
                        String name = (String)properties.get("title", (Object)"");
                        if (name.length() == 0) {
                            name = r.getName();
                        }
                        String resourcePath = r.getPath();
                        String imageRef = resourcePath + "/jcr:content" + "/renditions/cq5dam.thumbnail.48.48.png";
                        String fragRef = resourcePath;
                        fragRef = StringUtils.substringBefore((String)fragRef, (String)"/jcr:content");
                        writer.key("name").value((Object)name);
                        writer.key("jcr:primaryType").value((Object)"nt:unstructured");
                        writer.key("sling:resourceType").value((Object)"fd/af/components/panel");
                        writer.key("image").value((Object)imageRef);
                        writer.key("path").value((Object)fragRef);
                        writer.endObject();
                    }
                }
                writer.endArray();
                writer.endObject();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new GuideException(e);
            }
        }
        if (type.equalsIgnoreCase(LAYOUT)) {
            String layoutType = "";
            String isAfField = "";
            if (request.getParameter("layoutType") != null && request.getParameter("layoutType").length() > 0) {
                layoutType = request.getParameter("layoutType");
                isAfField = request.getParameter("isAfField");
            }
            if (layoutType.length() > 0) {
                try {
                    writer.array();
                    for (int i = 0; i < searchPaths.length; ++i) {
                        String query = "SELECT * FROM nt:base WHERE guideComponentType='" + layoutType + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                        Iterator layouts = resolver.findResources(query, "sql");
                        I18n i18n = new I18n(request.getResourceBundle(request.getLocale()));
                        if (layouts == null) continue;
                        while (layouts.hasNext()) {
                            Resource r = (Resource)layouts.next();
                            String desc = NodeStructureUtils.getLayoutDescription(r);
                            String path = r.getPath();
                            writer.object();
                            if ("fd/af/layouts/panel".equals(layoutType)) {
                                writer.key("guideNavigatorTab").value((Object)NodeStructureUtils.getGuideNavigatorTabProperty(r));
                            }
                            desc = "true".equals(isAfField) && path != null && path.indexOf("defaultFieldLayout") > 0 ? i18n.get("Inherit From Adaptive Form Configuration") : desc;
                            writer.key("text").value((Object)(desc == null ? path : desc));
                            String qtip = NodeStructureUtils.getLayoutQtip(r);
                            if ("fd/af/layouts/field".equals(layoutType)) {
                                path = path + "/" + StringUtils.substringAfterLast((String)path, (String)"/") + ".jsp";
                            } else if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                                path = path.substring(6);
                            }
                            writer.key("value").value((Object)path);
                            if ("fd/af/layouts/field".equals(layoutType)) {
                                XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
                                qtip = GuideELUtils.encodeForHtml((String)qtip, (XSSAPI)xssapi);
                            }
                            writer.key("qtip").value((Object)qtip);
                            writer.endObject();
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            } else {
                logger.warn("Request did not have layout type mentioned.So, not returning any layout types");
            }
        } else {
            if (type.equalsIgnoreCase(ACTIONS)) {
                HashMap<String, Resource> resourceMappings = new HashMap<String, Resource>();
                try {
                    writer.array();
                    for (int i = 0; i < searchPaths.length; ++i) {
                        Iterator layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/components/action' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                        if (layouts == null) continue;
                        resourceMappings.clear();
                        while (layouts.hasNext()) {
                            Resource r = (Resource)layouts.next();
                            String path = r.getPath();
                            if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                                path = path.substring(6);
                            }
                            if (resourceMappings.containsKey(path) && !r.getPath().startsWith("/apps/")) continue;
                            resourceMappings.put(path, r);
                        }
                        for (Map.Entry entry : resourceMappings.entrySet()) {
                            Resource resource = (Resource)entry.getValue();
                            writer.object();
                            String desc = NodeStructureUtils.getLayoutDescription(resource);
                            writer.key("text").value((Object)(desc == null ? (String)entry.getKey() : desc));
                            writer.key("value").value(entry.getKey());
                            writer.key("name").value((Object)resource.getName());
                            if (resource.getResourceSuperType() != null) {
                                writer.key("sling:resourceSuperType").value((Object)resource.getResourceSuperType());
                            }
                            writer.key("templatePath").value((Object)this.getComponentTemplatePath(resource));
                            writer.endObject();
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            if (type.equalsIgnoreCase(PROGRESSIVE_STRATEGIES)) {
                try {
                    writer.array();
                    for (String searchPath : searchPaths) {
                        Iterator services = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = '/libs/fd/af/components/progressiveDataCapture' AND jcr:path LIKE '" + searchPath + "%'", "sql");
                        if (services == null) continue;
                        while (services.hasNext()) {
                            Resource r = (Resource)services.next();
                            String value = r.getPath();
                            ValueMap properties = ResourceUtil.getValueMap((Resource)r);
                            String displayName = NodeStructureUtils.getLayoutDescription(r);
                            String strategyName = (String)properties.get("strategyName", (Object)"");
                            writer.object();
                            writer.key("text").value((Object)displayName);
                            writer.key("qtip").value((Object)displayName);
                            writer.key("value").value((Object)value);
                            writer.key("strategyName").value((Object)strategyName);
                            writer.key("type").value((Object)"service");
                            writer.endObject();
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            if (type.equalsIgnoreCase(PROGRESSIVE_LAYOUT)) {
                try {
                    writer.array();
                    for (int i = 0; i < searchPaths.length; ++i) {
                        Iterator layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/layouts/progressive' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                        if (layouts == null) continue;
                        while (layouts.hasNext()) {
                            Resource r = (Resource)layouts.next();
                            String desc = NodeStructureUtils.getLayoutDescription(r);
                            writer.object();
                            writer.key("text").value((Object)(desc == null ? r.getPath() : desc));
                            String qtip = NodeStructureUtils.getLayoutQtip(r);
                            writer.key("qtip").value((Object)qtip);
                            String path = r.getPath();
                            writer.key("value").value((Object)(path + "/layout.html"));
                            writer.endObject();
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            if (type.equalsIgnoreCase(FORMATTERS)) {
                try {
                    String guideNodeClass = request.getParameter("guideNodeClass");
                    Object res = null;
                    writer.array();
                    writer.object();
                    writer.key("text").value((Object)"none");
                    writer.key("value").value(null);
                    writer.endObject();
                    if (guideNodeClass != null && !guideNodeClass.isEmpty()) {
                        for (String guideClass : GuideConstants.GUIDE_FIELDS_CLASS_NAMES) {
                            if (!guideNodeClass.equalsIgnoreCase(guideClass)) continue;
                            for (int i = 0; i < searchPaths.length; ++i) {
                                String query = "SELECT * FROM nt:base WHERE guideComponentType= 'fd/af/components/formatter/" + guideNodeClass + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                                Iterator formats = resolver.findResources(query, "sql");
                                while (formats.hasNext()) {
                                    Resource format = (Resource)formats.next();
                                    if (format == null) continue;
                                    ValueMap properties = ResourceUtil.getValueMap((Resource)format);
                                    for (Map.Entry pairs : properties.entrySet()) {
                                        String key = (String)pairs.getKey();
                                        if (!key.startsWith("pattern")) continue;
                                        writer.object();
                                        String value = (String)pairs.getValue();
                                        String[] arr = value.split("=", 2);
                                        writer.key("text").value((Object)arr[0]);
                                        writer.key("value").value((Object)arr[1]);
                                        writer.endObject();
                                    }
                                }
                            }
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            if (type.equalsIgnoreCase(SUBMITACTION) || type.equalsIgnoreCase(AUTOSAVEACTION)) {
                String guideComponentType = type.equalsIgnoreCase(SUBMITACTION) ? "fd/af/components/guidesubmittype" : "fd/af/components/guideautosavetype";
                try {
                    writer.array();
                    for (int i = 0; i < searchPaths.length; ++i) {
                        Iterator actions = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = '" + guideComponentType + "' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                        String requestedDataModel = request.getParameter("guideDataModel");
                        if (actions == null) continue;
                        while (actions.hasNext()) {
                            Resource r = (Resource)actions.next();
                            String value = r.getPath();
                            ValueMap properties = ResourceUtil.getValueMap((Resource)r);
                            String text = (String)properties.get("jcr:description", (Object)"");
                            String qtip = (String)properties.get("qtip", (Object)"");
                            Boolean addOption = true;
                            if (requestedDataModel != null) {
                                String dataModel = (String)properties.get("guideDataModel", (Object)"");
                                addOption = dataModel.toLowerCase().contains(requestedDataModel.toLowerCase()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                            }
                            if (!addOption.booleanValue()) continue;
                            writer.object();
                            writer.key("text").value((Object)text);
                            writer.key("value").value((Object)value);
                            writer.key("qtip").value((Object)qtip);
                            writer.endObject();
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            if (type.equalsIgnoreCase(LCPROCESS)) {
                try {
                    writer.array();
                    List<String> services = this.guideLCServiceConnector.getServices();
                    for (String s : services) {
                        writer.object();
                        writer.key("text").value((Object)s);
                        writer.key("value").value((Object)s);
                        writer.endObject();
                    }
                    writer.endArray();
                }
                catch (Exception e) {
                    throw new GuideException(e);
                }
            }
            if (type.equalsIgnoreCase(MOBILELAYOUT)) {
                try {
                    writer.array();
                    for (int i = 0; i < searchPaths.length; ++i) {
                        Iterator layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/layouts/mobile' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                        if (layouts == null) continue;
                        while (layouts.hasNext()) {
                            Resource r = (Resource)layouts.next();
                            String desc = NodeStructureUtils.getLayoutDescription(r);
                            writer.object();
                            writer.key("text").value((Object)(desc == null ? r.getPath() : desc));
                            String qtip = NodeStructureUtils.getLayoutQtip(r);
                            writer.key("qtip").value((Object)qtip);
                            String path = r.getPath();
                            if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                                path = path.substring(6);
                            }
                            writer.key("value").value((Object)path);
                            writer.endObject();
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            if (type.equalsIgnoreCase(DOCUMENT_FRAGMENT_LAYOUT)) {
                try {
                    writer.array();
                    for (int i = 0; i < searchPaths.length; ++i) {
                        Iterator layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/adaddon/documentFragmentLayout' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                        if (layouts == null) continue;
                        while (layouts.hasNext()) {
                            Resource r = (Resource)layouts.next();
                            ValueMap properties = ResourceUtil.getValueMap((Resource)r);
                            String desc = NodeStructureUtils.getLayoutDescription(r);
                            writer.array();
                            writer.value(properties.get("layout", (Object)""));
                            writer.value((Object)(desc == null ? r.getPath() : desc));
                            writer.endArray();
                        }
                    }
                    writer.endArray();
                }
                catch (JSONException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
        }
    }

    private String getComponentTemplatePath(Resource componentResource) {
        try {
            Node componentNode = (Node)componentResource.adaptTo(Node.class);
            ValueMap componentProperties = (ValueMap)componentResource.adaptTo(ValueMap.class);
            String templatePath = (String)componentProperties.get((Object)"cq:templatePath");
            if (templatePath == null && componentNode.hasNode("cq:template")) {
                templatePath = componentNode.getNode("cq:template").getPath();
            }
            return templatePath;
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
    }

    protected void bindGuideLCServiceConnector(GuideLCServiceConnector guideLCServiceConnector) {
        this.guideLCServiceConnector = guideLCServiceConnector;
    }

    protected void unbindGuideLCServiceConnector(GuideLCServiceConnector guideLCServiceConnector) {
        if (this.guideLCServiceConnector == guideLCServiceConnector) {
            this.guideLCServiceConnector = null;
        }
    }

    protected void bindGuideProgressiveStrategyManager(GuideProgressiveStrategyManager guideProgressiveStrategyManager) {
        this.guideProgressiveStrategyManager = guideProgressiveStrategyManager;
    }

    protected void unbindGuideProgressiveStrategyManager(GuideProgressiveStrategyManager guideProgressiveStrategyManager) {
        if (this.guideProgressiveStrategyManager == guideProgressiveStrategyManager) {
            this.guideProgressiveStrategyManager = null;
        }
    }
}

