/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.servlet.GuideEmail;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.mailer.MailService;
import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.commons.mail.Email;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Guide Mail Service"}), @Property(name="sling.servlet.selectors", value={"af.mail"})})
public class GuideMailServlet
extends SlingAllMethodsServlet
implements OptingServlet {
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected MailService mailService;
    private Logger logger = LoggerFactory.getLogger(GuideMailServlet.class);
    protected static final String EXTENSION = "jsp";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block5: {
            if (this.mailService == null) {
                this.logger.error("Could not find email service");
                throw new GuideException("Could not find email service");
            }
            GuideEmail guideEmail = new GuideEmail(request);
            try {
                String guideValues = request.getParameter("_guideValuesMap");
                JSONObject guideValueMap = new JSONObject(guideValues);
                StrSubstitutor substitutor = GuideUtils.getStringSubstitutor(guideValueMap);
                Email email = guideEmail.createEmail(substitutor);
                if (email != null) {
                    List toList = email.getToAddresses();
                    if (!toList.isEmpty()) {
                        this.mailService.send((Object)email);
                    }
                    break block5;
                }
                throw new GuideException("Email Headers (from and to addresses) not specified. Cannot send email");
            }
            catch (Exception e) {
                this.logger.error("Could not create email" + e.getMessage(), (Throwable)e);
                throw new GuideException(e);
            }
        }
        response.sendRedirect(request.getContextPath() + request.getParameter(":redirect"));
    }

    public boolean accepts(SlingHttpServletRequest request) {
        return EXTENSION.equals(request.getRequestPathInfo().getExtension());
    }

    protected void bindMailService(MailService mailService) {
        this.mailService = mailService;
    }

    protected void unbindMailService(MailService mailService) {
        if (this.mailService == mailService) {
            this.mailService = null;
        }
    }
}

