/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.wcm.api.WCMMode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidePanel
extends GuideItemsContainer
implements Serializable {
    public int getMinOccur() {
        return (Integer)this.resourceProps.get("minOccur", (Object)1);
    }

    public int getMaxOccur() {
        return (Integer)this.resourceProps.get("maxOccur", (Object)1);
    }

    public int getInitialOccur() {
        return (Integer)this.resourceProps.get("initialOccur", (Object)1);
    }

    public String getFragRef() {
        String fragRefAssetPath = (String)this.resourceProps.get("fragRef", (Object)"");
        String fragRefContainerPath = "";
        String fragRefRootPanelPath = "";
        if (fragRefAssetPath.length() > 0) {
            fragRefContainerPath = GuideUtils.convertFMAssetPathToContainerPath(fragRefAssetPath);
            Resource fragRefRootPanel = GuideUtils.getRootPanel(this.resource.getResourceResolver().getResource(fragRefContainerPath));
            if (fragRefRootPanel != null) {
                fragRefRootPanelPath = fragRefRootPanel.getPath();
            }
        }
        return fragRefRootPanelPath;
    }

    public String getLayoutFromFragRootPanel() {
        Resource layout;
        ResourceResolver resourceResolver;
        Resource fragRefRootPanel;
        String fragRef = this.getFragRef();
        if (fragRef.length() > 0 && (fragRefRootPanel = (resourceResolver = this.resource.getResourceResolver()).getResource(fragRef)) != null && (layout = fragRefRootPanel.getChild("layout")) != null) {
            return (String)((ValueMap)layout.adaptTo(ValueMap.class)).get((Object)"sling:resourceType");
        }
        return null;
    }

    public String getAfFragmentMarker() {
        String afFragmentClass = "";
        SlingHttpServletRequest request = this.slingRequest;
        String fragRefAssetPath = (String)this.resourceProps.get("fragRef", (Object)"");
        if (fragRefAssetPath.length() > 0 && WCMMode.EDIT.equals((Object)WCMMode.fromRequest((ServletRequest)request))) {
            afFragmentClass = "afFragmentMarker";
        }
        return afFragmentClass;
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        Boolean nonNavigable = Boolean.FALSE;
        try {
            nonNavigable = Boolean.valueOf((String)this.getLayoutProperty("nonNavigable"));
        }
        catch (PersistenceException e) {
            this.logger.error("AF: Unable to fetch nonNavigable property" + e.getMessage(), (Throwable)e);
        }
        authoringConfig.put("nonNavigable", nonNavigable);
        return authoringConfig;
    }

    public String getPanelInlineStyles() {
        return this.getInlineStyles("Panel");
    }

    public String getPanelDescriptionInlineStyles() {
        return this.getInlineStyles("PanelDescription");
    }

    @Override
    public boolean getIsRepeatable() {
        return this.getMinOccur() != 1 || this.getMaxOccur() != 1;
    }

    public boolean isHasToolbar() {
        return this.resource.getChild("toolbar") != null;
    }

    public String getLongDescription() {
        return this.externalize((String)this.resourceProps.get("longDescription", (Object)""));
    }

    public GuideItemsContainer getToolbar() {
        Resource toolbarResource = this.resource.getChild("toolbar");
        if (toolbarResource != null) {
            GuideItemsContainer guideItemsContainer = new GuideItemsContainer();
            guideItemsContainer.setResource(toolbarResource);
            guideItemsContainer.setSlingRequest(this.slingRequest);
            return guideItemsContainer;
        }
        return null;
    }

    public void updateCompletionAndSummary(Resource layoutNode) throws PersistenceException {
        ModifiableValueMap layoutproperties = (ModifiableValueMap)layoutNode.adaptTo(ModifiableValueMap.class);
        String layoutCmpPath = (String)layoutproperties.get((Object)"sling:resourceType");
        if (layoutCmpPath != null) {
            ResourceResolver resolver = this.resource.getResourceResolver();
            Resource panel = layoutNode.getParent();
            if (panel != null) {
                Resource getChildrenResource = panel.getChild("items");
                if (getChildrenResource != null) {
                    Iterator it = getChildrenResource.listChildren();
                    while (it.hasNext()) {
                        Resource child = (Resource)it.next();
                        ModifiableValueMap childMap = (ModifiableValueMap)child.adaptTo(ModifiableValueMap.class);
                        String guideNodeClass = (String)childMap.get("guideNodeClass", (Object)"");
                        if (!guideNodeClass.equals("rootPanelNode") && !guideNodeClass.equals("guidePanel")) continue;
                        String oldValue = (String)childMap.get("summaryExpVisible", (Object)"");
                        if (layoutCmpPath.equals("fd/af/layouts/panel/accordion")) {
                            if (oldValue.length() != 0 && oldValue.equals("yes")) continue;
                            childMap.put((Object)"summaryExpVisible", (Object)"yes");
                            continue;
                        }
                        if (oldValue.length() <= 0) continue;
                        childMap.remove((Object)"summaryExpVisible");
                    }
                }
                String wizardTabLayout = (String)layoutproperties.get((Object)"guideNavigatorTab");
                ModifiableValueMap panelValueMap = (ModifiableValueMap)panel.adaptTo(ModifiableValueMap.class);
                boolean compOldValue = (Boolean)panelValueMap.get("completionExpReq", (Object)false);
                if ("wizard-tab".equals(wizardTabLayout)) {
                    if (!compOldValue) {
                        panelValueMap.put((Object)"completionExpReq", (Object)true);
                    }
                } else if (compOldValue) {
                    panelValueMap.put((Object)"completionExpReq", (Object)false);
                }
                resolver.commit();
            }
        }
    }

    private void setLayoutProperties(Resource layoutNode) throws PersistenceException {
        ResourceResolver resolver;
        Resource layoutCmp;
        ModifiableValueMap layoutproperties;
        String layoutCmpPath;
        if (layoutNode != null && (layoutCmpPath = (String)(layoutproperties = (ModifiableValueMap)layoutNode.adaptTo(ModifiableValueMap.class)).get((Object)"sling:resourceType")) != null && (layoutCmp = (resolver = this.resource.getResourceResolver()).getResource(layoutCmpPath)) != null) {
            Boolean currentEnableLayoutOptimization;
            Boolean enableLayoutOptimization;
            String currentIsNonNavigable;
            String isNonNavigable;
            String currentVal;
            ValueMap layoutCmpProps = ResourceUtil.getValueMap((Resource)layoutCmp);
            String tabType = (String)layoutCmpProps.get("guideNavigatorTab", (Object)"tab");
            if (!StringUtils.equals((String)tabType, (String)(currentVal = (String)layoutproperties.get("guideNavigatorTab", (Object)"tab")))) {
                layoutproperties.put((Object)"guideNavigatorTab", (Object)tabType);
            }
            if (!StringUtils.equals((String)(isNonNavigable = (String)layoutCmpProps.get("nonNavigable", (Object)"false")), (String)(currentIsNonNavigable = (String)layoutproperties.get("nonNavigable", (Object)"false")))) {
                layoutproperties.put((Object)"nonNavigable", (Object)isNonNavigable);
            }
            if ((enableLayoutOptimization = (Boolean)layoutCmpProps.get("enableLayoutOptimization", (Object)false)) != (currentEnableLayoutOptimization = (Boolean)layoutproperties.get("enableLayoutOptimization", (Object)false))) {
                layoutproperties.put((Object)"enableLayoutOptimization", (Object)enableLayoutOptimization);
            }
            resolver.commit();
        }
    }

    @Override
    public void setSlingRequest(SlingHttpServletRequest slingRequest) {
        super.setSlingRequest(slingRequest);
        Resource layout = this.resource.getChild("layout");
        if (this.getIsEditMode().booleanValue() && layout != null) {
            try {
                this.setLayoutProperties(layout);
                this.updateCompletionAndSummary(layout);
            }
            catch (PersistenceException e) {
                this.logger.error("AF: Unable to set layout Properties" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

