/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.exm.expeval;

import com.adobe.exm.exception.EXPException;
import com.adobe.exm.exception.LogLevels;
import com.adobe.exm.exception.MessageLogger;
import com.adobe.exm.expeval.DefaultVariableResolver;
import com.adobe.exm.expeval.EXPEvaluator;
import com.adobe.exm.expeval.EXPVariableResolver;
import com.adobe.exm.expeval.VariableValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.BinaryOperatorExpression;
import org.apache.commons.el.ComplexValue;
import org.apache.commons.el.ConditionalExpression;
import org.apache.commons.el.Expression;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.commons.el.ExpressionString;
import org.apache.commons.el.FunctionInvocation;
import org.apache.commons.el.NamedValue;
import org.apache.commons.el.UnaryOperatorExpression;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, immediate=true, label="lc.exm.expEvaluator")
@Service(value={EXPEvaluator.class})
@Properties(value={@Property(name="connectors.httpinvoker", boolValue={true}), @Property(name="connectors.httpinvoker.alias", value={"lc.exm.expEvaluator"})})
@Reference(name="functionMapper", referenceInterface=FunctionMapper.class, target="(component.name=com.adobe.exm.expeval.DefaultFunctionMapper)")
public class DefaultEXPEvaluator
implements EXPEvaluator {
    protected FunctionMapper functionMapper;

    protected void bindFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    protected void unbindFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = null;
    }

    @Override
    public HashMap<String, Serializable> evaluateExpressions(HashMap<String, String> expressions, Serializable inputData) throws EXPException {
        EXPVariableResolver variableResolverObj = this.createVariableResolver();
        variableResolverObj.setInputData(inputData);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
        if (expressions == null || expressions.size() == 0) {
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-010");
            throw new EXPException("ALC-EXP-001-010");
        }
        for (Map.Entry<String, String> e : expressions.entrySet()) {
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_DEBUG, "ALC-EXP-001-001", new String[]{e.getValue(), e.getKey()});
            Serializable output = this.evaluateExpressionInternal(e.getValue(), variableResolverObj, (ExpressionEvaluator)evaluator, true);
            if (output != null && output instanceof Serializable) {
                result.put(e.getKey(), output);
                continue;
            }
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-007", new String[]{e.getValue()});
        }
        return result;
    }

    @Override
    public Serializable evaluateExpression(String expression, Serializable inputData) throws EXPException {
        ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
        EXPVariableResolver variableResolverObj = this.createVariableResolver();
        variableResolverObj.setInputData(inputData);
        return this.evaluateExpressionInternal(expression, variableResolverObj, (ExpressionEvaluator)evaluator, false);
    }

    @Override
    public void validateExpression(String expression) throws EXPException {
        if (expression == null || expression.length() == 0) {
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_INFO, "ALC-EXP-001-009");
            throw new EXPException("ALC-EXP-001-009");
        }
        if (!(expression = expression.trim()).startsWith("${") || !expression.endsWith("}")) {
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_INFO, "ALC-EXP-001-008", new String[]{expression, "Does not start with '${' or end with '}'"});
            throw new EXPException("ALC-EXP-001-008", new String[]{expression, "Does not start with '${' or end with '}'"});
        }
        try {
            ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
            evaluator.parseExpression(expression, Object.class, this.functionMapper);
        }
        catch (ELException e) {
            throw new EXPException("ALC-EXP-001-008", new String[]{expression, e.getMessage()}, (Throwable)e);
        }
    }

    private Serializable evaluateExpressionInternal(String expression, VariableResolver variableResolverObj, ExpressionEvaluator evaluator, boolean isExpressionSet) throws EXPException {
        if (expression == null) {
            if (isExpressionSet) {
                return null;
            }
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-009");
            throw new EXPException("ALC-EXP-001-009");
        }
        List<String> variableNameList = null;
        try {
            variableNameList = this.getExpressionVariables(expression);
        }
        catch (EXPException e) {
            if (isExpressionSet) {
                return null;
            }
            MessageLogger.logError(this.getClass(), "Expression Error.", e);
            throw e;
        }
        if (variableNameList.size() > 0) {
            List<Object> variableValueList = this.fetchVariableValues(variableResolverObj, variableNameList);
            boolean collectionVariable = false;
            for (Object variable : variableValueList) {
                if (!(variable instanceof List)) continue;
                collectionVariable = true;
                break;
            }
            if (collectionVariable) {
                if (variableResolverObj instanceof VariableValidator) {
                    List<Serializable> expressionResultList;
                    if (!((VariableValidator)variableResolverObj).validateVariableHierarchy(variableNameList)) {
                        MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-012", new String[]{expression});
                        throw new EXPException("ALC-EXP-001-012", new String[]{expression});
                    }
                    List<List<Serializable>> flattenedVariableList = this.flattenVariableList(variableValueList);
                    try {
                        expressionResultList = this.evaluateExpressionForEachCollectionElement(expression, variableNameList, flattenedVariableList);
                    }
                    catch (EXPException e) {
                        MessageLogger.logError(this.getClass(), "Expression Error.", e);
                        return null;
                    }
                    List<Serializable> expressionResultInHierarchy = this.prepareResultList(expressionResultList, variableValueList);
                    return (Serializable)((Object)expressionResultInHierarchy);
                }
                MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-013", null);
                throw new EXPException("ALC-EXP-001-013");
            }
        }
        MessageLogger.logMessage(this.getClass(), LogLevels.LOG_DEBUG, "ALC-EXP-001-002", new String[]{expression});
        Object output = null;
        try {
            output = evaluator.evaluate(expression, Object.class, variableResolverObj, this.functionMapper);
            if (output instanceof Serializable) {
                return (Serializable)output;
            }
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-007", new String[]{expression});
            throw new EXPException("ALC-EXP-001-007");
        }
        catch (ELException elException) {
            MessageLogger.logError(this.getClass(), "ALC-EXP-001-003", new String[]{expression, elException.getMessage()}, elException);
            if (!isExpressionSet) {
                throw new EXPException("ALC-EXP-001-003", new String[]{expression, elException.getMessage()});
            }
            return null;
        }
    }

    private List<Serializable> prepareResultList(List<Serializable> expressionResultList, List<Object> variableList) throws EXPException {
        Object variableWithMaximumDepthInList = this.findNodeWithMaximumHeight(variableList);
        if (variableWithMaximumDepthInList instanceof List) {
            ArrayList<Serializable> resultList = new ArrayList<Serializable>();
            this.populateResultList(resultList, (List)variableWithMaximumDepthInList, expressionResultList, 0);
            return resultList;
        }
        MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-011");
        throw new EXPException("ALC-EXP-001-011");
    }

    private int populateResultList(List<Serializable> resultList, List<Object> variableList, List<Serializable> expressionResultList, int index) throws EXPException {
        for (Object variables : variableList) {
            if (variables instanceof List) {
                ArrayList<Serializable> childList = new ArrayList<Serializable>();
                resultList.add(childList);
                index = this.populateResultList(childList, (List)variables, expressionResultList, index);
                continue;
            }
            if (expressionResultList.size() > index) {
                resultList.add(expressionResultList.get(index++));
                continue;
            }
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-011");
            throw new EXPException("ALC-EXP-001-011");
        }
        return index;
    }

    private Object findNodeWithMaximumHeight(List<Object> nodeList) {
        Object selectedNode = null;
        int height = -1;
        for (Object node : nodeList) {
            int nodeHeight = 0;
            if (node instanceof List) {
                nodeHeight = this.findNodeHeight((List)node);
            }
            if (nodeHeight <= height) continue;
            height = nodeHeight;
            selectedNode = node;
        }
        return selectedNode;
    }

    private int findNodeHeight(List<Object> nodes) {
        int height = 0;
        for (Object node : nodes) {
            int nodeHeight = 0;
            if (node instanceof List && ((List)node).size() > 0) {
                nodeHeight = this.findNodeHeight((List)node);
            }
            if (nodeHeight <= height) continue;
            height = nodeHeight;
        }
        return height + 1;
    }

    private List<Object> fetchVariableValues(VariableResolver variableResolverObj, List<String> variableNames) throws EXPException {
        ArrayList<Object> variableList = new ArrayList<Object>();
        if (variableNames != null && variableNames.size() > 0) {
            Iterator<String> varNameIter = variableNames.iterator();
            while (varNameIter.hasNext()) {
                String variableName = varNameIter.next();
                Object variableValue = null;
                try {
                    variableValue = variableResolverObj.resolveVariable(variableName);
                }
                catch (ELException e) {
                    MessageLogger.logError(this.getClass(), "Expression Error.", e);
                }
                if (variableValue == null) {
                    varNameIter.remove();
                    continue;
                }
                variableList.add((Serializable)variableValue);
            }
        }
        return variableList;
    }

    private List<Serializable> evaluateExpressionForEachCollectionElement(String expression, List<String> variableNames, List<List<Serializable>> flattenedVariableList) throws EXPException {
        ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
        Object output = null;
        HashMap<String, Serializable> variableMap = new HashMap<String, Serializable>();
        ArrayList<Serializable> expResult = new ArrayList<Serializable>();
        for (List<Serializable> expVariables : flattenedVariableList) {
            boolean allInputsAvailable = true;
            for (int i = 0; i < variableNames.size(); ++i) {
                String variableName = variableNames.get(i);
                Serializable variableValue = expVariables.get(i);
                if (variableValue == null) {
                    allInputsAvailable = false;
                    break;
                }
                variableMap.put(variableName, variableValue);
            }
            if (allInputsAvailable) {
                DefaultVariableResolver vr = new DefaultVariableResolver();
                vr.setInputData(variableMap);
                try {
                    output = evaluator.evaluate(expression, Object.class, (VariableResolver)vr, this.functionMapper);
                    if (!(output instanceof Serializable)) {
                        MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-007", new String[]{expression});
                        throw new EXPException("ALC-EXP-001-007", new String[]{expression});
                    }
                    expResult.add((Serializable)output);
                }
                catch (ELException elException) {
                    MessageLogger.logError(this.getClass(), "ALC-EXP-001-003", new String[]{expression, elException.getMessage()}, elException);
                    throw new EXPException("ALC-EXP-001-003", new String[]{expression, elException.getMessage()});
                }
            } else {
                expResult.add(null);
            }
            variableMap.clear();
        }
        return expResult;
    }

    @Override
    public List<String> getExpressionVariables(String expression) throws EXPException {
        ArrayList<String> expressionTokens = new ArrayList<String>();
        ExpressionEvaluatorImpl evaluator = new ExpressionEvaluatorImpl();
        Object obj = null;
        try {
            obj = evaluator.parseExpressionString(expression);
        }
        catch (ELException e) {
            throw new EXPException("ALC-EXP-001-008", new String[]{expression, e.getMessage()}, (Throwable)e);
        }
        this.populateExpressionVariables(expressionTokens, obj);
        return expressionTokens;
    }

    private void populateExpressionVariables(List<String> expressionTokens, Object obj) {
        block4: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            Object[] objArr;
                            block5: {
                                block3: {
                                    if (!(obj instanceof NamedValue)) break block3;
                                    expressionTokens.add(((NamedValue)obj).getExpressionString());
                                    break block4;
                                }
                                if (!(obj instanceof BinaryOperatorExpression)) break block5;
                                BinaryOperatorExpression binaryOperatorExpression = (BinaryOperatorExpression)obj;
                                this.populateExpressionVariables(expressionTokens, binaryOperatorExpression.getExpression());
                                List expressions = binaryOperatorExpression.getExpressions();
                                for (Expression exp : expressions) {
                                    this.populateExpressionVariables(expressionTokens, exp);
                                }
                                break block4;
                            }
                            if (!(obj instanceof ExpressionString)) break block6;
                            for (Object tokenObj : objArr = ((ExpressionString)obj).getElements()) {
                                this.populateExpressionVariables(expressionTokens, tokenObj);
                            }
                            break block4;
                        }
                        if (!(obj instanceof ConditionalExpression)) break block7;
                        ConditionalExpression condExpression = (ConditionalExpression)obj;
                        this.populateExpressionVariables(expressionTokens, condExpression.getCondition());
                        this.populateExpressionVariables(expressionTokens, condExpression.getTrueBranch());
                        this.populateExpressionVariables(expressionTokens, condExpression.getFalseBranch());
                        break block4;
                    }
                    if (!(obj instanceof ComplexValue)) break block8;
                    expressionTokens.add(((ComplexValue)obj).getExpressionString());
                    break block4;
                }
                if (!(obj instanceof UnaryOperatorExpression)) break block9;
                this.populateExpressionVariables(expressionTokens, ((UnaryOperatorExpression)obj).getExpression());
                break block4;
            }
            if (!(obj instanceof FunctionInvocation)) break block4;
            List argList = ((FunctionInvocation)obj).getArgumentList();
            for (Object arg : argList) {
                this.populateExpressionVariables(expressionTokens, arg);
            }
        }
    }

    private List<List<Serializable>> flattenVariableList(List<Object> variableDataList) throws EXPException {
        ArrayList<List<Serializable>> resultVariableList = new ArrayList<List<Serializable>>();
        boolean nestedListPresent = false;
        int collectionSize = 0;
        for (Object variableData : variableDataList) {
            if (!(variableData instanceof List)) continue;
            nestedListPresent = true;
            collectionSize = ((List)variableData).size();
        }
        if (nestedListPresent) {
            for (int i = 0; i < collectionSize; ++i) {
                ArrayList<Object> nestedVariableDataList = new ArrayList<Object>();
                for (Object variableData : variableDataList) {
                    if (variableData instanceof List) {
                        if (((List)variableData).size() <= i) {
                            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-011");
                            throw new EXPException("ALC-EXP-001-011");
                        }
                        nestedVariableDataList.add(((List)variableData).get(i));
                        continue;
                    }
                    nestedVariableDataList.add(variableData);
                }
                List<List<Serializable>> flattenedVariableDataList = this.flattenVariableList(nestedVariableDataList);
                resultVariableList.addAll(flattenedVariableDataList);
            }
        } else {
            ArrayList<Serializable> flattenedVariableDataList = new ArrayList<Serializable>();
            for (Object variableData : variableDataList) {
                if (variableData == null || variableData instanceof Serializable) {
                    flattenedVariableDataList.add((Serializable)variableData);
                    continue;
                }
                MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-014");
                throw new EXPException("ALC-EXP-001-014");
            }
            resultVariableList.add(flattenedVariableDataList);
        }
        return resultVariableList;
    }

    @Override
    public EXPVariableResolver createVariableResolver() {
        return new DefaultVariableResolver();
    }

    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    public void setFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }
}

