/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.exm.exception;

import com.adobe.exm.exception.LogLevels;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class MessageLogger {
    private static Logger log = Logger.getLogger(MessageLogger.class);
    private static final String BUNDLE_NAME = "com.adobe.exm.exception.exceptions";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.adobe.exm.exception.exceptions");

    private MessageLogger() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            log.debug((Object)"Missing Resource Exception", (Throwable)e);
            return '!' + key + '!';
        }
    }

    public static String getString(String key, String[] args) {
        String str = MessageLogger.getString(key);
        if (args != null) {
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                String temp = args[i];
                if (temp != null) {
                    temp = temp.replaceAll("\\$", "\\\\\\$");
                }
                str = str.replaceAll("\\{" + i + "\\}", temp);
            }
        }
        return str;
    }

    public static void logMessage(Class className, LogLevels severity, String key, String[] args) {
        Logger logger = Logger.getLogger((Class)className);
        MessageLogger.logMessage(logger, MessageLogger.getString(key, args), severity);
    }

    public static void logMessage(Class className, LogLevels severity, String key) {
        Logger logger = Logger.getLogger((Class)className);
        MessageLogger.logMessage(logger, MessageLogger.getString(key), severity);
    }

    public static void logError(Class className, String key, Throwable cause) {
        Logger logger = Logger.getLogger((Class)className);
        logger.error((Object)MessageLogger.getString(key), cause);
    }

    public static void logDebug(Class className, String key, Throwable cause) {
        Logger logger = Logger.getLogger((Class)className);
        logger.debug((Object)MessageLogger.getString(key), cause);
    }

    public static void logError(Class className, String key, String[] args, Throwable cause) {
        Logger logger = Logger.getLogger((Class)className);
        logger.error((Object)MessageLogger.getString(key, args), cause);
    }

    private static void logMessage(Logger logger, String logString, LogLevels severity) {
        switch (severity) {
            case LOG_FATAL: {
                logger.fatal((Object)("[" + logString + "]"));
                break;
            }
            case LOG_ERROR: {
                logger.error((Object)("[" + logString + "]"));
                break;
            }
            case LOG_WARN: {
                logger.warn((Object)("[" + logString + "]"));
                break;
            }
            case LOG_INFO: {
                logger.info((Object)("[" + logString + "]"));
                break;
            }
            default: {
                logger.debug((Object)("[" + logString + "]"));
            }
        }
    }
}

