/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dct.util;

import com.adobe.dct.exception.DCTException;
import com.adobe.dct.exception.LogLevels;
import com.adobe.dct.exception.MessageLogger;
import com.adobe.dct.transfer.DataDictionary;
import com.adobe.dct.transfer.DataDictionaryElement;
import com.adobe.dct.transfer.DataDictionaryElementSubType;
import com.adobe.dct.transfer.DataDictionaryElementType;
import com.adobe.dct.transfer.DataDictionaryType;
import com.adobe.exm.exception.EXPException;
import com.adobe.exm.expeval.EXPEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validations {
    private static Pattern alphaNumericPatterm = Pattern.compile("[a-zA-Z0-9]+");
    private static Pattern alphaNumericUnderscorePatterm = Pattern.compile("[a-zA-Z0-9_]+");
    private static final String BINDING_TYPE = "BindingType";
    private static final String BINDING_TYPE_XML = "XML";
    private static final String BINDING_TYPE_POJO = "POJO";
    private static final String ROOT_ELEMENT_IN_BINDING = "RootElementInBinding";

    public static void validateDataDictionary(DataDictionary dataDictionary, EXPEvaluator ddExpressionService, Set<String> deletedRefNames) throws DCTException {
        if (Validations.isEmptyOrNull(dataDictionary.getName())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-002");
            throw new DCTException("ALC-DCT-002-002");
        }
        if (dataDictionary.getVersion() != null && dataDictionary.getVersion().equals("1.0")) {
            return;
        }
        if (!Validations.isAlphaNumeric(dataDictionary.getName())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-024");
            throw new DCTException("ALC-DCT-002-024");
        }
        if (dataDictionary.getDDElements() == null || dataDictionary.getDDElements().size() == 0) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-035");
            throw new DCTException("ALC-DCT-002-035");
        }
        if (dataDictionary.getDDElements().size() > 1) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-036");
            throw new DCTException("ALC-DCT-002-036");
        }
        DataDictionaryElement topLevelElement = dataDictionary.getDDElements().get(0);
        if (!DataDictionaryElementType.COMPOSITE.equals(topLevelElement.getElementType())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-020");
            throw new DCTException("ALC-DCT-002-020");
        }
        if (dataDictionary.getDictionaryType() != null && dataDictionary.getDictionaryType().name().equalsIgnoreCase(DataDictionaryType.SYSTEM.name())) {
            return;
        }
        if ((dataDictionary.getVersion() == null || Double.parseDouble(dataDictionary.getVersion()) >= 2.0) && Validations.containsNullorEmptyKey(dataDictionary.getExtendedProperties())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-060", new String[]{dataDictionary.getName()});
            throw new DCTException("ALC-DCT-002-060", new String[]{dataDictionary.getName()});
        }
        ArrayList<String> referenceNamesList = new ArrayList<String>();
        HashMap<String, String> dataDictionaryValidationInfo = new HashMap<String, String>();
        Validations.validateDataDictionaryElement(topLevelElement, referenceNamesList, dataDictionary.getVersion(), dataDictionaryValidationInfo, ddExpressionService, deletedRefNames, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void validateDataDictionaryElement(DataDictionaryElement dde, List<String> referenceNamesList, String version, Map<String, String> dataDictionaryValidationInfo, EXPEvaluator ddExpressionService, Set<String> deletedRefNames, boolean isCollectionChild) throws DCTException {
        Iterator<DataDictionaryElement> i$;
        ArrayList<String> childNames;
        String computedExpression;
        block52: {
            String binding;
            block53: {
                block54: {
                    if (Validations.isEmptyOrNull(dde.getName())) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-009");
                        throw new DCTException("ALC-DCT-002-009");
                    }
                    Matcher ddeNameMatcher = alphaNumericUnderscorePatterm.matcher(dde.getName());
                    if (!ddeNameMatcher.matches()) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-037", new String[]{dde.getName(), dde.getPath()});
                        throw new DCTException("ALC-DCT-002-037", new String[]{dde.getName(), dde.getPath()});
                    }
                    if (dde.getElementType() == null) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-025", new String[]{dde.getName()});
                        throw new DCTException("ALC-DCT-002-025", new String[]{dde.getName()});
                    }
                    if (dde.getElementType() == DataDictionaryElementType.COMPOSITE || dde.isComputed()) break block52;
                    if (dde.getBinding() == null || Validations.isEmptyOrNull(dde.getBinding().getBindingName())) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-033", new String[]{dde.getName(), dde.getPath()});
                        throw new DCTException("ALC-DCT-002-033", new String[]{dde.getName(), dde.getPath()});
                    }
                    binding = dde.getBinding().getBindingName().trim();
                    if (binding.contains("\\")) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-064", new String[]{dde.getName(), dde.getPath(), "\\\\"});
                        throw new DCTException("ALC-DCT-002-064", new String[]{dde.getName(), dde.getPath(), "\\\\"});
                    }
                    if (isCollectionChild) break block53;
                    if (dataDictionaryValidationInfo.get(BINDING_TYPE) != null) break block54;
                    if (binding.contains("/")) {
                        if (!binding.startsWith("/")) {
                            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                            throw new DCTException("ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                        }
                        dataDictionaryValidationInfo.put(BINDING_TYPE, BINDING_TYPE_XML);
                        int indexOfSecondSlash = binding.indexOf("/", 1);
                        if (indexOfSecondSlash == -1 || indexOfSecondSlash == binding.length() - 1) {
                            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                            throw new DCTException("ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                        }
                        dataDictionaryValidationInfo.put(ROOT_ELEMENT_IN_BINDING, binding.substring(0, indexOfSecondSlash + 1));
                        break block52;
                    } else {
                        if (!binding.contains(".")) {
                            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                            throw new DCTException("ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                        }
                        dataDictionaryValidationInfo.put(BINDING_TYPE, BINDING_TYPE_POJO);
                        int indexOfDot = binding.indexOf(".", 0);
                        if (indexOfDot == -1 || indexOfDot == binding.length() - 1) {
                            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                            throw new DCTException("ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                        }
                        dataDictionaryValidationInfo.put(ROOT_ELEMENT_IN_BINDING, binding.substring(0, indexOfDot + 1));
                    }
                    break block52;
                }
                if (dataDictionaryValidationInfo.get(BINDING_TYPE).equals(BINDING_TYPE_XML)) {
                    if (!binding.startsWith("/")) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                        throw new DCTException("ALC-DCT-002-066", new String[]{dde.getName(), dde.getPath(), binding});
                    }
                    if (!(dataDictionaryValidationInfo.get(ROOT_ELEMENT_IN_BINDING) == null || binding.startsWith(dataDictionaryValidationInfo.get(ROOT_ELEMENT_IN_BINDING)) && binding.length() > dataDictionaryValidationInfo.get(ROOT_ELEMENT_IN_BINDING).length())) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-065", new String[]{dde.getName(), dde.getPath()});
                        throw new DCTException("ALC-DCT-002-065", new String[]{dde.getName(), dde.getPath()});
                    }
                    break block52;
                } else if (dataDictionaryValidationInfo.get(BINDING_TYPE).equals(BINDING_TYPE_POJO)) {
                    if (binding.contains("/")) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-064", new String[]{dde.getName(), dde.getPath(), "/"});
                        throw new DCTException("ALC-DCT-002-064", new String[]{dde.getName(), dde.getPath(), "/"});
                    }
                    if (!(dataDictionaryValidationInfo.get(ROOT_ELEMENT_IN_BINDING) == null || binding.startsWith(dataDictionaryValidationInfo.get(ROOT_ELEMENT_IN_BINDING)) && binding.length() > dataDictionaryValidationInfo.get(ROOT_ELEMENT_IN_BINDING).length())) {
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-065", new String[]{dde.getName(), dde.getPath()});
                        throw new DCTException("ALC-DCT-002-065", new String[]{dde.getName(), dde.getPath()});
                    }
                }
                break block52;
            }
            if (dataDictionaryValidationInfo.get(BINDING_TYPE) != null && dataDictionaryValidationInfo.get(BINDING_TYPE).equals(BINDING_TYPE_POJO) && binding.contains("/")) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-064", new String[]{dde.getName(), dde.getPath(), "/"});
                throw new DCTException("ALC-DCT-002-064", new String[]{dde.getName(), dde.getPath(), "/"});
            }
        }
        if (dde.isComputed() && (dde.getElementType() == DataDictionaryElementType.COMPOSITE || dde.getElementType() == DataDictionaryElementType.COLLECTION)) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-031", new String[]{dde.getName(), dde.getPath()});
            throw new DCTException("ALC-DCT-002-031", new String[]{dde.getName(), dde.getPath()});
        }
        if (dde.isComputed() && dde.isRequired()) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-027", new String[]{dde.getName(), dde.getPath()});
            throw new DCTException("ALC-DCT-002-027", new String[]{dde.getName(), dde.getPath()});
        }
        if (dde.isComputed() && Validations.isEmptyOrNull(dde.getExpression())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-030", new String[]{dde.getName(), dde.getPath()});
            throw new DCTException("ALC-DCT-002-030", new String[]{dde.getName(), dde.getPath()});
        }
        if (dde.isComputed() && dde.getBinding() != null && !Validations.isEmptyOrNull(dde.getBinding().getBindingName())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-040", new String[]{dde.getName(), dde.getPath()});
            throw new DCTException("ALC-DCT-002-040", new String[]{dde.getName(), dde.getPath()});
        }
        if (dde.getElementType() != DataDictionaryElementType.STRING && dde.getElementType() != DataDictionaryElementType.NUMBER && dde.getElementSubType() == DataDictionaryElementSubType.ENUM) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-029", new String[]{dde.getName(), dde.getPath()});
            throw new DCTException("ALC-DCT-002-029", new String[]{dde.getName(), dde.getPath()});
        }
        if (dde.getElementSubType() == DataDictionaryElementSubType.ENUM && (dde.getValueSet() == null || dde.getValueSet().size() == 0)) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-039", new String[]{dde.getName(), dde.getPath()});
            throw new DCTException("ALC-DCT-002-039", new String[]{dde.getName(), dde.getPath()});
        }
        if (dde.getElementSubType() == DataDictionaryElementSubType.ENUM && dde.getElementType() == DataDictionaryElementType.NUMBER) {
            for (String value : dde.getValueSet()) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    throw new DCTException("ALC-DCT-002-067", new String[]{dde.getName(), dde.getPath()}, (Throwable)e);
                }
            }
        }
        if (version != null && version.equals("1.5")) {
            if (Validations.isEmptyOrNull(dde.getDisplayName())) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-026", new String[]{dde.getName()});
                throw new DCTException("ALC-DCT-002-026", new String[]{dde.getName()});
            }
            if (referenceNamesList.contains(dde.getDisplayName())) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-028", new String[]{dde.getName(), dde.getPath()});
                throw new DCTException("ALC-DCT-002-028", new String[]{dde.getName(), dde.getPath()});
            }
            referenceNamesList.add(dde.getDisplayName());
            Matcher ddeDisplayNameMatcher = alphaNumericUnderscorePatterm.matcher(dde.getDisplayName());
            if (!ddeDisplayNameMatcher.matches()) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-034", new String[]{dde.getName(), dde.getPath()});
                throw new DCTException("ALC-DCT-002-034", new String[]{dde.getName(), dde.getPath()});
            }
        } else {
            if (Validations.isEmptyOrNull(dde.getReferenceName())) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-054", new String[]{dde.getName()});
                throw new DCTException("ALC-DCT-002-054", new String[]{dde.getName(), dde.getPath()});
            }
            if (referenceNamesList.contains(dde.getReferenceName())) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-055", new String[]{dde.getName(), dde.getPath()});
                throw new DCTException("ALC-DCT-002-055", new String[]{dde.getName(), dde.getPath()});
            }
            referenceNamesList.add(dde.getReferenceName());
            Matcher ddeReferenceNameMatcher = alphaNumericUnderscorePatterm.matcher(dde.getReferenceName());
            if (!ddeReferenceNameMatcher.matches()) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-056", new String[]{dde.getName(), dde.getPath()});
                throw new DCTException("ALC-DCT-002-056", new String[]{dde.getName(), dde.getPath()});
            }
            if (Validations.containsNullorEmptyKey(dde.getExtendedProperties())) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-061", new String[]{dde.getName(), dde.getPath()});
                throw new DCTException("ALC-DCT-002-061", new String[]{dde.getName(), dde.getPath()});
            }
        }
        if (dde.isComputed() && deletedRefNames != null && (computedExpression = dde.getExpression()) != null) {
            try {
                List<String> expressionVars = ddExpressionService.getExpressionVariables(computedExpression);
                if (expressionVars != null) {
                    for (String expressionVar : expressionVars) {
                        if (!deletedRefNames.contains(expressionVar)) continue;
                        MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-003-031", new String[]{expressionVar, dde.getReferenceName()});
                        throw new DCTException("ALC-DCT-003-031", new String[]{expressionVar, dde.getReferenceName()});
                    }
                }
            }
            catch (EXPException e) {
                throw new DCTException("ALC-DCT-003-017", new String[]{dde.getExpression()}, (Throwable)e);
            }
        }
        if (dde.getElementType() == DataDictionaryElementType.COMPOSITE) {
            if (dde.getChildElements() == null || dde.getChildElements().size() == 0) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-032", new String[]{dde.getName(), dde.getPath()});
                throw new DCTException("ALC-DCT-002-032", new String[]{dde.getName(), dde.getPath()});
            }
            childNames = new ArrayList<String>();
            i$ = dde.getChildElements().iterator();
        } else {
            if (dde.getElementType() != DataDictionaryElementType.COLLECTION) return;
            if (dde.getCollectionElement() == null) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-032", new String[]{dde.getName()});
                throw new DCTException("ALC-DCT-002-032", new String[]{dde.getName()});
            }
            if (dde.getCollectionElement().getElementType() == null) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-025", new String[]{dde.getName()});
                throw new DCTException("ALC-DCT-002-025", new String[]{dde.getName()});
            }
            if (dde.getCollectionElement().isRequired() || dde.getCollectionElement().isComputed()) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-038", new String[]{dde.getName()});
                throw new DCTException("ALC-DCT-002-038", new String[]{dde.getName()});
            }
            if (dde.getCollectionElement().getElementType() != DataDictionaryElementType.COMPOSITE) return;
            for (DataDictionaryElement childDDE : dde.getCollectionElement().getChildElements()) {
                Validations.validateDataDictionaryElement(childDDE, referenceNamesList, version, dataDictionaryValidationInfo, ddExpressionService, deletedRefNames, true);
            }
            return;
        }
        while (i$.hasNext()) {
            DataDictionaryElement childDDE = i$.next();
            if (childDDE.getName() != null && childNames.contains(childDDE.getName())) {
                MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-041", new String[]{dde.getName(), dde.getPath(), childDDE.getName()});
                throw new DCTException("ALC-DCT-002-041", new String[]{dde.getName(), dde.getPath(), childDDE.getName()});
            }
            Validations.validateDataDictionaryElement(childDDE, referenceNamesList, version, dataDictionaryValidationInfo, ddExpressionService, deletedRefNames, isCollectionChild);
            childNames.add(childDDE.getName());
        }
    }

    public static boolean isEmptyOrNull(String input) {
        return input == null || input.trim().equals("");
    }

    private static boolean isAlphaNumeric(String input) {
        Matcher inputStringMatcher = alphaNumericPatterm.matcher(input);
        return inputStringMatcher.matches();
    }

    private static boolean containsNullorEmptyKey(Map<String, String> m) {
        if (m == null) {
            return false;
        }
        for (Map.Entry<String, String> pairs : m.entrySet()) {
            if (pairs.getKey() != null && !pairs.getKey().equals("")) continue;
            return true;
        }
        return false;
    }
}

