/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.annotations;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScannedAnnotation {
    protected final String name;
    protected final Map<String, Object> values;

    public ScannedAnnotation(String name, Map<String, Object> values) {
        this.name = name;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        int pos = this.name.lastIndexOf(46);
        return this.name.substring(pos + 1);
    }

    public Object getValue(String paramName) {
        if (this.values != null) {
            return this.values.get(paramName);
        }
        return null;
    }

    public boolean getBooleanValue(String name, boolean defaultValue) {
        Object val = this.getValue(name);
        if (val != null) {
            return (Boolean)val;
        }
        return defaultValue;
    }

    public int getIntegerValue(String name, int defaultValue) {
        Object val = this.getValue(name);
        if (val != null) {
            return (Integer)val;
        }
        return defaultValue;
    }

    public long getLongValue(String name, long defaultValue) {
        Object val = this.getValue(name);
        if (val != null) {
            return ((Long)val).intValue();
        }
        return defaultValue;
    }

    public String getStringValue(String name, String defaultValue) {
        Object val = this.getValue(name);
        if (val != null && val.toString().trim().length() > 0) {
            return val.toString().trim();
        }
        return defaultValue;
    }

    public String getEnumValue(String name, String defaultValue) {
        Object val = this.getValue(name);
        if (val != null) {
            if (val instanceof String[]) {
                return ((String[])val)[1];
            }
            if (val instanceof String[][]) {
                return ((String[][])val)[0][1];
            }
            return val.toString();
        }
        return defaultValue;
    }

    public String toString() {
        return "AnnotationDescription [name=" + this.name + ", values=" + this.values + "]";
    }
}

