/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.dct.exception.DCTException;
import com.adobe.dct.exception.LogLevels;
import com.adobe.dct.exception.MessageLogger;
import com.adobe.dct.transfer.DataDictionary;
import com.adobe.dct.transfer.DataDictionaryElement;
import com.adobe.dct.transfer.DataDictionaryElementType;
import com.adobe.dct.util.Validations;
import com.adobe.icc.dbforms.obj.LocalizationResourceInfo;
import com.adobe.icc.dbforms.util.XMLHelperUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBUtils {
    public static String NVL(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String stringDefault(String string, String sDefaultString) {
        return DBUtils.NVL(string).equals("") ? sDefaultString : string;
    }

    public static String getParameter(String sParameterName, HttpServletRequest request, String sDefaultValue) {
        String[] stringArray;
        String result = null;
        Map params = request.getParameterMap();
        Object parameterObject = params.get(sParameterName);
        if (parameterObject == null) {
            result = sDefaultValue;
        } else if (parameterObject instanceof String) {
            result = (String)parameterObject;
        } else if (parameterObject instanceof String[] && (stringArray = (String[])parameterObject).length > 0) {
            result = stringArray[0];
        }
        return DBUtils.stringDefault(result, sDefaultValue);
    }

    public static String getDisplayName(int state) {
        switch (state) {
            case 5: {
                return "Published";
            }
            case 3: {
                return "Modified";
            }
            case 4: {
                return "ReadyToPublish";
            }
        }
        return "";
    }

    public static String createCanonicalPath(String ddePath, DataDictionary dataDictionary) throws DCTException {
        if (dataDictionary == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-001");
            throw new DCTException("ALC-DCT-002-001");
        }
        if (ddePath == null) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-043", new String[]{"ddePath"});
            throw new DCTException("ALC-DCT-002-043", new String[]{"ddePath"});
        }
        String[] elementNames = ddePath.split("\\.");
        StringBuilder canocialPathSoFar = new StringBuilder();
        DataDictionaryElement selectedDDE = dataDictionary.getDDElements().get(0);
        if (!elementNames[0].equals(selectedDDE.getName())) {
            MessageLogger.logMessage(Validations.class, LogLevels.LOG_ERROR, "ALC-DCT-002-044", new String[]{ddePath, elementNames[0]});
            throw new DCTException("ALC-DCT-002-044", new String[]{ddePath, elementNames[0]});
        }
        canocialPathSoFar.append(selectedDDE.getName());
        for (int index = 1; index < elementNames.length; ++index) {
            if (selectedDDE.getElementType().equals(DataDictionaryElementType.COMPOSITE)) {
                for (DataDictionaryElement childElement : selectedDDE.getChildElements()) {
                    if (!childElement.getName().equals(elementNames[index])) continue;
                    selectedDDE = childElement;
                }
            } else if (selectedDDE.getElementType().equals(DataDictionaryElementType.COLLECTION) && selectedDDE.getCollectionElement().getElementType() == DataDictionaryElementType.COMPOSITE) {
                for (DataDictionaryElement childElement : selectedDDE.getCollectionElement().getChildElements()) {
                    if (!childElement.getName().equals(elementNames[index])) continue;
                    selectedDDE = childElement;
                }
            }
            if (selectedDDE.getElementType().equals(DataDictionaryElementType.COLLECTION) && selectedDDE.getName().equals(elementNames[index])) {
                canocialPathSoFar.append(".").append(elementNames[index]).append("[]");
                continue;
            }
            canocialPathSoFar.append(".").append(elementNames[index]);
        }
        return canocialPathSoFar.toString();
    }

    public static LocalizationResourceInfo getLocalizationResourceInfo(List<LocalizationResourceInfo> infoList, String locale) {
        if (infoList == null || locale == null) {
            return null;
        }
        for (LocalizationResourceInfo resourceInfo : infoList) {
            if (!locale.equals(resourceInfo.getLocale())) continue;
            return resourceInfo;
        }
        return null;
    }

    public static Element getControlDataRoot(XMLHelperUtil data) {
        Element iccRoot = null;
        Element xmlRoot = data.getXmlDocument().getRootElement();
        Element dataRoot = xmlRoot.getQualifiedName().equals("xfa:data") ? (Element)xmlRoot.elements().get(0) : xmlRoot;
        Iterator elIt = dataRoot.elementIterator();
        while (elIt.hasNext()) {
            Element el = (Element)elIt.next();
            if (!el.getQualifiedName().equals("icc:icc")) continue;
            iccRoot = el;
            break;
        }
        return iccRoot;
    }

    public static Element getChildNode(Element parent, String nodeName) {
        Element childNode = (Element)parent.selectSingleNode(nodeName);
        if (childNode == null) {
            childNode = new DOMElement(nodeName);
            parent.add(childNode);
        }
        return childNode;
    }
}

