/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import com.adobe.aemds.guide.utils.GuideModelUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitDataCollector {
    protected Logger logger = LoggerFactory.getLogger(SubmitDataCollector.class);
    private StringWriter stringWriter;
    protected CustomJSONWriter jsonWriter;
    protected JSONObject mergeJson;
    protected JSONObject templateJson;
    protected JSONArray fileAttachments;
    protected DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    protected Document dataDoc;
    protected Node currentRepeatNode;
    protected Node currentRepeatUnboundNode;
    protected String currentRepeatRelativePath = "";
    protected String currentRepeatFullPath = "";
    protected boolean startsWithAfData;
    private String xdpValue;
    XPath xPath = XPathFactory.newInstance().newXPath();

    public SubmitDataCollector(String mergeJsonString, JSONObject templateJson, String guidePrefillXml, String xdpValue) {
        try {
            this.mergeJson = new JSONObject(mergeJsonString);
            this.templateJson = templateJson;
            this.stringWriter = new StringWriter();
            this.jsonWriter = new CustomJSONWriter(this.stringWriter);
            this.fileAttachments = new JSONArray();
            this.xdpValue = xdpValue;
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            if (guidePrefillXml == null) {
                this.generateFullXml(db);
            } else {
                this.dataDoc = db.parse(new ByteArrayInputStream(guidePrefillXml.getBytes("UTF-8")));
                this.startsWithAfData = this.dataDoc.getDocumentElement().getTagName().equals("afData");
                this.updatePrefillXML();
            }
            this.currentRepeatNode = this.getInitialRepeatNode();
            this.currentRepeatUnboundNode = this.getInitialRepeatUnboundNode();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONObject collectSubmitData() {
        JSONObject guideResult;
        try {
            this.jsonWriter.object();
            this.jsonWriter.key("guideValue").object();
            this.getKeyValueFromGuideDom(this.mergeJson, this.templateJson);
            this.jsonWriter.endObject();
            this.jsonWriter.key("fileAttachmentsList").value(this.fileAttachments);
            if (this.dataDoc != null) {
                this.jsonWriter.key("dataXml").value(XMLUtils.getXMLfromXsdDom(this.dataDoc.getDocumentElement()));
                this.jsonWriter.key("dorDataXml").value(GuideModelUtils.getDataForDORMerge(this.dataDoc, this.templateJson));
            }
            this.jsonWriter.endObject();
            guideResult = new JSONObject(this.stringWriter.toString());
        }
        catch (Exception e) {
            this.logger.error("Unable to create JSON for Submit", (Throwable)e);
            throw new GuideException(e);
        }
        return guideResult;
    }

    private void createBoundAndUnboundWrapper(DocumentBuilder db) {
        DOMImplementation domImpl = db.getDOMImplementation();
        this.dataDoc = domImpl.createDocument(null, null, null);
        String dataDocumentRoot = "afData";
        Element root = this.dataDoc.createElement(dataDocumentRoot);
        this.dataDoc.appendChild(root);
        Element afUnboundData = this.createUnboundTag(root);
        this.createDataTag(afUnboundData);
        Element afBoundData = this.createBoundTag(root);
        Element dataInBoundData = this.createDataTag(afBoundData);
        if (StringUtils.isEmpty((String)this.xdpValue)) {
            dataInBoundData.setAttribute("xmlns:xfa", "http://www.xfa.org/schema/xfa-data/1.0/");
        }
    }

    protected void addBoundPartToDataXml() {
        try {
            DocumentBuilder db;
            Document xdpDoc;
            Node afBoundData = (Node)this.xPath.evaluate("afBoundData", this.dataDoc.getDocumentElement(), XPathConstants.NODE);
            Node dataInsideAfBounddata = (Node)this.xPath.evaluate("*", afBoundData, XPathConstants.NODE);
            if (this.xdpValue != null && this.xdpValue.length() > 0 && (xdpDoc = (db = this.dbf.newDocumentBuilder()).parse(new ByteArrayInputStream(this.xdpValue.getBytes("UTF-8")))) != null) {
                Node elemDoc = this.dataDoc.importNode(xdpDoc.getDocumentElement(), true);
                if (dataInsideAfBounddata != null) {
                    afBoundData.replaceChild(elemDoc, dataInsideAfBounddata);
                } else {
                    afBoundData.appendChild(elemDoc);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error in adding bound part to xml" + e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    protected void generateFullXml(DocumentBuilder db) {
        this.createBoundAndUnboundWrapper(db);
        this.startsWithAfData = true;
        this.addBoundPartToDataXml();
    }

    protected void updatePrefillXML() throws Exception {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        Document xdpDoc = null;
        Element afBoundData = null;
        if (this.xdpValue != null && this.xdpValue.length() > 0) {
            xdpDoc = db.parse(new ByteArrayInputStream(this.xdpValue.getBytes("UTF-8")));
            if (this.startsWithAfData) {
                if (xdpDoc != null) {
                    afBoundData = this.createBoundTag(this.dataDoc.getDocumentElement());
                    Node elemDoc = this.dataDoc.importNode(xdpDoc.getDocumentElement(), true);
                    afBoundData.appendChild(elemDoc);
                }
            } else {
                this.generateFullXml(db);
            }
        }
    }

    protected Node getInitialRepeatNode() throws Exception {
        return this.getInitialRepeatUnboundNode();
    }

    protected Node getInitialRepeatUnboundNode() throws Exception {
        if (this.startsWithAfData) {
            return (Node)this.xPath.evaluate("afUnboundData/data", this.dataDoc.getDocumentElement(), XPathConstants.NODE);
        }
        if (this.xdpValue != null && this.xdpValue.length() > 0) {
            return null;
        }
        return this.dataDoc.getDocumentElement();
    }

    protected Element createDataTag(Element root) {
        Element data = this.dataDoc.createElement("data");
        root.appendChild(data);
        return data;
    }

    protected Element createBoundTag(Element root) {
        Element afBoundData = this.dataDoc.createElement("afBoundData");
        root.appendChild(afBoundData);
        return afBoundData;
    }

    protected Element createUnboundTag(Element root) {
        Element afUnboundData = this.dataDoc.createElement("afUnboundData");
        root.appendChild(afUnboundData);
        return afUnboundData;
    }

    protected boolean needRepeatHandling(JSONObject jsonObject) {
        return this.xdpValue == null || this.xdpValue.length() <= 0;
    }

    private void getKeyValueFromGuideDom(JSONObject mergeJson, JSONObject templateJson) throws Exception {
        String guideNodeClass = null;
        boolean isFileUpload = false;
        boolean isButton = false;
        if (mergeJson.has("guideNodeClass")) {
            guideNodeClass = mergeJson.getString("guideNodeClass");
        }
        if (GuideUtils.isGuideFileUploadModel(guideNodeClass)) {
            String attachmentId = null;
            attachmentId = this.getGuideNodeId(mergeJson, attachmentId);
            this.fileAttachments.put((Object)attachmentId);
            isFileUpload = true;
        }
        if (GuideUtils.isGuideButtonModel(guideNodeClass)) {
            isButton = true;
        }
        if (GuideUtils.isGuideFieldModel(guideNodeClass) && !isButton && !isFileUpload) {
            if (this.addToBoundData(templateJson)) {
                this.updateBoundField(mergeJson, templateJson);
            }
            if (this.addToUnBoundData(templateJson)) {
                this.updateUnBoundField(mergeJson, templateJson);
            }
        }
        Iterator templateKeys = templateJson.keys();
        while (templateKeys.hasNext()) {
            String templateKey = (String)templateKeys.next();
            Object templateValue = templateJson.get(templateKey);
            if (templateValue instanceof JSONObject && !"layout".equals(templateKey)) {
                JSONObject templateChild = (JSONObject)templateValue;
                String templateChildName = null;
                List<Object> mergeChildJsonList = null;
                if (templateChild.has("guideNodeClass") && templateChild.has("name")) {
                    templateChildName = templateChild.getString("name");
                    boolean templateChildRepeatable = this.isRepeatable(templateChild);
                    mergeChildJsonList = this.getMergedJson(mergeJson, templateChildName, templateChildRepeatable);
                } else if (mergeJson.has(templateKey)) {
                    mergeChildJsonList = new ArrayList();
                    JSONObject mergeChildValue = (JSONObject)mergeJson.get(templateKey);
                    mergeJson.remove(templateKey);
                    mergeChildJsonList.add(mergeChildValue);
                } else {
                    if (templateKey.equals("file")) continue;
                    this.logger.warn("templateKey not found in merge json:" + templateKey);
                    continue;
                }
                boolean repeatable = this.isRepeatable(templateChild);
                if (repeatable && this.needRepeatHandling(templateChild)) {
                    this.handleRepeatJson(mergeChildJsonList, templateChild);
                    continue;
                }
                if (!mergeChildJsonList.isEmpty()) {
                    this.getKeyValueFromGuideDom((JSONObject)mergeChildJsonList.get(0), templateChild);
                    continue;
                }
                this.logger.warn("no object found in mergeJSON corresponding to templateJson. Key:" + templateKey + templateValue);
                continue;
            }
            if (!(templateValue instanceof JSONArray)) continue;
            this.logger.debug("found an json array in guide node structure that should not happen. Ignoring this. Key:" + templateKey);
        }
    }

    protected void updateCurrentRepeatUnboundNode() {
        this.currentRepeatUnboundNode = this.currentRepeatNode;
    }

    private String getCommonPath(String currentRepeatPath, String originalRepeatPath) {
        String[] originalParts = StringUtils.split((String)originalRepeatPath, (String)"/");
        String[] currentParts = StringUtils.split((String)currentRepeatPath, (String)"/");
        String relativePath = null;
        StringBuilder commonParts = new StringBuilder("");
        for (int i = 0; i < Math.min(originalParts.length, currentParts.length) && originalParts[i].equals(currentParts[i]); ++i) {
            commonParts.append(originalParts[i]);
            commonParts.append("/");
        }
        relativePath = commonParts.toString();
        if (relativePath.length() > 0) {
            relativePath = relativePath.substring(0, relativePath.lastIndexOf("/"));
        }
        return relativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRepeatJson(List<JSONObject> mergeJsonObjects, JSONObject templateJson) throws Exception {
        Node originalRepeatNode = this.currentRepeatNode;
        String originalRepeatRelativePath = this.currentRepeatRelativePath;
        String originalRepeatFullPath = this.currentRepeatFullPath;
        NodeList currentRepeatNodeList = null;
        try {
            this.currentRepeatRelativePath = this.getRelativeRepeatPath(templateJson);
            this.currentRepeatFullPath = this.getFullRepeatPath(templateJson);
            if (!this.currentRepeatRelativePath.isEmpty()) {
                Node parentDataNode = originalRepeatNode;
                if (this.currentRepeatRelativePath.length() > 0 && originalRepeatRelativePath.length() > 0) {
                    String commonPath = this.getCommonPath(this.currentRepeatFullPath, originalRepeatFullPath);
                    if (!commonPath.equals(originalRepeatFullPath)) {
                        if (commonPath.length() == 0) {
                            parentDataNode = this.getInitialRepeatNode();
                        } else {
                            this.currentRepeatRelativePath = StringUtils.substringAfter((String)this.currentRepeatFullPath, (String)(commonPath + "/"));
                            parentDataNode = (Node)this.xPath.evaluate(commonPath, this.getInitialRepeatNode(), XPathConstants.NODE);
                        }
                    } else {
                        parentDataNode = originalRepeatNode;
                    }
                }
                currentRepeatNodeList = (NodeList)this.xPath.evaluate(this.currentRepeatRelativePath, parentDataNode, XPathConstants.NODESET);
                int mergeJsonSize = mergeJsonObjects.size();
                int currentRepeatNodeSize = currentRepeatNodeList.getLength();
                if (currentRepeatNodeSize > mergeJsonSize) {
                    for (int j = mergeJsonSize; j < currentRepeatNodeSize; ++j) {
                        Node repeatNode = currentRepeatNodeList.item(j);
                        repeatNode.getParentNode().removeChild(repeatNode);
                    }
                    currentRepeatNodeSize = mergeJsonSize;
                }
                for (int i = 0; i < mergeJsonSize; ++i) {
                    JSONObject mergeJson = mergeJsonObjects.get(i);
                    if (currentRepeatNodeSize <= i) {
                        this.currentRepeatNode = XMLUtils.createNode(this.dataDoc, this.xPath, parentDataNode, this.currentRepeatRelativePath);
                        if (templateJson.has("bindRef")) {
                            ((Element)this.currentRepeatNode).setAttribute("xfa:dataNode", "dataGroup");
                        }
                    } else {
                        this.currentRepeatNode = currentRepeatNodeList.item(i);
                    }
                    this.updateCurrentRepeatUnboundNode();
                    this.getKeyValueFromGuideDom(mergeJson, templateJson);
                }
            } else {
                this.logger.error("currentRepeatRelativePath is empty for templateJson" + templateJson.toString());
            }
        }
        finally {
            this.currentRepeatNode = originalRepeatNode;
            this.currentRepeatRelativePath = originalRepeatRelativePath;
            this.currentRepeatFullPath = originalRepeatFullPath;
            this.updateCurrentRepeatUnboundNode();
        }
    }

    protected boolean addToBoundData(JSONObject templateJsonObject) {
        return templateJsonObject.has("bindRef");
    }

    protected boolean addToUnBoundData(JSONObject templateJsonObject) {
        return !templateJsonObject.has("bindRef");
    }

    protected void updateUnBoundField(JSONObject jsonObject, JSONObject templateJson) throws JSONException {
        if (jsonObject.has("_value")) {
            String name = jsonObject.getString("name");
            String _value = jsonObject.getString("_value");
            this.jsonWriter.key(name).value(_value);
            if (this.currentRepeatUnboundNode != null) {
                XMLUtils.addToDocument(this.dataDoc, this.xPath, this.currentRepeatUnboundNode, name, _value);
            }
        }
    }

    protected void updateBoundField(JSONObject jsonObject, JSONObject templateJson) throws JSONException, Exception {
    }

    protected String getRelativeRepeatPath(JSONObject templateJsonObject) throws JSONException {
        String bindPath = "";
        if (templateJsonObject.has("name")) {
            bindPath = templateJsonObject.getString("name");
        }
        return bindPath;
    }

    protected String getFullRepeatPath(JSONObject templateJsonObject) throws JSONException {
        return "";
    }

    private String getGuideNodeId(JSONObject jsonObject, String attachmentId) throws JSONException {
        if (jsonObject.has("id") && jsonObject.getString("id").length() > 0) {
            attachmentId = jsonObject.getString("id");
        } else if (jsonObject.has("templateId") && jsonObject.getString("templateId").length() > 0) {
            attachmentId = jsonObject.getString("templateId");
        } else {
            this.logger.error("Guide Object does not have any associated id. Log and ignore it:" + jsonObject.toString());
        }
        return attachmentId;
    }

    private boolean isRepeatable(JSONObject jsonObject) throws JSONException {
        int minOccur = 1;
        int maxOccur = 1;
        if (jsonObject.has("minOccur")) {
            minOccur = jsonObject.getInt("minOccur");
        }
        if (jsonObject.has("maxOccur")) {
            maxOccur = jsonObject.getInt("maxOccur");
        }
        return minOccur != 1 || maxOccur != 1;
    }

    private List<JSONObject> getMergedJson(JSONObject mergedParent, String name, boolean namedTemplateChildRepeatable) throws JSONException {
        LinkedHashMap<String, JSONObject> mergeInstancesMap = new LinkedHashMap<String, JSONObject>();
        Iterator keys = mergedParent.keys();
        while (keys.hasNext()) {
            JSONObject childJson;
            String key = (String)keys.next();
            Object value = mergedParent.get(key);
            if (!(value instanceof JSONObject) || !(childJson = (JSONObject)value).has("name")) continue;
            String childName = childJson.getString("name");
            if (!StringUtils.equals((String)childName, (String)name)) break;
            mergeInstancesMap.put(key, childJson);
            boolean repeatable = namedTemplateChildRepeatable;
            if (repeatable) continue;
        }
        ArrayList<JSONObject> mergeInstances = new ArrayList<JSONObject>();
        for (Map.Entry entry : mergeInstancesMap.entrySet()) {
            mergedParent.remove((String)entry.getKey());
            mergeInstances.add((JSONObject)entry.getValue());
        }
        return mergeInstances;
    }
}

